/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.ContextClient;
import org.apache.linkis.cs.client.LinkisContext;
import org.apache.linkis.cs.client.listener.ContextIDListener;
import org.apache.linkis.cs.client.listener.ContextKeyListener;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.CommonContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextValue;

public class LinkisWorkFlowContext
extends LinkisContext {
    private ContextID contextID;
    private ContextClient contextClient;
    private String user;
    private Map<ContextKey, ContextValue> keyValues = new ConcurrentHashMap<ContextKey, ContextValue>();

    @Override
    public ContextID getContextID() {
        return this.contextID;
    }

    @Override
    public void setContextID(ContextID contextID) {
        this.contextID = contextID;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public ContextValue getContextValue(ContextKey contextKey) throws ErrorException {
        if (this.keyValues.containsKey(contextKey)) {
            return this.keyValues.get(contextKey);
        }
        return this.contextClient.getContextValue(this.contextID, contextKey);
    }

    @Override
    public void setContextKeyAndValue(ContextKeyValue contextKeyValue) throws ErrorException {
        this.contextClient.setContextKeyValue(this.contextID, contextKeyValue);
    }

    @Override
    public void set(ContextKey contextKey, ContextValue contextValue) throws ErrorException {
        this.setLocal(contextKey, contextValue);
        CommonContextKeyValue contextKeyValue = new CommonContextKeyValue();
        contextKeyValue.setContextKey(contextKey);
        contextKeyValue.setContextValue(contextValue);
        this.setContextKeyAndValue((ContextKeyValue)contextKeyValue);
    }

    @Override
    public void setLocal(ContextKey contextKey, ContextValue contextValue) {
        this.keyValues.put(contextKey, contextValue);
    }

    @Override
    public void setLocal(ContextKeyValue contextKeyValue) {
        this.keyValues.put(contextKeyValue.getContextKey(), contextKeyValue.getContextValue());
    }

    @Override
    public List<ContextKeyValue> searchContext(List<ContextType> contextTypes, List<ContextScope> contextScopes, List<String> contains, List<String> regex) throws ErrorException {
        return this.contextClient.search(this.contextID, contextTypes, contextScopes, contains, regex);
    }

    @Override
    public void reset(ContextKey contextKey) throws ErrorException {
        this.contextClient.reset(this.contextID, contextKey);
    }

    @Override
    public void reset() throws ErrorException {
        this.contextClient.reset(this.contextID);
    }

    @Override
    public void remove(ContextKey contextKey) throws ErrorException {
        this.contextClient.remove(this.contextID, contextKey);
    }

    @Override
    public void removeAll() throws ErrorException {
        this.contextClient.remove(this.contextID, null);
    }

    @Override
    public void onBind(ContextIDListener contextIDListener) throws ErrorException {
        contextIDListener.setContextID(this.contextID);
        contextIDListener.setContext(this);
        this.contextClient.bindContextIDListener(contextIDListener);
    }

    @Override
    public void onBind(ContextKey contextKey, ContextKeyListener contextKeyListener) throws ErrorException {
        contextKeyListener.setContextKey(contextKey);
        contextKeyListener.setContext(this);
        this.contextClient.bindContextKeyListener(contextKeyListener);
    }

    public ContextClient getContextClient() {
        return this.contextClient;
    }

    public void setContextClient(ContextClient contextClient) {
        this.contextClient = contextClient;
    }
}

