/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.bml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.bml.protocol.BmlUpdateResponse;
import org.apache.linkis.bml.protocol.BmlUploadResponse;
import org.apache.linkis.filesystem.exception.WorkspaceExceptionManager;
import org.springframework.stereotype.Component;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001e4AAC\u0006\u0001-!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)\u0011\u0005\u0001C\u0001\u0005\")\u0011\u0005\u0001C\u0001\u001f\")1\u000b\u0001C\u0001)\")1\u000b\u0001C\u00013\")Q\f\u0001C\u0001=\")1\r\u0001C\u0005I\")a\r\u0001C\u0005O\nI!)\u0014'IK2\u0004XM\u001d\u0006\u0003\u00195\t1AY7m\u0015\tqq\"\u0001\u0006gS2,7/_:uK6T!\u0001E\t\u0002\r1Lgn[5t\u0015\t\u00112#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005Y\u0011AB;qY>\fG\r\u0006\u0003$yy\u0002\u0005\u0003\u0002\u0013*WYj\u0011!\n\u0006\u0003M\u001d\nA!\u001e;jY*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\ri\u0015\r\u001d\t\u0003YMr!!L\u0019\u0011\u00059JR\"A\u0018\u000b\u0005A*\u0012A\u0002\u001fs_>$h(\u0003\u000233\u00051\u0001K]3eK\u001aL!\u0001N\u001b\u0003\rM#(/\u001b8h\u0015\t\u0011\u0014\u0004\u0005\u00028u5\t\u0001H\u0003\u0002:O\u0005!A.\u00198h\u0013\tY\u0004H\u0001\u0004PE*,7\r\u001e\u0005\u0006{\t\u0001\raK\u0001\tkN,'OT1nK\")qH\u0001a\u0001W\u000591m\u001c8uK:$\b\"B!\u0003\u0001\u0004Y\u0013\u0001\u00034jY\u0016t\u0015-\\3\u0015\u000b\r\u001aE\tT'\t\u000bu\u001a\u0001\u0019A\u0016\t\u000b\u0015\u001b\u0001\u0019\u0001$\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\u001c\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u001e\n!![8\n\u0005-C%aC%oaV$8\u000b\u001e:fC6DQ!Q\u0002A\u0002-BQAT\u0002A\u0002-\n1\u0002\u001d:pU\u0016\u001cGOT1nKR!1\u0005U)S\u0011\u0015iD\u00011\u0001,\u0011\u0015)E\u00011\u0001G\u0011\u0015\tE\u00011\u0001,\u0003\u0019)\b\u000fZ1uKR!1%\u0016,Y\u0011\u0015iT\u00011\u0001,\u0011\u00159V\u00011\u0001,\u0003)\u0011Xm]8ve\u000e,\u0017\n\u001a\u0005\u0006\u000b\u0016\u0001\rA\u0012\u000b\u0005Gi[F\fC\u0003>\r\u0001\u00071\u0006C\u0003X\r\u0001\u00071\u0006C\u0003@\r\u0001\u00071&A\u0003rk\u0016\u0014\u0018\u0010\u0006\u0003$?\u0002\f\u0007\"B\u001f\b\u0001\u0004Y\u0003\"B,\b\u0001\u0004Y\u0003\"\u00022\b\u0001\u0004Y\u0013a\u0002<feNLwN\\\u0001\u0013S:\u0004X\u000f^:ue\u0016lGk\\*ue&tw\r\u0006\u0002,K\")Q\t\u0003a\u0001\r\u0006y1M]3bi\u0016\u0014U\nT\"mS\u0016tG\u000f\u0006\u0002i_B\u0011\u0011.\\\u0007\u0002U*\u00111\u000e\\\u0001\u0007G2LWM\u001c;\u000b\u00051y\u0011B\u00018k\u0005%\u0011U\u000e\\\"mS\u0016tG\u000fC\u0003>\u0013\u0001\u00071\u0006\u000b\u0002\u0001cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u000bgR,'/Z8usB,'B\u0001<\u0014\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017B\u0001=t\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class BMLHelper {
    public Map<String, Object> upload(String userName, String content, String fileName) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes("utf-8"));
        BmlClient client = this.createBMLClient(userName);
        BmlUploadResponse resource = client.uploadResource(userName, fileName, (InputStream)inputStream);
        if (!resource.isSuccess()) {
            throw WorkspaceExceptionManager.createException(80021, new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceId", resource.resourceId());
        map.put("version", resource.version());
        return map;
    }

    public Map<String, Object> upload(String userName, InputStream inputStream, String fileName, String projectName) {
        BmlClient client = this.createBMLClient(userName);
        BmlUploadResponse resource = client.uploadShareResource(userName, projectName, fileName, inputStream);
        if (!resource.isSuccess()) {
            throw WorkspaceExceptionManager.createException(80021, new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceId", resource.resourceId());
        map.put("version", resource.version());
        return map;
    }

    public Map<String, Object> upload(String userName, InputStream inputStream, String fileName) {
        BmlClient client = this.createBMLClient(userName);
        BmlUploadResponse resource = client.uploadResource(userName, fileName, inputStream);
        if (!resource.isSuccess()) {
            throw WorkspaceExceptionManager.createException(80021, new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceId", resource.resourceId());
        map.put("version", resource.version());
        return map;
    }

    public Map<String, Object> update(String userName, String resourceId, InputStream inputStream) {
        BmlClient client = this.createBMLClient(userName);
        BmlUpdateResponse resource = client.updateShareResource(userName, resourceId, "", inputStream);
        if (!resource.isSuccess()) {
            throw WorkspaceExceptionManager.createException(80022, new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceId", resource.resourceId());
        map.put("version", resource.version());
        return map;
    }

    public Map<String, Object> update(String userName, String resourceId, String content) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes("utf-8"));
        BmlClient client = this.createBMLClient(userName);
        BmlUpdateResponse resource = client.updateShareResource(userName, resourceId, new StringBuilder(5).append(UUID.randomUUID().toString()).append(".json").toString(), (InputStream)inputStream);
        if (!resource.isSuccess()) {
            throw WorkspaceExceptionManager.createException(80022, new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceId", resource.resourceId());
        map.put("version", resource.version());
        return map;
    }

    public Map<String, Object> query(String userName, String resourceId, String version) {
        BmlClient client = this.createBMLClient(userName);
        BmlDownloadResponse resource = null;
        resource = version == null ? client.downloadShareResource(userName, resourceId, null) : client.downloadShareResource(userName, resourceId, version);
        if (!resource.isSuccess()) {
            throw WorkspaceExceptionManager.createException(80023, new Object[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("path", resource.fullFilePath());
        map.put("stream", resource.inputStream());
        return map;
    }

    private String inputstremToString(InputStream inputStream) {
        return Source$.MODULE$.fromInputStream(inputStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private BmlClient createBMLClient(String userName) {
        if (userName == null) {
            return BmlClientFactory.createBmlClient();
        }
        return BmlClientFactory.createBmlClient((String)userName);
    }
}

