/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.basedatamanager.server.restful;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.basedatamanager.server.domain.RmExternalResourceProviderEntity;
import org.apache.linkis.basedatamanager.server.service.RmExternalResourceProviderService;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RmExternalResourceProviderRestfulApi"})
@RestController
@RequestMapping(path={"/basedata-manager/rm-external-resource-provider"})
public class RmExternalResourceProviderRestfulApi {
    @Autowired
    RmExternalResourceProviderService rmExternalResourceProviderService;

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="searchName"), @ApiImplicitParam(paramType="query", dataType="int", name="currentPage"), @ApiImplicitParam(paramType="query", dataType="int", name="pageSize")})
    @ApiOperation(value="list", notes="list Resource manager External Resource Providers", httpMethod="GET")
    @RequestMapping(path={""}, method={RequestMethod.GET})
    public Message list(HttpServletRequest request, String searchName, Integer currentPage, Integer pageSize) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Query list data of Resource manager External Resource Provider,search name:" + searchName));
        PageInfo pageList = this.rmExternalResourceProviderService.getListByPage(searchName, currentPage, pageSize);
        return Message.ok((String)"").data("list", (Object)pageList);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="get", notes="Get a Resource manager External Resource Provider Record by id", httpMethod="GET")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.GET})
    public Message get(HttpServletRequest request, @PathVariable(value="id") Long id) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Get a Resource manager External Resource Provider Record,id:" + id.toString()));
        RmExternalResourceProviderEntity rmExternalResourceProvider = (RmExternalResourceProviderEntity)this.rmExternalResourceProviderService.getById(id);
        return Message.ok((String)"").data("item", (Object)rmExternalResourceProvider);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="RmExternalResourceProviderEntity", name="rmExternalResourceProvider")})
    @ApiOperation(value="add", notes="Add a Resource manager External Resource Provider Record", httpMethod="POST")
    @RequestMapping(path={""}, method={RequestMethod.POST})
    public Message add(HttpServletRequest request, @RequestBody RmExternalResourceProviderEntity rmExternalResourceProvider) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Add a Resource manager External Resource Provider Record," + rmExternalResourceProvider.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.rmExternalResourceProviderService.save(rmExternalResourceProvider);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="remove", notes="Remove a Resource manager External Resource Provider Record by id", httpMethod="DELETE")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.DELETE})
    public Message remove(HttpServletRequest request, @PathVariable(value="id") Long id) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Try to remove resource external resource provider record with id:" + id.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.rmExternalResourceProviderService.removeById(id);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="RmExternalResourceProviderEntity", name="rmExternalResourceProvider")})
    @ApiOperation(value="update", notes="Update a Resource manager External Resource Provider Record", httpMethod="PUT")
    @RequestMapping(path={""}, method={RequestMethod.PUT})
    public Message update(HttpServletRequest request, @RequestBody RmExternalResourceProviderEntity rmExternalResourceProvider) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Update a Resource manager External Resource Provider Record,id:" + rmExternalResourceProvider.getId().toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.rmExternalResourceProviderService.updateById(rmExternalResourceProvider);
        return Message.ok((String)"").data("result", (Object)result);
    }
}

