/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.scheduler.queue;

import java.io.Serializable;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.scheduler.queue.ConsumeQueue;
import org.apache.linkis.scheduler.queue.Group;
import org.apache.linkis.scheduler.queue.SchedulerEvent;
import org.apache.linkis.scheduler.queue.SchedulerEventState$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u00192\u0001qB\u0001\"\u0013\u0001\u0003\u0002\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0019!C\u0001\u001f\"A\u0001\f\u0001B\u0001B\u0003&1\nC\u0003Z\u0001\u0011\u0005!\fC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\u0015\u0004\u0001\u0015!\u0003`\u0011\u001d1\u0007A1A\u0005\n\u001dDaa\u001b\u0001!\u0002\u0013A\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007e\u0002\u0001\u000b\u0011\u00028\t\u000fM\u0004!\u0019!C\u0005[\"1A\u000f\u0001Q\u0001\n9Dq!\u001e\u0001A\u0002\u0013%q\rC\u0004w\u0001\u0001\u0007I\u0011B<\t\re\u0004\u0001\u0015)\u0003i\u0011\u001dQ\b\u00011A\u0005\n\u001dDqa\u001f\u0001A\u0002\u0013%A\u0010\u0003\u0004\u007f\u0001\u0001\u0006K\u0001\u001b\u0005\b\u007f\u0002\u0001\r\u0011\"\u0003h\u0011%\t\t\u0001\u0001a\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\b\u0001\u0001\u000b\u0015\u00025\t\u0011\u0005%\u0001\u00011Q\u0005\u0012\u001dD\u0011\"a\u0003\u0001\u0001\u0004&\t\"!\u0004\t\u000f\u0005E\u0001\u0001)Q\u0005Q\"1\u00111\u0003\u0001\u0005\n\u001dDq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002$\u0001!\t%!\n\t\r\u0005%\u0002\u0001\"\u0011h\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!!\u000e\u0001\t\u0003\ni\u0003C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u00111\b\u0001\u0005B\u0005\u001d\u0003BBA'\u0001\u0011\u0005#\nC\u0004\u0002P\u0001!\t%!\u0015\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004BBA<\u0001\u0011\u0005s\r\u0003\u0004\u0002z\u0001!\ta\u001a\u0005\u0007\u0003w\u0002A\u0011A4\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003\u0017\u0003A\u0011IAH\u0011\u001d\tY\n\u0001C!\u0003;Cq!a(\u0001\t\u0003\ni\nC\u0004\u0002 \u0002!\t%!)\u0003\u001d1{w\u000e]!se\u0006L\u0018+^3vK*\u0011!gM\u0001\u0006cV,W/\u001a\u0006\u0003iU\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005Y:\u0014A\u00027j].L7O\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<7\u0001A\n\u0004\u0001u\n\u0005C\u0001 @\u001b\u0005\t\u0014B\u0001!2\u00051\u0019uN\\:v[\u0016\fV/Z;f!\t\u0011u)D\u0001D\u0015\t!U)A\u0003vi&d7O\u0003\u0002Gk\u000511m\\7n_:L!\u0001S\"\u0003\u000f1{wmZ5oO\u0006)qM]8vaV\t1\n\u0005\u0002?\u0019&\u0011Q*\r\u0002\u0006\u000fJ|W\u000f]\u0001\nOJ|W\u000f]0%KF$\"\u0001\u0015,\u0011\u0005E#V\"\u0001*\u000b\u0003M\u000bQa]2bY\u0006L!!\u0016*\u0003\tUs\u0017\u000e\u001e\u0005\b/\n\t\t\u00111\u0001L\u0003\rAH%M\u0001\u0007OJ|W\u000f\u001d\u0011\u0002\rqJg.\u001b;?)\tYF\f\u0005\u0002?\u0001!)\u0011\n\u0002a\u0001\u0017\u0006QQM^3oiF+X-^3\u0016\u0003}\u00032!\u00151c\u0013\t\t'KA\u0003BeJ\f\u0017\u0010\u0005\u0002RG&\u0011AM\u0015\u0002\u0004\u0003:L\u0018aC3wK:$\u0018+^3vK\u0002\n1\"\\1y\u0007\u0006\u0004\u0018mY5usV\t\u0001\u000e\u0005\u0002RS&\u0011!N\u0015\u0002\u0004\u0013:$\u0018\u0001D7bq\u000e\u000b\u0007/Y2jif\u0004\u0013!C<sSR,Gj\\2l+\u0005q\u0007cA)a_B\u0011\u0011\u000b]\u0005\u0003cJ\u0013AAQ=uK\u0006QqO]5uK2{7m\u001b\u0011\u0002\u0011I,\u0017\r\u001a'pG.\f\u0011B]3bI2{7m\u001b\u0011\u0002\t\u0019d\u0017mZ\u0001\tM2\fwm\u0018\u0013fcR\u0011\u0001\u000b\u001f\u0005\b/:\t\t\u00111\u0001i\u0003\u00151G.Y4!\u0003\u0011!\u0018-\u001b7\u0002\u0011Q\f\u0017\u000e\\0%KF$\"\u0001U?\t\u000f]\u000b\u0012\u0011!a\u0001Q\u0006)A/Y5mA\u0005IA/Y6f\u0013:$W\r_\u0001\u000ei\u0006\\W-\u00138eKb|F%Z9\u0015\u0007A\u000b)\u0001C\u0004X)\u0005\u0005\t\u0019\u00015\u0002\u0015Q\f7.Z%oI\u0016D\b%\u0001\u0005sK\u0006d7+\u001b>f\u00031\u0011X-\u00197TSj,w\fJ3r)\r\u0001\u0016q\u0002\u0005\b/^\t\t\u00111\u0001i\u0003%\u0011X-\u00197TSj,\u0007%\u0001\u0006gS2dW\rZ*ju\u0016\faA]3n_Z,Gc\u0001)\u0002\u001a!9\u00111\u0004\u000eA\u0002\u0005u\u0011!B3wK:$\bc\u0001 \u0002 %\u0019\u0011\u0011E\u0019\u0003\u001dM\u001b\u0007.\u001a3vY\u0016\u0014XI^3oi\u0006\u0001r-\u001a;XC&$\u0018N\\4Fm\u0016tGo]\u000b\u0003\u0003O\u0001B!\u00151\u0002\u001e\u0005!1/\u001b>f\u0003\u001dI7/R7qif,\"!a\f\u0011\u0007E\u000b\t$C\u0002\u00024I\u0013qAQ8pY\u0016\fg.\u0001\u0004jg\u001a+H\u000e\\\u0001\tG2,\u0017M]!mYR\t\u0001+A\u0002hKR$B!a\u0010\u0002FA)\u0011+!\u0011\u0002\u001e%\u0019\u00111\t*\u0003\r=\u0003H/[8o\u0011\u001d\tY\u0002\ta\u0001\u0003;!B!a\u0010\u0002J!1\u00111J\u0011A\u0002!\fQ!\u001b8eKb\f\u0001bZ3u\u000fJ|W\u000f]\u0001\tg\u0016$xI]8vaR\u0019\u0001+a\u0015\t\u000b%\u001b\u0003\u0019A&\u0002\u0019Q|\u0017J\u001c3fq\u0016$7+Z9\u0016\u0005\u0005e\u0003CBA.\u0003W\niB\u0004\u0003\u0002^\u0005\u001dd\u0002BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\r4(\u0001\u0004=e>|GOP\u0005\u0002'&\u0019\u0011\u0011\u000e*\u0002\u000fA\f7m[1hK&!\u0011QNA8\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\u0006\u0004\u0003S\u0012\u0016aA1eIR\u0019\u0001.!\u001e\t\u000f\u0005mQ\u00051\u0001\u0002\u001e\u0005Yq/Y5uS:<7+\u001b>f\u0003\ri\u0017N\\\u0001\u0004[\u0006D\u0018a\u00019viR\u0019\u0001.!!\t\u000f\u0005m\u0011\u00061\u0001\u0002\u001e\u0005)qN\u001a4feR!\u0011qQAE!\u0011\t\u0016\u0011\t5\t\u000f\u0005m!\u00061\u0001\u0002\u001e\u0005!A/Y6f)\t\ti\u0002\u0006\u0003\u0002@\u0005E\u0005bBAJY\u0001\u0007\u0011QS\u0001\u0006[&dGn\u001d\t\u0004#\u0006]\u0015bAAM%\n!Aj\u001c8h\u0003\u0011\u0001x\u000e\u001c7\u0015\u0005\u0005}\u0012\u0001\u00029fK.$B!a\u0010\u0002$\"9\u0011QU\u0018A\u0002\u0005\u001d\u0016AA8q!\u001d\t\u0016\u0011VA\u000f\u0003_I1!a+S\u0005%1UO\\2uS>t\u0017\u0007")
public class LoopArrayQueue
extends ConsumeQueue
implements Logging {
    private Group group;
    private final Object[] eventQueue;
    private final int maxCapacity;
    private final byte[] writeLock;
    private final byte[] readLock;
    private int flag;
    private int tail;
    private int takeIndex;
    private int realSize;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        LoopArrayQueue loopArrayQueue = this;
        synchronized (loopArrayQueue) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Group group() {
        return this.group;
    }

    public void group_$eq(Group x$1) {
        this.group = x$1;
    }

    private Object[] eventQueue() {
        return this.eventQueue;
    }

    private int maxCapacity() {
        return this.maxCapacity;
    }

    private byte[] writeLock() {
        return this.writeLock;
    }

    private byte[] readLock() {
        return this.readLock;
    }

    private int flag() {
        return this.flag;
    }

    private void flag_$eq(int x$1) {
        this.flag = x$1;
    }

    private int tail() {
        return this.tail;
    }

    private void tail_$eq(int x$1) {
        this.tail = x$1;
    }

    private int takeIndex() {
        return this.takeIndex;
    }

    private void takeIndex_$eq(int x$1) {
        this.takeIndex = x$1;
    }

    public int realSize() {
        return this.realSize;
    }

    public void realSize_$eq(int x$1) {
        this.realSize = x$1;
    }

    private int filledSize() {
        if (this.tail() >= this.flag()) {
            return this.tail() - this.flag();
        }
        return this.tail() + this.maxCapacity() - this.flag();
    }

    @Override
    public void remove(SchedulerEvent event) {
        this.get(event).foreach((Function1 & Serializable & scala.Serializable)x -> {
            x.cancel();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public SchedulerEvent[] getWaitingEvents() {
        SchedulerEvent[] schedulerEventArray;
        Object[] objectArray = this.eventQueue();
        synchronized (objectArray) {
            schedulerEventArray = (SchedulerEvent[])((TraversableOnce)this.toIndexedSeq().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LoopArrayQueue.$anonfun$getWaitingEvents$1(x)))).toArray(ClassTag$.MODULE$.apply(SchedulerEvent.class));
        }
        return schedulerEventArray;
    }

    @Override
    public int size() {
        return this.filledSize();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isFull() {
        return this.filledSize() == this.maxCapacity() - 1 && this.takeIndex() == this.realSize();
    }

    @Override
    public void clearAll() {
        Object[] objectArray = this.eventQueue();
        synchronized (objectArray) {
            this.flag_$eq(0);
            this.tail_$eq(0);
            this.realSize_$eq(0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxCapacity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
                $this.eventQueue()[x$1] = null;
            });
        }
    }

    @Override
    public Option<SchedulerEvent> get(SchedulerEvent event) {
        None$ none$;
        Object[] objectArray = this.eventQueue();
        synchronized (objectArray) {
            IndexedSeq eventSeq = ((IndexedSeq)this.toIndexedSeq().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LoopArrayQueue.$anonfun$get$1(event, x)))).seq();
            none$ = eventSeq.size() > 0 ? new Some(eventSeq.apply(0)) : None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<SchedulerEvent> get(int index) {
        SchedulerEvent event = null;
        Object[] objectArray = this.eventQueue();
        synchronized (objectArray) {
            int _max = this.max();
            if (index < this.realSize()) {
                throw new IllegalArgumentException(new StringBuilder(67).append("The index ").append(index).append(" has already been deleted, now index must be better than ").append(this.realSize()).toString());
            }
            if (index > _max) {
                throw new IllegalArgumentException(new StringBuilder(29).append("The index ").append(index).append(" must be less than ").append(_max).toString());
            }
            int _index = (this.flag() + (index - this.realSize())) % this.maxCapacity();
            event = (SchedulerEvent)this.eventQueue()[_index];
        }
        return Option$.MODULE$.apply((Object)event);
    }

    @Override
    public Group getGroup() {
        return this.group();
    }

    @Override
    public void setGroup(Group group) {
        this.group_$eq(group);
    }

    public IndexedSeq<SchedulerEvent> toIndexedSeq() {
        scala.collection.immutable.IndexedSeq indexedSeq;
        if (this.filledSize() == 0) {
            return (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
        }
        Object[] objectArray = this.eventQueue();
        synchronized (objectArray) {
            indexedSeq = (scala.collection.immutable.IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.min()), this.max()).map((Function1 & Serializable & scala.Serializable)x -> LoopArrayQueue.$anonfun$toIndexedSeq$1(this, BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LoopArrayQueue.$anonfun$toIndexedSeq$2(x)));
        }
        return indexedSeq;
    }

    public int add(SchedulerEvent event) {
        Object[] objectArray = this.eventQueue();
        synchronized (objectArray) {
            int index = (this.tail() + 1) % this.maxCapacity();
            if (index == this.flag()) {
                this.flag_$eq((this.flag() + 1) % this.maxCapacity());
                this.realSize_$eq(this.realSize() + 1);
            }
            this.eventQueue()[this.tail()] = event;
            this.tail_$eq(index);
        }
        return this.max();
    }

    @Override
    public int waitingSize() {
        if (this.takeIndex() <= this.realSize()) {
            return this.size();
        }
        int length = this.size() - this.takeIndex() + this.realSize();
        if (length < 0) {
            return 0;
        }
        return length;
    }

    public int min() {
        return this.realSize();
    }

    public int max() {
        int _size;
        block0: {
            _size = this.filledSize();
            if (_size != 0) break block0;
            _size = 1;
        }
        return this.realSize() + _size - 1;
    }

    @Override
    public int put(SchedulerEvent event) {
        int index = -1;
        byte[] byArray = this.writeLock();
        synchronized (byArray) {
            while (this.isFull()) {
                this.writeLock().wait(1000L);
            }
            index = this.add(event);
        }
        byte[] byArray2 = this.readLock();
        synchronized (byArray2) {
            this.readLock().notify();
        }
        return index;
    }

    @Override
    public Option<Object> offer(SchedulerEvent event) {
        int index;
        block8: {
            index = -1;
            byte[] byArray = this.writeLock();
            synchronized (byArray) {
                None$ none$;
                block7: {
                    if (this.isFull()) {
                        none$ = None$.MODULE$;
                        break block7;
                    }
                    index = this.add(event);
                    break block8;
                }
                return none$;
            }
        }
        byte[] byArray = this.readLock();
        synchronized (byArray) {
            this.readLock().notify();
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)index));
    }

    @Override
    public SchedulerEvent take() {
        Option<SchedulerEvent> option;
        byte[] byArray = this.readLock();
        synchronized (byArray) {
            while (this.waitingSize() == 0 || this.takeIndex() > this.max()) {
                this.readLock().wait(1000L);
            }
            if (this.takeIndex() < this.min()) {
                this.takeIndex_$eq(this.min());
            }
            Option<SchedulerEvent> t = this.get(this.takeIndex());
            this.takeIndex_$eq(this.takeIndex() + 1);
            option = t;
        }
        Option<SchedulerEvent> t = option;
        byte[] byArray2 = this.writeLock();
        synchronized (byArray2) {
            this.writeLock().notify();
        }
        return (SchedulerEvent)t.get();
    }

    @Override
    public Option<SchedulerEvent> take(long mills) {
        Option<SchedulerEvent> option;
        block10: {
            byte[] byArray = this.readLock();
            synchronized (byArray) {
                None$ none$;
                block9: {
                    if (this.waitingSize() == 0 || this.takeIndex() > this.max()) {
                        this.readLock().wait(mills);
                    }
                    if (this.waitingSize() == 0 || this.takeIndex() > this.max()) {
                        none$ = None$.MODULE$;
                        break block9;
                    }
                    if (this.takeIndex() < this.min()) {
                        this.takeIndex_$eq(this.min());
                    }
                    Option<SchedulerEvent> t = this.get(this.takeIndex());
                    this.takeIndex_$eq(this.takeIndex() + 1);
                    option = t;
                    break block10;
                }
                return none$;
            }
        }
        Option<SchedulerEvent> t = option;
        byte[] byArray = this.writeLock();
        synchronized (byArray) {
            this.writeLock().notify();
        }
        return t;
    }

    @Override
    public Option<SchedulerEvent> poll() {
        Option<SchedulerEvent> option;
        block11: {
            byte[] byArray = this.readLock();
            synchronized (byArray) {
                None$ none$;
                block10: {
                    int _min = this.min();
                    int _max = this.max();
                    if (this.takeIndex() < _min) {
                        this.takeIndex_$eq(_min);
                    } else if (this.takeIndex() > _max) {
                        this.logger().info(new StringBuilder(46).append("none, notice...max: ").append(_max).append(", takeIndex: ").append(this.takeIndex()).append(", realSize: ").append(this.realSize()).append(".").toString());
                        none$ = None$.MODULE$;
                        break block10;
                    }
                    Option<SchedulerEvent> t = this.get(this.takeIndex());
                    if (t == null) {
                        this.logger().info("null, notice...");
                    }
                    this.takeIndex_$eq(this.takeIndex() + 1);
                    option = t;
                    break block11;
                }
                return none$;
            }
        }
        Option<SchedulerEvent> event = option;
        byte[] byArray = this.writeLock();
        synchronized (byArray) {
            this.writeLock().notify();
        }
        return event;
    }

    @Override
    public Option<SchedulerEvent> peek() {
        Option<SchedulerEvent> option;
        byte[] byArray = this.readLock();
        synchronized (byArray) {
            option = this.waitingSize() == 0 || this.takeIndex() > this.max() ? None$.MODULE$ : (this.takeIndex() < this.min() ? this.get(this.min()) : this.get(this.takeIndex()));
        }
        return option;
    }

    @Override
    public Option<SchedulerEvent> peek(Function1<SchedulerEvent, Object> op) {
        if (this.waitingSize() == 0 || this.takeIndex() > this.max()) {
            return None$.MODULE$;
        }
        if (this.takeIndex() < this.min()) {
            Option<SchedulerEvent> event = this.get(this.min());
            if (BoxesRunTime.unboxToBoolean((Object)op.apply(event.get()))) {
                return event;
            }
            return None$.MODULE$;
        }
        Option<SchedulerEvent> event = this.get(this.takeIndex());
        if (BoxesRunTime.unboxToBoolean((Object)op.apply(event.get()))) {
            return event;
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getWaitingEvents$1(SchedulerEvent x) {
        return x.getState().equals((Object)SchedulerEventState$.MODULE$.Inited()) || x.getState().equals((Object)SchedulerEventState$.MODULE$.Scheduled());
    }

    public static final /* synthetic */ boolean $anonfun$get$1(SchedulerEvent event$1, SchedulerEvent x) {
        return x.getId().equals(event$1.getId());
    }

    public static final /* synthetic */ SchedulerEvent $anonfun$toIndexedSeq$1(LoopArrayQueue $this, int x) {
        return (SchedulerEvent)$this.get(x).get();
    }

    public static final /* synthetic */ boolean $anonfun$toIndexedSeq$2(SchedulerEvent x) {
        SchedulerEvent schedulerEvent = x;
        None$ none$ = None$.MODULE$;
        return schedulerEvent == null ? none$ != null : !schedulerEvent.equals(none$);
    }

    public LoopArrayQueue(Group group) {
        this.group = group;
        Logging.$init$((Logging)this);
        this.eventQueue = new Object[this.group().getMaximumCapacity()];
        this.maxCapacity = this.group().getMaximumCapacity();
        this.writeLock = new byte[0];
        this.readLock = new byte[0];
        this.flag = 0;
        this.tail = 0;
        this.takeIndex = 0;
        this.realSize = 0;
    }
}

