/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.Enumerables;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;

public class TableScanNode
implements Node {
    private TableScanNode(Compiler compiler, TableScan rel, Enumerable<Row> enumerable) {
        compiler.enumerable(rel, enumerable);
    }

    @Override
    public void run() {
    }

    static TableScanNode create(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects) {
        RelOptTable relOptTable = rel.getTable();
        ProjectableFilterableTable pfTable = relOptTable.unwrap(ProjectableFilterableTable.class);
        if (pfTable != null) {
            return TableScanNode.createProjectableFilterable(compiler, rel, filters, projects, pfTable);
        }
        FilterableTable filterableTable = relOptTable.unwrap(FilterableTable.class);
        if (filterableTable != null) {
            return TableScanNode.createFilterable(compiler, rel, filters, projects, filterableTable);
        }
        ScannableTable scannableTable = relOptTable.unwrap(ScannableTable.class);
        if (scannableTable != null) {
            return TableScanNode.createScannable(compiler, rel, filters, projects, scannableTable);
        }
        Enumerable enumerable = relOptTable.unwrap(Enumerable.class);
        if (enumerable != null) {
            return TableScanNode.createEnumerable(compiler, rel, (Enumerable<Row>)enumerable, null, filters, projects);
        }
        QueryableTable queryableTable = relOptTable.unwrap(QueryableTable.class);
        if (queryableTable != null) {
            return TableScanNode.createQueryable(compiler, rel, filters, projects, queryableTable);
        }
        throw new AssertionError((Object)("cannot convert table " + relOptTable + " to enumerable"));
    }

    private static TableScanNode createScannable(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects, ScannableTable scannableTable) {
        Enumerable<Row> rowEnumerable = Enumerables.toRow(scannableTable.scan(compiler.getDataContext()));
        return TableScanNode.createEnumerable(compiler, rel, rowEnumerable, null, filters, projects);
    }

    private static TableScanNode createQueryable(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects, QueryableTable queryableTable) {
        Enumerable rowEnumerable;
        DataContext root = compiler.getDataContext();
        RelOptTable relOptTable = rel.getTable();
        Type elementType = queryableTable.getElementType();
        SchemaPlus schema = root.getRootSchema();
        for (String name : Util.skipLast(relOptTable.getQualifiedName())) {
            schema = schema.getSubSchema(name);
        }
        if (elementType instanceof Class) {
            Queryable queryable = Schemas.queryable(root, (Class)elementType, relOptTable.getQualifiedName());
            ImmutableList.Builder fieldBuilder = ImmutableList.builder();
            Class type = (Class)elementType;
            for (Field field : type.getFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                fieldBuilder.add((Object)field);
            }
            ImmutableList fields = fieldBuilder.build();
            rowEnumerable = queryable.select((Function1)new Function1<Object, Row>((List)fields){
                final /* synthetic */ List val$fields;
                {
                    this.val$fields = list;
                }

                public Row apply(Object o) {
                    Object[] values = new Object[this.val$fields.size()];
                    for (int i = 0; i < this.val$fields.size(); ++i) {
                        Field field = (Field)this.val$fields.get(i);
                        try {
                            values[i] = field.get(o);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return new Row(values);
                }
            });
        } else {
            rowEnumerable = Schemas.queryable(root, Row.class, relOptTable.getQualifiedName());
        }
        return TableScanNode.createEnumerable(compiler, rel, rowEnumerable, null, filters, projects);
    }

    private static TableScanNode createFilterable(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects, FilterableTable filterableTable) {
        DataContext root = compiler.getDataContext();
        ArrayList mutableFilters = Lists.newArrayList(filters);
        Enumerable<Object[]> enumerable = filterableTable.scan(root, mutableFilters);
        for (RexNode filter : mutableFilters) {
            if (filters.contains((Object)filter)) continue;
            throw Static.RESOURCE.filterableTableInventedFilter(filter.toString()).ex();
        }
        Enumerable<Row> rowEnumerable = Enumerables.toRow(enumerable);
        return TableScanNode.createEnumerable(compiler, rel, rowEnumerable, null, mutableFilters, projects);
    }

    private static TableScanNode createProjectableFilterable(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects, ProjectableFilterableTable pfTable) {
        Enumerable<Object[]> enumerable1;
        ArrayList mutableFilters;
        int changeCount;
        DataContext root = compiler.getDataContext();
        ImmutableIntList originalProjects = projects;
        do {
            mutableFilters = Lists.newArrayList(filters);
            int[] projectInts = projects == null || projects.equals(TableScan.identity(rel.getTable())) ? null : projects.toIntArray();
            enumerable1 = pfTable.scan(root, mutableFilters, projectInts);
            for (RexNode filter : mutableFilters) {
                if (filters.contains((Object)filter)) continue;
                throw Static.RESOURCE.filterableTableInventedFilter(filter.toString()).ex();
            }
            ImmutableBitSet usedFields = RelOptUtil.InputFinder.bits(mutableFilters, null);
            if (projects == null) break;
            changeCount = 0;
            for (int usedField : usedFields) {
                if (projects.contains(usedField)) continue;
                projects = ImmutableIntList.copyOf(Iterables.concat((Iterable)projects, (Iterable)ImmutableList.of((Object)usedField)));
                ++changeCount;
            }
        } while (changeCount > 0);
        Enumerable<Row> rowEnumerable = Enumerables.toRow(enumerable1);
        ImmutableIntList rejectedProjects = Objects.equals(projects, originalProjects) ? null : ImmutableIntList.identity(originalProjects.size());
        return TableScanNode.createEnumerable(compiler, rel, rowEnumerable, projects, mutableFilters, rejectedProjects);
    }

    private static TableScanNode createEnumerable(Compiler compiler, TableScan rel, Enumerable<Row> enumerable, ImmutableIntList acceptedProjects, List<RexNode> rejectedFilters, final ImmutableIntList rejectedProjects) {
        if (!rejectedFilters.isEmpty()) {
            RelDataType inputRowType;
            RexNode filter2;
            RexNode filter = RexUtil.composeConjunction(rel.getCluster().getRexBuilder(), rejectedFilters, false);
            assert (filter != null);
            if (acceptedProjects == null) {
                filter2 = filter;
                inputRowType = rel.getRowType();
            } else {
                Mapping mapping = Mappings.target(acceptedProjects, rel.getTable().getRowType().getFieldCount());
                filter2 = RexUtil.apply((Mappings.TargetMapping)mapping, filter);
                RelDataTypeFactory.FieldInfoBuilder builder = rel.getCluster().getTypeFactory().builder();
                List<RelDataTypeField> fieldList = rel.getTable().getRowType().getFieldList();
                for (int acceptedProject : acceptedProjects) {
                    ((RelDataTypeFactory.Builder)builder).add(fieldList.get(acceptedProject));
                }
                inputRowType = builder.build();
            }
            final Scalar condition = compiler.compile((List<RexNode>)ImmutableList.of((Object)filter2), inputRowType);
            final Context context = compiler.createContext();
            enumerable = enumerable.where((Predicate1)new Predicate1<Row>(){

                public boolean apply(Row row) {
                    context.values = row.getValues();
                    Boolean b = (Boolean)condition.execute(context);
                    return b != null && b != false;
                }
            });
        }
        if (rejectedProjects != null) {
            enumerable = enumerable.select((Function1)new Function1<Row, Row>(){
                final Object[] values;
                {
                    this.values = new Object[rejectedProjects.size()];
                }

                public Row apply(Row row) {
                    Object[] inValues = row.getValues();
                    for (int i = 0; i < rejectedProjects.size(); ++i) {
                        this.values[i] = inValues[rejectedProjects.get(i)];
                    }
                    return Row.asCopy(this.values);
                }
            });
        }
        return new TableScanNode(compiler, rel, enumerable);
    }
}

