/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.clickhouse.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLArrayDataType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.clickhouse.ast.ClickhouseAlterTableUpdateStatement;
import com.alibaba.druid.sql.dialect.clickhouse.ast.ClickhouseCreateTableStatement;
import com.alibaba.druid.sql.dialect.clickhouse.visitor.ClickhouseVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class ClickhouseOutputVisitor
extends SQLASTOutputVisitor
implements ClickhouseVisitor {
    public ClickhouseOutputVisitor(StringBuilder appender) {
        super(appender, DbType.clickhouse);
    }

    public ClickhouseOutputVisitor(StringBuilder appender, DbType dbType) {
        super(appender, dbType);
    }

    public ClickhouseOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        if (x.getExpr() != null) {
            x.getExpr().accept(this);
        } else if (x.getSubQuery() != null) {
            this.print('(');
            this.println();
            SQLSelect query = x.getSubQuery();
            if (query != null) {
                query.accept(this);
            } else {
                x.getReturningStatement().accept(this);
            }
            this.println();
            this.print(')');
        }
        this.print(' ');
        this.print0(this.ucase ? "AS " : "as ");
        this.print0(x.getAlias());
        return false;
    }

    @Override
    public boolean visit(SQLStructDataType x) {
        this.print0(this.ucase ? "NESTED (" : "nested (");
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getFields(), ",");
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLStructDataType.Field x) {
        SQLDataType dataType;
        SQLName name = x.getName();
        if (name != null) {
            name.accept(this);
        }
        if ((dataType = x.getDataType()) != null) {
            this.print(' ');
            dataType.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ClickhouseCreateTableStatement x) {
        List<SQLAssignItem> settings;
        SQLExpr sampleBy;
        SQLOrderBy orderBy;
        super.visit(x);
        SQLExpr partitionBy = x.getPartitionBy();
        if (partitionBy != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            partitionBy.accept(this);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.println();
            orderBy.accept(this);
        }
        if ((sampleBy = x.getSampleBy()) != null) {
            this.println();
            this.print0(this.ucase ? "SAMPLE BY " : "sample by ");
            sampleBy.accept(this);
        }
        if (!(settings = x.getSettings()).isEmpty()) {
            this.println();
            this.print0(this.ucase ? "SETTINGS " : "settings ");
            this.printAndAccept(settings, ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD COLUMN " : "add column ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLArrayDataType x) {
        List<SQLExpr> arguments = x.getArguments();
        if (Boolean.TRUE.equals(x.getAttribute("ads.arrayDataType"))) {
            x.getComponentType().accept(this);
            this.print('[');
            this.printAndAccept(arguments, ", ");
            this.print(']');
        } else {
            SQLDataType componentType = x.getComponentType();
            if (componentType != null) {
                this.print0(this.ucase ? "Array<" : "array<");
                componentType.accept(this);
                this.print('>');
            } else {
                this.print0(this.ucase ? "Array" : "array");
            }
            if (arguments.size() > 0) {
                this.print('(');
                this.printAndAccept(arguments, ", ");
                this.print(')');
            }
        }
        return false;
    }

    @Override
    public boolean visit(ClickhouseAlterTableUpdateStatement x) {
        this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
        this.printExpr(x.getTableName());
        if (x.getClusterName() != null) {
            this.print0(this.ucase ? " ON CLUSTER " : " on cluster ");
            if (this.parameterized) {
                this.print('?');
            } else {
                this.printExpr(x.getClusterName());
            }
        }
        this.print0(this.ucase ? " UPDATE " : " update ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            SQLUpdateSetItem item = x.getItems().get(i);
            this.visit(item);
        }
        if (x.getPartitionId() != null) {
            this.print0(this.ucase ? " IN PARTITION " : " in partition ");
            if (this.parameterized) {
                this.print('?');
            } else {
                this.printExpr(x.getPartitionId());
            }
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }
}

