/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.linkis.utils.LinkisSpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class PerformanceInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(PerformanceInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        request.setAttribute("Linkis_startTime", (Object)System.currentTimeMillis());
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        Object startObject = request.getAttribute("Linkis_startTime");
        if (null != startObject) {
            long startTime = (Long)startObject;
            long endTime = System.currentTimeMillis();
            long executeTime = endTime - startTime;
            logger.info("Request client address\uff1a{} request URL: {}  Method: {} taken: {} ms", new Object[]{LinkisSpringUtils.getClientIP(request), request.getRequestURI(), request.getMethod(), executeTime});
        }
    }
}

