/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.concurrent.monitor;

import org.apache.linkis.engineconn.computation.concurrent.monitor.HardwareMonitorService;
import org.apache.linkis.engineconn.computation.concurrent.monitor.MonitorService;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor;
import org.apache.linkis.engineconn.core.EngineConnObject;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMonitorService
implements MonitorService {
    private static Logger LOG = LoggerFactory.getLogger(HardwareMonitorService.class);
    private static ConcurrentComputationExecutor concurrentExecutor = null;

    @Override
    public boolean isAvailable() {
        if (!EngineConnObject.isReady()) {
            return true;
        }
        try {
            Executor executor;
            if (null == concurrentExecutor && (executor = ExecutorManager$.MODULE$.getInstance().getReportExecutor()) instanceof ConcurrentComputationExecutor) {
                concurrentExecutor = (ConcurrentComputationExecutor)executor;
            }
            if (null == concurrentExecutor) {
                LOG.warn("shell executor can not is null");
                return true;
            }
            if (concurrentExecutor.getRunningTask() > concurrentExecutor.getConcurrentLimit()) {
                LOG.info("running task({}) > concurrent limit ({}) , now to mark ec to busy ", (Object)concurrentExecutor.getRunningTask(), (Object)concurrentExecutor.getConcurrentLimit());
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn("Task Monitor failed", (Throwable)e);
        }
        return true;
    }
}

