/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.hive.serde;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.linkis.common.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerDelimitedJSONSerDe
extends LazySimpleSerDe {
    public static final Logger LOG = LoggerFactory.getLogger((String)CustomerDelimitedJSONSerDe.class.getName());
    public static byte[] trueBytes = new byte[]{116, 114, 117, 101};
    public static byte[] falseBytes = new byte[]{102, 97, 108, 115, 101};

    public Object doDeserialize(Writable field) throws SerDeException {
        LOG.error("DelimitedJSONSerDe cannot deserialize.");
        throw new SerDeException("DelimitedJSONSerDe cannot deserialize.");
    }

    public static void serialize(ByteStream.Output out, Object obj, ObjectInspector objInspector, byte[] separators, int level, Text nullSequence, boolean escaped, byte escapeChar, boolean[] needsEscape) throws IOException, SerDeException {
        if (obj != null) {
            switch (objInspector.getCategory()) {
                case PRIMITIVE: {
                    CustomerDelimitedJSONSerDe.writePrimitiveUTF8((OutputStream)out, obj, (PrimitiveObjectInspector)objInspector, escaped, escapeChar, needsEscape);
                    return;
                }
                case LIST: {
                    char separator = (char)CustomerDelimitedJSONSerDe.getSeparator(separators, level);
                    ListObjectInspector loi = (ListObjectInspector)objInspector;
                    List list = loi.getList(obj);
                    ObjectInspector eoi = loi.getListElementObjectInspector();
                    if (list == null) {
                        out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                    } else {
                        for (int i = 0; i < list.size(); ++i) {
                            if (i > 0) {
                                out.write((int)separator);
                            }
                            CustomerDelimitedJSONSerDe.serialize(out, list.get(i), eoi, separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                        }
                    }
                    return;
                }
                case MAP: {
                    char separator = (char)CustomerDelimitedJSONSerDe.getSeparator(separators, level);
                    char keyValueSeparator = (char)CustomerDelimitedJSONSerDe.getSeparator(separators, level + 1);
                    MapObjectInspector moi = (MapObjectInspector)objInspector;
                    ObjectInspector koi = moi.getMapKeyObjectInspector();
                    ObjectInspector voi = moi.getMapValueObjectInspector();
                    Map map = moi.getMap(obj);
                    if (map == null) {
                        out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                    } else {
                        boolean first = true;
                        for (Map.Entry entry : map.entrySet()) {
                            if (first) {
                                first = false;
                            } else {
                                out.write((int)separator);
                            }
                            CustomerDelimitedJSONSerDe.serialize(out, entry.getKey(), koi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                            out.write((int)keyValueSeparator);
                            CustomerDelimitedJSONSerDe.serialize(out, entry.getValue(), voi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                        }
                    }
                    return;
                }
                case STRUCT: {
                    char separator = (char)CustomerDelimitedJSONSerDe.getSeparator(separators, level);
                    StructObjectInspector soi = (StructObjectInspector)objInspector;
                    List fields = soi.getAllStructFieldRefs();
                    List list = soi.getStructFieldsDataAsList(obj);
                    if (list == null) {
                        out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                    } else {
                        for (int i = 0; i < list.size(); ++i) {
                            if (i > 0) {
                                out.write((int)separator);
                            }
                            CustomerDelimitedJSONSerDe.serialize(out, list.get(i), ((StructField)fields.get(i)).getFieldObjectInspector(), separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                        }
                    }
                    return;
                }
                case UNION: {
                    char separator = (char)CustomerDelimitedJSONSerDe.getSeparator(separators, level);
                    UnionObjectInspector uoi = (UnionObjectInspector)objInspector;
                    List ois = uoi.getObjectInspectors();
                    if (ois == null) {
                        out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                    } else {
                        LazyUtils.writePrimitiveUTF8((OutputStream)out, (Object)new Byte(uoi.getTag(obj)), (PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector, (boolean)escaped, (byte)escapeChar, (boolean[])needsEscape);
                        out.write((int)separator);
                        CustomerDelimitedJSONSerDe.serialize(out, uoi.getField(obj), (ObjectInspector)ois.get(uoi.getTag(obj)), separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                    }
                    return;
                }
            }
            throw new RuntimeException("Unknown category type: " + objInspector.getCategory());
        }
        out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
    }

    private static void writePrimitiveUTF8(OutputStream out, Object o, PrimitiveObjectInspector oi, boolean escaped, byte escapeChar, boolean[] needsEscape) throws IOException {
        PrimitiveObjectInspector.PrimitiveCategory category = oi.getPrimitiveCategory();
        byte[] binaryData = null;
        DateWritableV2 wc = null;
        switch (category) {
            case BOOLEAN: {
                boolean b = ((BooleanObjectInspector)oi).get(o);
                if (b) {
                    binaryData = Base64.encodeBase64((byte[])trueBytes);
                    break;
                }
                binaryData = Base64.encodeBase64((byte[])falseBytes);
                break;
            }
            case BYTE: {
                binaryData = Base64.encodeBase64((byte[])String.valueOf(((ByteObjectInspector)oi).get(o)).getBytes());
                break;
            }
            case SHORT: {
                binaryData = Base64.encodeBase64((byte[])String.valueOf(((ShortObjectInspector)oi).get(o)).getBytes());
                break;
            }
            case INT: {
                binaryData = Base64.encodeBase64((byte[])String.valueOf(((IntObjectInspector)oi).get(o)).getBytes());
                break;
            }
            case LONG: {
                binaryData = Base64.encodeBase64((byte[])String.valueOf(((LongObjectInspector)oi).get(o)).getBytes());
                break;
            }
            case FLOAT: {
                binaryData = Base64.encodeBase64((byte[])String.valueOf(((FloatObjectInspector)oi).get(o)).getBytes());
                break;
            }
            case DOUBLE: {
                binaryData = Base64.encodeBase64((byte[])String.valueOf(((DoubleObjectInspector)oi).get(o)).getBytes());
                break;
            }
            case STRING: {
                binaryData = Base64.encodeBase64((byte[])((StringObjectInspector)oi).getPrimitiveWritableObject(o).getBytes());
                break;
            }
            case CHAR: {
                HiveCharWritable hc = ((HiveCharObjectInspector)oi).getPrimitiveWritableObject(o);
                binaryData = Base64.encodeBase64((byte[])String.valueOf(hc).getBytes());
                break;
            }
            case VARCHAR: {
                HiveVarcharWritable hc = ((HiveVarcharObjectInspector)oi).getPrimitiveWritableObject(o);
                binaryData = Base64.encodeBase64((byte[])String.valueOf(hc).getBytes());
                break;
            }
            case BINARY: {
                BytesWritable bw = ((BinaryObjectInspector)oi).getPrimitiveWritableObject(o);
                byte[] toEncode = new byte[bw.getLength()];
                System.arraycopy(bw.getBytes(), 0, toEncode, 0, bw.getLength());
                byte[] toWrite = Base64.encodeBase64((byte[])toEncode);
                out.write(toWrite, 0, toWrite.length);
                break;
            }
            case DATE: {
                wc = ((DateObjectInspector)oi).getPrimitiveWritableObject(o);
                binaryData = Base64.encodeBase64((byte[])String.valueOf(wc).getBytes());
                break;
            }
            case TIMESTAMP: {
                wc = ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o);
                binaryData = Base64.encodeBase64((byte[])String.valueOf(wc).getBytes());
                break;
            }
            case DECIMAL: {
                HiveDecimalObjectInspector decimalOI = (HiveDecimalObjectInspector)oi;
                binaryData = Base64.encodeBase64((byte[])String.valueOf(decimalOI).getBytes());
                break;
            }
            default: {
                if (!"INTERVAL_YEAR_MONTH".equals(category.name()) && !"INTERVAL_DAY_TIME".equals(category.name())) {
                    throw new RuntimeException("Unknown primitive type: " + category);
                }
                boolean containsIntervalYearMonth = false;
                boolean containsIntervalDayTime = false;
                for (PrimitiveObjectInspector.PrimitiveCategory primitiveCategory : PrimitiveObjectInspector.PrimitiveCategory.values()) {
                    containsIntervalYearMonth = "INTERVAL_YEAR_MONTH".equals(primitiveCategory.name()) && "INTERVAL_YEAR_MONTH".equals(category.name());
                    containsIntervalDayTime = "INTERVAL_DAY_TIME".equals(primitiveCategory.name()) && "INTERVAL_DAY_TIME".equals(category.name());
                    try {
                        if (containsIntervalYearMonth) {
                            wc = (WritableComparable)ClassUtils.getClassInstance((String)"org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveIntervalYearMonthObjectInspector").getClass().getMethod("getPrimitiveWritableObject", Object.class).invoke((Object)oi, o);
                            binaryData = Base64.encodeBase64((byte[])String.valueOf(wc).getBytes());
                            break;
                        }
                        if (!containsIntervalDayTime) continue;
                        wc = (WritableComparable)ClassUtils.getClassInstance((String)"org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveIntervalDayTimeObjectInspector").getClass().getMethod("getPrimitiveWritableObject", Object.class).invoke((Object)oi, o);
                        binaryData = Base64.encodeBase64((byte[])String.valueOf(wc).getBytes());
                        break;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        LOG.error("Fail to invoke method:[getPrimitiveWritableObject]!", (Throwable)e);
                    }
                }
                if (containsIntervalYearMonth || containsIntervalDayTime) break;
                throw new RuntimeException("Unknown primitive type: " + category);
            }
        }
        if (binaryData == null) {
            throw new RuntimeException("get primitive type is null: " + category);
        }
        out.write(binaryData, 0, binaryData.length);
    }

    static byte getSeparator(byte[] separators, int level) throws SerDeException {
        try {
            return separators[level];
        }
        catch (ArrayIndexOutOfBoundsException var5) {
            String msg = "Number of levels of nesting supported for LazySimpleSerde is " + (separators.length - 1) + " Unable to work with level " + level;
            String txt = ". Use %s serde property for tables using LazySimpleSerde.";
            if (separators.length < 9) {
                msg = msg + String.format(txt, "hive.serialization.extend.nesting.levels");
            } else if (separators.length < 25) {
                msg = msg + String.format(txt, "hive.serialization.extend.additional.nesting.levels");
            }
            throw new SerDeException(msg, (Throwable)var5);
        }
    }
}

