/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.hive.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.executor.entity.ResourceFetchExecutor;
import org.apache.linkis.engineplugin.hive.conf.Counters$;
import org.apache.linkis.engineplugin.hive.conf.HiveEngineConfiguration$;
import org.apache.linkis.engineplugin.hive.cs.CSHiveHelper$;
import org.apache.linkis.engineplugin.hive.errorcode.HiveErrorCodeSummary;
import org.apache.linkis.engineplugin.hive.exception.HiveQueryFailedException;
import org.apache.linkis.engineplugin.hive.executor.HiveDriverProxy;
import org.apache.linkis.engineplugin.hive.executor.HiveDriverProxy$;
import org.apache.linkis.engineplugin.hive.executor.HiveEngineConcurrentConnExecutor$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.SQLCodeParser;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.protocol.resource.ResourceWithStatus;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r5a\u0001\u0002\u00192\u0001yB\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t1\u0002\u0011\t\u0011)A\u00053\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003m\u0011!\u0011\bA!A!\u0002\u0013\u0019\b\"B>\u0001\t\u0003a\b\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011!\tI\u0002\u0001Q\u0001\n\u00055\u0001\"CA\u000e\u0001\t\u0007I\u0011BA\u000f\u0011!\t)\u0004\u0001Q\u0001\n\u0005}\u0001\"CA\u001c\u0001\t\u0007I\u0011BA\u001d\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005m\u0002\"CA:\u0001\t\u0007I\u0011BA;\u0011!\t\u0019\t\u0001Q\u0001\n\u0005]\u0004\"CAC\u0001\t\u0007I\u0011BAD\u0011!\t\u0019\n\u0001Q\u0001\n\u0005%\u0005\"CAK\u0001\t\u0007I\u0011BAD\u0011!\t9\n\u0001Q\u0001\n\u0005%\u0005bCAM\u0001\u0001\u0007\t\u0019!C\u0005\u00037C1\"!+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\"Y\u0011q\u0017\u0001A\u0002\u0003\u0005\u000b\u0015BAO\u0011\u001d\tI\f\u0001C!\u0003wCq!!0\u0001\t\u0003\ny\fC\u0004\u0002`\u0002!\t!a/\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u00111\u001f\u0001\u0005\n\u0005U\bb\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011y\u0004\u0001C\u0005\u0003wCqA!\u0011\u0001\t\u0003\u0012\u0019\u0005C\u0004\u0003N\u0001!\t%a/\t\u000f\t=\u0003\u0001\"\u0011\u0003R!9!Q\u000e\u0001\u0005B\t=\u0004b\u0002B>\u0001\u0011\u0005#Q\u0010\u0005\b\u0005+\u0003A\u0011\tBL\u0011\u001d\u0011Y\n\u0001C!\u0003wCqA!(\u0001\t\u0013\u0011y\nC\u0004\u0003$\u0002!\tE!*\t\u000f\t\u001d\u0006\u0001\"\u0011\u0003*\"9!q\u0017\u0001\u0005B\te\u0006b\u0002Bf\u0001\u0011\u0005#Q\u001a\u0005\b\u0005?\u0004A\u0011\tBq\u0011\u001d\u0011\u0019\u000f\u0001C!\u0005K<\u0011Ba:2\u0003\u0003E\tA!;\u0007\u0011A\n\u0014\u0011!E\u0001\u0005WDaa_\u0017\u0005\u0002\tM\b\"\u0003B{[E\u0005I\u0011\u0001B|\u0005\u0001B\u0015N^3F]\u001eLg.Z\"p]\u000e,(O]3oi\u000e{gN\\#yK\u000e,Ho\u001c:\u000b\u0005I\u001a\u0014\u0001C3yK\u000e,Ho\u001c:\u000b\u0005Q*\u0014\u0001\u00025jm\u0016T!AN\u001c\u0002\u0019\u0015tw-\u001b8fa2,x-\u001b8\u000b\u0005aJ\u0014A\u00027j].L7O\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\u0004\u0001}R\u0005C\u0001!I\u001b\u0005\t%B\u0001\"D\u0003\u001d)\u00070Z2vi\u0016T!A\r#\u000b\u0005\u00153\u0015aC2p[B,H/\u0019;j_:T!aR\u001c\u0002\u0015\u0015tw-\u001b8fG>tg.\u0003\u0002J\u0003\ni2i\u001c8dkJ\u0014XM\u001c;D_6\u0004X\u000f^1uS>tW\t_3dkR|'\u000f\u0005\u0002L\u001f6\tAJ\u0003\u0002N\u001d\u00061QM\u001c;jifT!A\r$\n\u0005Ac%!\u0006*fg>,(oY3GKR\u001c\u0007.\u0012=fGV$xN]\u0001\u0003S\u0012\u0004\"a\u0015,\u000e\u0003QS\u0011!V\u0001\u0006g\u000e\fG.Y\u0005\u0003/R\u00131!\u00138u\u00031\u0019Xm]:j_:\u001cF/\u0019;f!\tQ&-D\u0001\\\u0015\taV,A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005y{\u0016AA9m\u0015\t!\u0004M\u0003\u0002bs\u00051\u0001.\u00193p_BL!aY.\u0003\u0019M+7o]5p]N#\u0018\r^3\u0002\u0007U<\u0017\u000e\u0005\u0002gS6\tqM\u0003\u0002iA\u0006A1/Z2ve&$\u00180\u0003\u0002kO\n!Rk]3s\u000fJ|W\u000f]%oM>\u0014X.\u0019;j_:\f\u0001\u0002[5wK\u000e{gN\u001a\t\u0003[Bl\u0011A\u001c\u0006\u0003_~\u000bAaY8oM&\u0011\u0011O\u001c\u0002\t\u0011&4XmQ8oM\u0006!!-Y8t!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0002j_*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005U\u0011\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6\fa\u0001P5oSRtDCC?\u0000\u0003\u0003\t\u0019!!\u0002\u0002\bA\u0011a\u0010A\u0007\u0002c!)\u0011K\u0002a\u0001%\")\u0001L\u0002a\u00013\")AM\u0002a\u0001K\")1N\u0002a\u0001Y\"9!O\u0002I\u0001\u0002\u0004\u0019\u0018a\u0001'P\u000fV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C\u001e\u0002\u000bMdg\r\u000e6\n\t\u0005]\u0011\u0011\u0003\u0002\u0007\u0019><w-\u001a:\u0002\t1{u\tI\u0001\u000b]\u0006lW\r\u0015:fM&DXCAA\u0010!\u0011\t\t#a\f\u000f\t\u0005\r\u00121\u0006\t\u0004\u0003K!VBAA\u0014\u0015\r\tI#P\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055B+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\t\u0019D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003[!\u0016a\u00038b[\u0016\u0004&/\u001a4jq\u0002\na\"\u001a=fGV$xN\u001d'bE\u0016d7/\u0006\u0002\u0002<A1\u0011QHA\"\u0003\u000fj!!a\u0010\u000b\u0007\u0005\u0005s/\u0001\u0003vi&d\u0017\u0002BA#\u0003\u007f\u0011A\u0001T5tiB\"\u0011\u0011JA0!\u0019\tY%a\u0016\u0002\\5\u0011\u0011Q\n\u0006\u0004\u001b\u0006=#\u0002BA)\u0003'\nQ\u0001\\1cK2T1!!\u00168\u0003\u001di\u0017M\\1hKJLA!!\u0017\u0002N\t)A*\u00192fYB!\u0011QLA0\u0019\u0001!1\"!\u0019\r\u0003\u0003\u0005\tQ!\u0001\u0002f\t\u0019q\fJ\u0019\u0002\u001f\u0015DXmY;u_Jd\u0015MY3mg\u0002\nB!a\u001a\u0002nA\u00191+!\u001b\n\u0007\u0005-DKA\u0004O_RD\u0017N\\4\u0011\u0007M\u000by'C\u0002\u0002rQ\u00131!\u00118z\u0003-!'/\u001b<fe\u000e\u000b7\r[3\u0016\u0005\u0005]\u0004\u0003CA\u001f\u0003s\ny\"! \n\t\u0005m\u0014q\b\u0002\u0004\u001b\u0006\u0004\bc\u0001@\u0002\u0000%\u0019\u0011\u0011Q\u0019\u0003\u001f!Kg/\u001a#sSZ,'\u000f\u0015:pqf\fA\u0002\u001a:jm\u0016\u00148)Y2iK\u0002\nQ#\u00199qY&\u001c\u0017\r^5p]N#(/\u001b8h\u001d\u0006lW-\u0006\u0002\u0002\nB!\u00111RAI\u001b\t\tiIC\u0002\u0002\u0010^\fA\u0001\\1oO&!\u0011\u0011GAG\u0003Y\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8TiJLgn\u001a(b[\u0016\u0004\u0013\u0001C:qY&$H/\u001a:\u0002\u0013M\u0004H.\u001b;uKJ\u0004\u0013a\u00062bG.<'o\\;oI>\u0003XM]1uS>t\u0007k\\8m+\t\ti\n\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\u0011\t\u0019+a\u0010\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002(\u0006\u0005&A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\f1DY1dW\u001e\u0014x.\u001e8e\u001fB,'/\u0019;j_:\u0004vn\u001c7`I\u0015\fH\u0003BAW\u0003g\u00032aUAX\u0013\r\t\t\f\u0016\u0002\u0005+:LG\u000fC\u0005\u00026R\t\t\u00111\u0001\u0002\u001e\u0006\u0019\u0001\u0010J\u0019\u00021\t\f7m[4s_VtGm\u00149fe\u0006$\u0018n\u001c8Q_>d\u0007%\u0001\u0003j]&$HCAAW\u0003-)\u00070Z2vi\u0016d\u0015N\\3\u0015\r\u0005\u0005\u0017\u0011[An!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\f\u0001\"\u001a=fGV$XM\u001d\u0006\u0004\u0003\u0017<\u0014!C:dQ\u0016$W\u000f\\3s\u0013\u0011\ty-!2\u0003\u001f\u0015CXmY;uKJ+7\u000f]8og\u0016Dq!a5\u0018\u0001\u0004\t).A\u000bf]\u001eLg.Z#yK\u000e,Ho\u001c:D_:$X\r\u001f;\u0011\u0007\u0001\u000b9.C\u0002\u0002Z\u0006\u0013a#\u00128hS:,W\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003;<\u0002\u0019AA\u0010\u0003\u0011\u0019w\u000eZ3\u0002\u001d1|w-T3n_JL8)Y2iK\u0006QQ\r_3dkR,\u0007*\u0015'\u0015\u0015\u0005\u0005\u0017Q]Au\u0003W\fy\u000fC\u0004\u0002hf\u0001\r!a\b\u0002\rQ\f7o[%e\u0011\u001d\t\u0019.\u0007a\u0001\u0003+Dq!!<\u001a\u0001\u0004\ty\"\u0001\u0005sK\u0006d7i\u001c3f\u0011\u001d\t\t0\u0007a\u0001\u0003{\na\u0001\u001a:jm\u0016\u0014\u0018!D:f]\u0012\u0014Vm];miN+G\u000fF\u0004S\u0003o\fI0a?\t\u000f\u0005M'\u00041\u0001\u0002V\"9\u0011\u0011\u001f\u000eA\u0002\u0005u\u0004bBA\u007f5\u0001\u0007\u0011q`\u0001\t[\u0016$\u0018\rR1uCB!!\u0011\u0001B\b\u001b\t\u0011\u0019A\u0003\u0003\u0003\u0006\t\u001d\u0011!\u0002;bE2,'\u0002\u0002B\u0005\u0005\u0017\t\u0011B]3tk2$8/\u001a;\u000b\u0007\t5q'A\u0004ti>\u0014\u0018mZ3\n\t\tE!1\u0001\u0002\u000e)\u0006\u0014G.Z'fi\u0006$\u0015\r^1\u0002#\u001d,GOU3tk2$X*\u001a;b\t\u0006$\u0018\r\u0006\u0004\u0002\u0000\n]!Q\u0006\u0005\b\u00053Y\u0002\u0019\u0001B\u000e\u000311\u0017.\u001a7e'\u000eDW-\\1t!\u0019\ti$a\u0011\u0003\u001eA!!q\u0004B\u0015\u001b\t\u0011\tC\u0003\u0003\u0003$\t\u0015\u0012aA1qS*\u0019!qE0\u0002\u00135,G/Y:u_J,\u0017\u0002\u0002B\u0016\u0005C\u00111BR5fY\u0012\u001c6\r[3nC\"9!qF\u000eA\u0002\tE\u0012\u0001D;tKR\u000b'\r\\3OC6,\u0007cA*\u00034%\u0019!Q\u0007+\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011n\u001d(p%\u0016\u001cX\u000f\u001c;Tc2$BA!\r\u0003<!9!Q\b\u000fA\u0002\u0005}\u0011aA:rY\u0006QqN\\\"p[BdW\r^3\u0002#\u0015DXmY;uK\u000e{W\u000e\u001d7fi\u0016d\u0017\u0010\u0006\u0005\u0002B\n\u0015#q\tB%\u0011\u001d\t\u0019N\ba\u0001\u0003+Dq!!8\u001f\u0001\u0004\ty\u0002C\u0004\u0003Ly\u0001\r!a\b\u0002\u001b\r|W\u000e\u001d7fi\u0016$G*\u001b8f\u0003\u0015\u0019Gn\\:f\u000351U\r^2i%\u0016\u001cx.\u001e:dKV\u0011!1\u000b\t\t\u0003{\u0011)&a\b\u0003Z%!!qKA \u0005\u001dA\u0015m\u001d5NCB\u0004BAa\u0017\u0003j5\u0011!Q\f\u0006\u0005\u0005?\u0012\t'\u0001\u0005sKN|WO]2f\u0015\u0011\u0011\u0019G!\u001a\u0002\u0011A\u0014x\u000e^8d_2TAAa\u001a\u0002T\u000511m\\7n_:LAAa\u001b\u0003^\t\u0011\"+Z:pkJ\u001cWmV5uQN#\u0018\r^;t\u0003!\u0001(o\\4sKN\u001cH\u0003\u0002B9\u0005o\u00022a\u0015B:\u0013\r\u0011)\b\u0016\u0002\u0006\r2|\u0017\r\u001e\u0005\b\u0005s\n\u0003\u0019AA\u0010\u0003\u0019!\u0018m]6J\t\u0006yq-\u001a;Qe><'/Z:t\u0013:4w\u000e\u0006\u0003\u0003\u0000\tM\u0005#B*\u0003\u0002\n\u0015\u0015b\u0001BB)\n)\u0011I\u001d:bsB!!q\u0011BH\u001b\t\u0011II\u0003\u0003\u0003\f\n5\u0015AB3oO&tWMC\u0002\u0003d]JAA!%\u0003\n\ny!j\u001c2Qe><'/Z:t\u0013:4w\u000eC\u0004\u0003z\t\u0002\r!a\b\u0002\u0011-LG\u000e\u001c+bg.$B!!,\u0003\u001a\"9!\u0011P\u0012A\u0002\u0005}\u0011aB6jY2\fE\u000e\\\u0001\bG2,\u0017M\\;q)\u0011\tiK!)\t\u000f\teT\u00051\u0001\u0002 \u0005\u00192/\u001e9q_J$8)\u00197m\u0005\u0006\u001c7\u000eT8hgR\u0011!\u0011G\u0001\u0012O\u0016$X\t_3dkR|'\u000fT1cK2\u001cHC\u0001BV!\u0019\ti$a\u0011\u0003.B\"!q\u0016BZ!\u0019\tY%a\u0016\u00032B!\u0011Q\fBZ\t-\u0011)lJA\u0001\u0002\u0003\u0015\t!!\u001a\u0003\u0007}#3'A\ttKR,\u00050Z2vi>\u0014H*\u00192fYN$B!!,\u0003<\"9!Q\u0018\u0015A\u0002\t}\u0016A\u00027bE\u0016d7\u000f\u0005\u0004\u0002>\u0005\r#\u0011\u0019\u0019\u0005\u0005\u0007\u00149\r\u0005\u0004\u0002L\u0005]#Q\u0019\t\u0005\u0003;\u00129\r\u0002\u0007\u0003J\nm\u0016\u0011!A\u0001\u0006\u0003\t)GA\u0002`IQ\nqC]3rk\u0016\u001cH/\u0012=qK\u000e$X\r\u001a*fg>,(oY3\u0015\t\t='1\u001c\t\u0005\u0005#\u00149.\u0004\u0002\u0003T*!!q\fBk\u0015\ri%QM\u0005\u0005\u00053\u0014\u0019N\u0001\u0007O_\u0012,'+Z:pkJ\u001cW\rC\u0004\u0003^&\u0002\rAa4\u0002!\u0015D\b/Z2uK\u0012\u0014Vm]8ve\u000e,\u0017AF4fi\u000e+(O]3oi:{G-\u001a*fg>,(oY3\u0015\u0005\t=\u0017!B4fi&#GCAA\u0010\u0003\u0001B\u0015N^3F]\u001eLg.Z\"p]\u000e,(O]3oi\u000e{gN\\#yK\u000e,Ho\u001c:\u0011\u0005yl3cA\u0017\u0003nB\u00191Ka<\n\u0007\tEHK\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005S\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TC\u0001B}U\r\u0019(1`\u0016\u0003\u0005{\u0004BAa@\u0004\n5\u00111\u0011\u0001\u0006\u0005\u0007\u0007\u0019)!A\u0005v]\u000eDWmY6fI*\u00191q\u0001+\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\f\r\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class HiveEngineConcurrentConnExecutor
extends ConcurrentComputationExecutor
implements ResourceFetchExecutor {
    private final int id;
    public final SessionState org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$sessionState;
    public final UserGroupInformation org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$ugi;
    public final HiveConf org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$hiveConf;
    public final ByteArrayOutputStream org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$baos;
    private final Logger org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG;
    private final String namePrefix;
    private final List<Label<?>> executorLabels;
    private final Map<String, HiveDriverProxy> org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache;
    private final String applicationStringName;
    private final String splitter;
    private ThreadPoolExecutor backgroundOperationPool;

    public static ByteArrayOutputStream $lessinit$greater$default$5() {
        return HiveEngineConcurrentConnExecutor$.MODULE$.$lessinit$greater$default$5();
    }

    public Logger org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG() {
        return this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG;
    }

    private String namePrefix() {
        return this.namePrefix;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    public Map<String, HiveDriverProxy> org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache() {
        return this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache;
    }

    private String applicationStringName() {
        return this.applicationStringName;
    }

    private String splitter() {
        return this.splitter;
    }

    private ThreadPoolExecutor backgroundOperationPool() {
        return this.backgroundOperationPool;
    }

    private void backgroundOperationPool_$eq(ThreadPoolExecutor x$1) {
        this.backgroundOperationPool = x$1;
    }

    public void init() {
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().info("Ready to change engine state!");
        Object object = BoxesRunTime.unboxToBoolean((Object)HadoopConf$.MODULE$.KEYTAB_PROXYUSER_ENABLED().getValue()) ? System.setProperty("javax.security.auth.useSubjectCredsOnly", "false") : BoxedUnit.UNIT;
        this.setCodeParser((CodeParser)new SQLCodeParser());
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(100);
        this.backgroundOperationPool_$eq(new ThreadPoolExecutor(100, 100, 10L, TimeUnit.SECONDS, queue, new ThreadFactoryBuilder().setNameFormat("Hive-Background-Pool-%d").build()));
        this.backgroundOperationPool().allowCoreThreadTimeOut(true);
        super.init();
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutorContext, String code) {
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().info(new StringBuilder(55).append("HiveEngineConcurrentConnExecutor Ready to executeLine: ").append(code).toString());
        String taskId = (String)engineExecutorContext.getJobId().get();
        CSHiveHelper$.MODULE$.setContextIDInfoToHiveConf(engineExecutorContext, this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$hiveConf);
        String realCode = code.trim();
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().info(new StringBuilder(37).append("hive client begins to run hql code:\n ").append(realCode.trim()).toString());
        String jobId = JobUtils$.MODULE$.getJobIdFromMap(engineExecutorContext.getProperties());
        if (StringUtils.isNotBlank((CharSequence)jobId)) {
            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().info(new StringBuilder(30).append("set mapreduce.job.tags=LINKIS_").append(jobId).toString());
            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$hiveConf.set("mapreduce.job.tags", new StringBuilder(7).append("LINKIS_").append(jobId).toString());
        }
        if (realCode.trim().length() > 500) {
            engineExecutorContext.appendStdout(new StringBuilder(8).append(this.getId()).append(" >> ").append(realCode.trim().substring(0, 500)).append(" ...").toString());
        } else {
            engineExecutorContext.appendStdout(new StringBuilder(4).append(this.getId()).append(" >> ").append(realCode.trim()).toString());
        }
        String[] tokens = realCode.trim().split("\\s+");
        Callable<ExecuteResponse> operation = new Callable<ExecuteResponse>(this, code, tokens, taskId, engineExecutorContext, realCode){
            private final /* synthetic */ HiveEngineConcurrentConnExecutor $outer;
            private final String code$1;
            public final String[] tokens$1;
            public final String taskId$1;
            public final EngineExecutionContext engineExecutorContext$1;
            public final String realCode$1;

            public ExecuteResponse call() {
                SessionState.setCurrentSessionState((SessionState)this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$sessionState);
                this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$sessionState.setLastCommand(this.code$1);
                CommandProcessor proc = CommandProcessorFactory.get((String[])this.tokens$1, (HiveConf)this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$hiveConf);
                this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().debug(new StringBuilder(7).append("ugi is ").append(this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$ugi.getUserName()).toString());
                return (ExecuteResponse)this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ExecuteResponse>(this, proc){
                    private final /* synthetic */ $anon$1 $outer;
                    private final CommandProcessor proc$1;

                    public ExecuteResponse run() {
                        CommandProcessor commandProcessor = this.proc$1;
                        if (HiveDriverProxy$.MODULE$.isDriver(commandProcessor)) {
                            this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$anon$$$outer().logger().info(new StringBuilder(10).append("driver is ").append(commandProcessor).toString());
                            HiveDriverProxy driver = new HiveDriverProxy(commandProcessor);
                            this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$anon$$$outer().org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache().put(this.$outer.taskId$1, driver);
                            return this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$anon$$$outer().org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$executeHQL((String)this.$outer.engineExecutorContext$1.getJobId().get(), this.$outer.engineExecutorContext$1, this.$outer.realCode$1, driver);
                        }
                        CommandProcessorResponse resp = this.proc$1.run(this.$outer.realCode$1.substring(this.$outer.tokens$1[0].length()).trim());
                        String result = new String(this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$anon$$$outer().org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$baos.toByteArray());
                        this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$anon$$$outer().logger().info("RESULT => {}", new Object[]{result});
                        this.$outer.engineExecutorContext$1.appendStdout(result);
                        this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$anon$$$outer().org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$baos.reset();
                        if (resp.getResponseCode() != 0) {
                            this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$anon$$$outer().org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$onComplete();
                            throw resp.getException();
                        }
                        this.$outer.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$anon$$$outer().org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$onComplete();
                        return new SuccessExecuteResponse();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.proc$1 = proc$1;
                    }
                });
            }

            public /* synthetic */ HiveEngineConcurrentConnExecutor org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.code$1 = code$1;
                this.tokens$1 = tokens$1;
                this.taskId$1 = taskId$1;
                this.engineExecutorContext$1 = engineExecutorContext$1;
                this.realCode$1 = realCode$1;
            }
        };
        Future<ExecuteResponse> future = this.backgroundOperationPool().submit(operation);
        return future.get();
    }

    public void logMemoryCache() {
        this.logger().info(new StringBuilder(38).append("logMemoryCache running driver number: ").append(this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache().size()).toString());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache()).asScala()).foreach((Function1 & Serializable & scala.Serializable)driverEntry -> {
            HiveEngineConcurrentConnExecutor.$anonfun$logMemoryCache$1(this, driverEntry);
            return BoxedUnit.UNIT;
        });
    }

    public ExecuteResponse org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$executeHQL(String taskId, EngineExecutionContext engineExecutorContext, String realCode, HiveDriverProxy driver) {
        boolean needRetry = true;
        int tryCount = 0;
        boolean hasResult = false;
        int rows = 0;
        int columnCount = 0;
        while (needRetry) {
            ErrorExecuteResponse errorExecuteResponse;
            block17: {
                needRetry = false;
                driver.setTryCount(tryCount + 1);
                long startTime = System.currentTimeMillis();
                try {
                    try {
                        List list;
                        CommandProcessorResponse hiveResponse;
                        CommandProcessorResponse commandProcessorResponse;
                        if (!HiveDriverProxy$.MODULE$.isIDriver(driver.getDriver())) {
                            IntRef compileRet = IntRef.create((int)-1);
                            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                compileRet$1.elem = driver.compile(realCode);
                                this.logger().info(new StringBuilder(50).append("driver compile realCode : \n ").append(realCode).append(" \n finished, status : ").append(compileRet$1.elem).toString());
                                if (0 != compileRet$1.elem) {
                                    this.logger().warn(new StringBuilder(39).append("compile realCode : \n ").append(realCode).append(" \n error status : ").append(compileRet$1.elem).toString());
                                    throw new HiveQueryFailedException(HiveErrorCodeSummary.COMPILE_HIVE_QUERY_ERROR.getErrorCode(), HiveErrorCodeSummary.COMPILE_HIVE_QUERY_ERROR.getErrorDesc());
                                }
                                QueryPlan queryPlan = driver.getPlan();
                                int numberOfJobs = Utilities.getMRTasks((List)queryPlan.getRootTasks()).size();
                                if (numberOfJobs > 0) {
                                    engineExecutorContext.appendStdout(new StringBuilder(37).append("Your hive taskId: ").append(taskId).append(" has ").append(numberOfJobs).append(" MR jobs to do").toString());
                                }
                                this.logger().info(new StringBuilder(16).append("there are ").append(numberOfJobs).append(" jobs.").toString());
                            }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                                HiveEngineConcurrentConnExecutor.$anonfun$executeHQL$2(this, x0$1);
                                return BoxedUnit.UNIT;
                            });
                            commandProcessorResponse = driver.run(realCode, compileRet.elem == 0);
                        } else {
                            commandProcessorResponse = hiveResponse = driver.run(realCode);
                        }
                        if (hiveResponse.getResponseCode() != 0) {
                            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().error("Hive query failed, response code is {}", (Object)BoxesRunTime.boxToInteger((int)hiveResponse.getResponseCode()));
                            errorExecuteResponse = new ErrorExecuteResponse(hiveResponse.getErrorMessage(), hiveResponse.getException());
                            break block17;
                        }
                        engineExecutorContext.appendStdout(new StringBuilder(37).append("Time taken: ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).append(", begin to fetch results.").toString());
                        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().info(new StringBuilder(41).append(this.getId()).append(" >> Time taken: ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).append(", begin to fetch results.").toString());
                        if (hiveResponse.getSchema() != null) {
                            list = hiveResponse.getSchema().getFieldSchemas();
                        } else if (driver.getSchema() != null) {
                            list = driver.getSchema().getFieldSchemas();
                        } else {
                            throw new HiveQueryFailedException(HiveErrorCodeSummary.GET_FIELD_SCHEMAS_ERROR.getErrorCode(), HiveErrorCodeSummary.GET_FIELD_SCHEMAS_ERROR.getErrorDesc());
                        }
                        List fieldSchemas = list;
                        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().debug(new StringBuilder(17).append("fieldSchemas are ").append(fieldSchemas).toString());
                        if (fieldSchemas == null || this.isNoResultSql(realCode)) {
                            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$onComplete();
                            errorExecuteResponse = new SuccessExecuteResponse();
                            break block17;
                        }
                        TableMetaData metaData = this.getResultMetaData(fieldSchemas, engineExecutorContext.getEnableResultsetMetaWithTableName());
                        rows = this.sendResultSet(engineExecutorContext, driver, metaData);
                        columnCount = fieldSchemas != null ? fieldSchemas.size() : 0;
                        hasResult = true;
                        continue;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (HiveDriverProxy$.MODULE$.isCommandNeedRetryException(throwable2)) {
                            ++tryCount;
                            needRetry = true;
                            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$onComplete();
                            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().warn("Retry hive query with a different approach...");
                            continue;
                        }
                        if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().error("query failed, reason : ", throwable3);
                            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$onComplete();
                            errorExecuteResponse = new ErrorExecuteResponse(throwable3.getMessage(), throwable3);
                            break block17;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache().remove(taskId);
                    this.logMemoryCache();
                    continue;
                }
            }
            return errorExecuteResponse;
        }
        if (hasResult) {
            engineExecutorContext.appendStdout(new StringBuilder(34).append("Fetched  ").append(columnCount).append(" col(s) : ").append(rows).append(" row(s) in hive").toString());
            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().info(new StringBuilder(38).append(this.getId()).append(" >> Fetched  ").append(columnCount).append(" col(s) : ").append(rows).append(" row(s) in hive").toString());
        }
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$onComplete();
        return new SuccessExecuteResponse();
    }

    private int sendResultSet(EngineExecutionContext engineExecutorContext, HiveDriverProxy driver, TableMetaData metaData) {
        ResultSetWriter resultSetWriter = engineExecutorContext.createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE());
        resultSetWriter.addMetaData((MetaData)metaData);
        int colLength = metaData.columns().length;
        ArrayList result = new ArrayList();
        int rows = 0;
        while (driver.getResults(result)) {
            Buffer scalaResult = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala();
            scalaResult.foreach((Function1 & Serializable & scala.Serializable)s -> {
                HiveEngineConcurrentConnExecutor.$anonfun$sendResultSet$1(this, colLength, resultSetWriter, s);
                return BoxedUnit.UNIT;
            });
            rows += result.size();
            result.clear();
        }
        engineExecutorContext.sendResultSet(resultSetWriter);
        return rows;
    }

    private TableMetaData getResultMetaData(List<FieldSchema> fieldSchemas, boolean useTableName) {
        List<FieldSchema> results = null;
        HashSet nameSet = new HashSet();
        ArrayList<FieldSchema> cleanSchema = new ArrayList<FieldSchema>();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldSchemas).asScala()).foreach((Function1 & Serializable & scala.Serializable)fieldSchema -> {
            String name = fieldSchema.getName();
            if (new StringOps(Predef$.MODULE$.augmentString(name)).split('.').length == 2) {
                nameSet.add((Object)new StringOps(Predef$.MODULE$.augmentString(name)).split('.')[1]);
                return ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)cleanSchema).asScala()).$plus$eq((Object)new FieldSchema(new StringOps(Predef$.MODULE$.augmentString(name)).split('.')[1], fieldSchema.getType(), fieldSchema.getComment()));
            }
            return BoxedUnit.UNIT;
        });
        results = nameSet.size() < ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldSchemas).asScala()).length() ? fieldSchemas : (useTableName ? fieldSchemas : cleanSchema);
        Column[] columns = (Column[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(results).asScala()).map((Function1 & Serializable & scala.Serializable)result -> new Column(result.getName(), DataType$.MODULE$.toDataType(result.getType().toLowerCase()), result.getComment()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
        TableMetaData metaData = new TableMetaData(columns);
        return metaData;
    }

    private boolean isNoResultSql(String sql) {
        return sql.trim().startsWith("create table") || sql.trim().startsWith("drop table");
    }

    public void org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$onComplete() {
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutorContext, String code, String completedLine) {
        String completeCode = new StringBuilder(0).append(code).append(completedLine).toString();
        return this.executeLine(engineExecutorContext, completeCode);
    }

    public void close() {
        this.killAll();
        if (this.backgroundOperationPool() != null) {
            Boolean bl;
            this.backgroundOperationPool().shutdown();
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)this.backgroundOperationPool().awaitTermination(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().warn(new StringBuilder(118).append("HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT = ").append(10).append(" seconds has been exceeded. RUNNING background operations will be shut down").toString(), (Throwable)e);
                bl = BoxedUnit.UNIT;
            }
            this.backgroundOperationPool_$eq(null);
        }
        super.close();
    }

    public HashMap<String, ResourceWithStatus> FetchResource() {
        HashMap<String, ResourceWithStatus> resourceMap = new HashMap<String, ResourceWithStatus>();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HadoopJobExecHelper.runningJobs).asScala()).foreach((Function1 & Serializable & scala.Serializable)yarnJob -> {
            Counters counters = yarnJob.getCounters();
            if (counters != null) {
                long millsMap = counters.getCounter((Enum)Counters$.MODULE$.MILLIS_MAPS());
                long millsReduces = counters.getCounter((Enum)Counters$.MODULE$.MILLIS_REDUCES());
                long totalMapCores = counters.getCounter((Enum)Counters$.MODULE$.VCORES_MILLIS_MAPS());
                long totalReducesCores = counters.getCounter((Enum)Counters$.MODULE$.VCORES_MILLIS_REDUCES());
                long totalMapMBMemory = counters.getCounter((Enum)Counters$.MODULE$.MB_MILLIS_MAPS());
                long totalReducesMBMemory = counters.getCounter((Enum)Counters$.MODULE$.MB_MILLIS_REDUCES());
                int avgCores = 0;
                long avgMemory = 0L;
                if (millsMap > 0L && millsReduces > 0L) {
                    avgCores = (int)Math.ceil(totalMapCores / millsMap + totalReducesCores / millsReduces);
                    avgMemory = (long)Math.ceil(totalMapMBMemory * 1024L * 1024L / millsMap + totalReducesMBMemory * 1024L * 1024L / millsReduces);
                    ResourceWithStatus yarnResource = new ResourceWithStatus(avgMemory, avgCores, 0, JobStatus.getJobRunState((int)yarnJob.getJobStatus().getRunState()), "default");
                    String applicationId = new StringBuilder(0).append(this.applicationStringName()).append(this.splitter()).append(yarnJob.getID().getJtIdentifier()).append(this.splitter()).append(yarnJob.getID().getId()).toString();
                    return resourceMap.put(applicationId, yarnResource);
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        return resourceMap;
    }

    public float progress(String taskID) {
        return 0.0f;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        return (JobProgressInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public void killTask(String taskID) {
        this.cleanup(taskID);
        super.killTask(taskID);
    }

    public void killAll() {
        Iterator<Map.Entry<String, HiveDriverProxy>> iterator = this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, HiveDriverProxy> entry = iterator.next();
            String taskID = entry.getKey();
            this.cleanup(taskID);
            super.killTask(taskID);
            iterator.remove();
        }
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$sessionState.deleteTmpOutputFile();
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$sessionState.deleteTmpErrOutputFile();
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$sessionState.close();
    }

    private void cleanup(String taskID) {
        HiveDriverProxy hiveDriverProxy;
        HiveDriverProxy driver = this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache().get(taskID);
        if (driver == null) {
            this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().warn(new StringBuilder(35).append("do cleanup taskId :").append(taskID).append(" driver is null.").toString());
            hiveDriverProxy = BoxedUnit.UNIT;
        } else {
            driver.close();
            hiveDriverProxy = this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache().remove(taskID);
        }
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().info(new StringBuilder(34).append("hive begins to kill job with id : ").append(taskID).toString());
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().info(new StringBuilder(18).append("hive engine type :").append(HiveEngineConfiguration$.MODULE$.HIVE_ENGINE_TYPE()).toString());
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG().info("hive killed job successfully");
    }

    public boolean supportCallBackLogs() {
        return true;
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (labels != null) {
            this.executorLabels().clear();
            this.executorLabels().addAll(labels);
            return;
        }
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        CommonNodeResource resource = new CommonNodeResource();
        resource.setUsedResource((Resource)NodeResourceUtils$.MODULE$.applyAsLoadInstanceResource(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions()));
        return resource;
    }

    public String getId() {
        return new StringBuilder(0).append(this.namePrefix()).append(this.id).toString();
    }

    public static final /* synthetic */ void $anonfun$logMemoryCache$1(HiveEngineConcurrentConnExecutor $this, Tuple2 driverEntry) {
        $this.logger().info(new StringBuilder(31).append("running driver with taskId : ").append(driverEntry._1()).append(" .").toString());
    }

    public static final /* synthetic */ void $anonfun$executeHQL$2(HiveEngineConcurrentConnExecutor $this, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().warn("obtain hive execute query plan failed,", (Throwable)exception);
            return;
        }
        if (throwable != null) {
            Throwable throwable2 = throwable;
            $this.logger().warn("obtain hive execute query plan failed,", throwable2);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$sendResultSet$1(HiveEngineConcurrentConnExecutor $this, int colLength$1, ResultSetWriter resultSetWriter$1, String s) {
        String[] arr = s.split("\t");
        ArrayBuffer arrAny = new ArrayBuffer();
        if (arr.length > colLength$1) {
            $this.logger().error("There is a \t tab in the result of hive code query, hive cannot cut it, please use spark to execute(\u67e5\u8be2\u7684\u7ed3\u679c\u4e2d\u6709\t\u5236\u8868\u7b26\uff0chive\u4e0d\u80fd\u8fdb\u884c\u5207\u5272,\u8bf7\u4f7f\u7528spark\u6267\u884c)");
            throw new ErrorException(60078, "There is a \\t tab in the result of your query, hive cannot cut it, please use spark to execute(\u60a8\u67e5\u8be2\u7684\u7ed3\u679c\u4e2d\u6709\\t\u5236\u8868\u7b26\uff0chive\u4e0d\u80fd\u8fdb\u884c\u5207\u5272,\u8bf7\u4f7f\u7528spark\u6267\u884c)");
        }
        if (arr.length == colLength$1) {
            List list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)list.add(x$1)));
        } else if (arr.length == 0) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), colLength$1).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> ((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava()).add(""));
        } else {
            int i2 = colLength$1 - arr.length;
            List list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)list.add(x$1)));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), i2).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> ((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)arrAny).asJava()).add(""));
        }
        resultSetWriter$1.addRecord((Record)new TableRecord((Object[])arrAny.toArray(ClassTag$.MODULE$.Any())));
    }

    public HiveEngineConcurrentConnExecutor(int id, SessionState sessionState, UserGroupInformation ugi, HiveConf hiveConf, ByteArrayOutputStream baos) {
        this.id = id;
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$sessionState = sessionState;
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$ugi = ugi;
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$hiveConf = hiveConf;
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$baos = baos;
        super(ConcurrentComputationExecutor$.MODULE$.$lessinit$greater$default$1());
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$LOG = LoggerFactory.getLogger((Class)this.getClass());
        this.namePrefix = "HiveEngineExecutor_";
        this.executorLabels = new ArrayList();
        this.org$apache$linkis$engineplugin$hive$executor$HiveEngineConcurrentConnExecutor$$driverCache = new ConcurrentHashMap<String, HiveDriverProxy>();
        this.applicationStringName = "application";
        this.splitter = "_";
    }
}

