/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.utils;

import java.io.IOException;
import java.util.Stack;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.fs.impl.LocalFileSystem;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class FileSystemUtils$
implements Logging {
    public static FileSystemUtils$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new FileSystemUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FileSystemUtils$ fileSystemUtils$ = this;
        synchronized (fileSystemUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void copyFile(FsPath filePath, FsPath origin, String user) {
        FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(filePath, user);
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> {
            Object object;
            fileSystem.init(null);
            if (!fileSystem.exists(filePath)) {
                Object object2 = !fileSystem.exists(filePath.getParent()) ? BoxesRunTime.boxToBoolean((boolean)fileSystem.mkdirs(filePath.getParent())) : BoxedUnit.UNIT;
                object = BoxesRunTime.boxToBoolean((boolean)fileSystem.createNewFile(filePath));
            } else {
                object = BoxedUnit.UNIT;
            }
            return fileSystem.copyFile(origin, filePath);
        }, (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> fileSystem.close()));
    }

    public void createNewFile(FsPath filePath, boolean createParentWhenNotExists) {
        this.createNewFile(filePath, StorageUtils$.MODULE$.getJvmUser(), createParentWhenNotExists);
    }

    public void createNewFile(FsPath filePath, String user, boolean createParentWhenNotExists) {
        FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(filePath, user);
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            fileSystem.init(null);
            MODULE$.createNewFileWithFileSystem(fileSystem, filePath, user, createParentWhenNotExists);
        }, (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> fileSystem.close()));
    }

    public void createNewFileWithFileSystem(FileSystem fileSystem, FsPath filePath, String user, boolean createParentWhenNotExists) {
        if (!fileSystem.exists(filePath)) {
            Object object;
            if (!fileSystem.exists(filePath.getParent())) {
                if (!createParentWhenNotExists) {
                    throw new IOException(new StringBuilder(28).append("parent dir ").append(filePath.getParent().getPath()).append(" dose not exists.").toString());
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.mkdirs(fileSystem, filePath.getParent(), user));
            } else {
                object = BoxedUnit.UNIT;
            }
            fileSystem.createNewFile(filePath);
            FileSystem fileSystem2 = fileSystem;
            if (fileSystem2 instanceof LocalFileSystem) {
                fileSystem.setOwner(filePath, user);
                return;
            }
            this.logger().info("doesn't need to call setOwner");
            return;
        }
    }

    public void createNewFileAndSetOwnerWithFileSystem(FileSystem fileSystem, FsPath filePath, String user, boolean createParentWhenNotExists) {
        if (!fileSystem.exists(filePath)) {
            Object object;
            if (!fileSystem.exists(filePath.getParent())) {
                if (!createParentWhenNotExists) {
                    throw new IOException(new StringBuilder(28).append("parent dir ").append(filePath.getParent().getPath()).append(" dose not exists.").toString());
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.mkdirsAndSetOwner(fileSystem, filePath.getParent(), user));
            } else {
                object = BoxedUnit.UNIT;
            }
            fileSystem.createNewFile(filePath);
            fileSystem.setOwner(filePath, user);
            return;
        }
    }

    public boolean mkdirs(FileSystem fileSystem, FsPath dest, String user) throws IOException {
        FsPath parentPath;
        Stack<FsPath> dirsToMake = new Stack<FsPath>();
        dirsToMake.push(dest);
        for (parentPath = dest.getParent(); parentPath != null && !fileSystem.exists(parentPath); parentPath = parentPath.getParent()) {
            dirsToMake.push(parentPath);
        }
        if (!fileSystem.canExecute(parentPath)) {
            throw new IOException(new StringBuilder(39).append("You have not permission to access path ").append(dest.getPath()).toString());
        }
        while (!dirsToMake.empty()) {
            FsPath path = (FsPath)dirsToMake.pop();
            fileSystem.mkdir(path);
            FileSystem fileSystem2 = fileSystem;
            if (fileSystem2 instanceof LocalFileSystem) {
                BoxesRunTime.boxToBoolean((boolean)fileSystem.setOwner(path, user));
                continue;
            }
            this.logger().info("doesn't need to call setOwner");
        }
        return true;
    }

    public boolean mkdirsAndSetOwner(FileSystem fileSystem, FsPath dest, String user) throws IOException {
        FsPath parentPath;
        Stack<FsPath> dirsToMake = new Stack<FsPath>();
        dirsToMake.push(dest);
        for (parentPath = dest.getParent(); parentPath != null && !fileSystem.exists(parentPath); parentPath = parentPath.getParent()) {
            dirsToMake.push(parentPath);
        }
        if (!fileSystem.canExecute(parentPath)) {
            throw new IOException(new StringBuilder(39).append("You have not permission to access path ").append(dest.getPath()).toString());
        }
        while (!dirsToMake.empty()) {
            FsPath path = (FsPath)dirsToMake.pop();
            fileSystem.mkdir(path);
            fileSystem.setOwner(path, user);
        }
        return true;
    }

    private FileSystemUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

