/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.fs.impl;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.hadoop.common.utils.HDFSUtils;
import org.apache.linkis.storage.conf.LinkisStorageConf;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSFileSystem
extends FileSystem {
    public static final String OSS_PREFIX = "oss://";
    private AliyunOSSFileSystem fs = null;
    private org.apache.hadoop.conf.Configuration conf = null;
    private String label = null;
    private static final Logger logger = LoggerFactory.getLogger(OSSFileSystem.class);

    @Override
    public String listRoot() throws IOException {
        return "/";
    }

    @Override
    public long getTotalSpace(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public long getFreeSpace(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public long getUsableSpace(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public long getLength(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public String checkSum(FsPath dest) throws IOException {
        return null;
    }

    @Override
    public boolean canExecute(FsPath dest) throws IOException {
        return true;
    }

    @Override
    public boolean setOwner(FsPath dest, String user, String group) throws IOException {
        return true;
    }

    @Override
    public boolean setOwner(FsPath dest, String user) throws IOException {
        return true;
    }

    @Override
    public boolean setGroup(FsPath dest, String group) throws IOException {
        return true;
    }

    public boolean mkdir(FsPath dest) throws IOException {
        String path = OSSFileSystem.checkOSSPath(dest.getPath());
        if (!this.canExecute(this.getParentPath(path))) {
            throw new IOException("You have not permission to access path " + path);
        }
        boolean result = this.fs.mkdirs(new Path(path), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        this.setPermission(new FsPath(path), this.getDefaultFolderPerm());
        return result;
    }

    public boolean mkdirs(FsPath dest) throws IOException {
        String path = OSSFileSystem.checkOSSPath(dest.getPath());
        FsPath parentPath = this.getParentPath(path);
        while (!this.exists(parentPath)) {
            parentPath = this.getParentPath(parentPath.getPath());
        }
        return this.fs.mkdirs(new Path(path), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
    }

    @Override
    public boolean setPermission(FsPath dest, String permission) throws IOException {
        return true;
    }

    @Override
    public FsPathListWithError listPathWithError(FsPath path) throws IOException {
        FileStatus[] stat = this.fs.listStatus(new Path(OSSFileSystem.checkOSSPath(path.getPath())));
        ArrayList<FsPath> fsPaths = new ArrayList<FsPath>();
        for (FileStatus f : stat) {
            fsPaths.add(this.fillStorageFile(new FsPath(StorageUtils.OSS_SCHEMA() + (String)StorageConfiguration.OSS_ACCESS_BUCKET_NAME().getValue() + "/" + f.getPath().toUri().getPath()), f));
        }
        if (fsPaths.isEmpty()) {
            return null;
        }
        return new FsPathListWithError(fsPaths, "");
    }

    public void init(Map<String, String> properties) throws IOException {
        if (this.label == null && Configuration.IS_MULTIPLE_YARN_CLUSTER()) {
            this.label = (String)StorageConfiguration.LINKIS_STORAGE_FS_LABEL().getValue();
        }
        this.conf = HDFSUtils.getConfigurationByLabel((String)this.user, (String)this.label);
        HashMap originProperties = Maps.newHashMap();
        originProperties.put("fs.oss.endpoint", StorageConfiguration.OSS_ENDPOINT().getValue());
        originProperties.put("fs.oss.accessKeyId", StorageConfiguration.OSS_ACCESS_KEY_ID().getValue());
        originProperties.put("fs.oss.accessKeySecret", StorageConfiguration.OSS_ACCESS_KEY_SECRET().getValue());
        for (String key : originProperties.keySet()) {
            String value = (String)originProperties.get(key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            this.conf.set(key, value);
        }
        if (MapUtils.isNotEmpty(properties)) {
            for (String key : properties.keySet()) {
                String v = properties.get(key);
                if (!StringUtils.isNotBlank((CharSequence)v)) continue;
                this.conf.set(key, v);
            }
        }
        this.fs = new AliyunOSSFileSystem();
        try {
            this.fs.initialize(new URI(StorageUtils.OSS_SCHEMA() + (String)StorageConfiguration.OSS_ACCESS_BUCKET_NAME().getValue()), this.conf);
        }
        catch (URISyntaxException e) {
            throw new IOException("init OSS FileSystem failed!");
        }
        if (this.fs == null) {
            throw new IOException("init OSS FileSystem failed!");
        }
    }

    public String fsName() {
        return StorageUtils.OSS();
    }

    public String rootUserName() {
        return null;
    }

    public FsPath get(String dest) throws IOException {
        String realPath = OSSFileSystem.checkOSSPath(dest);
        return this.fillStorageFile(new FsPath(realPath), this.fs.getFileStatus(new Path(realPath)));
    }

    public InputStream read(FsPath dest) throws IOException {
        if (!this.canRead(dest)) {
            throw new IOException("You have not permission to access path " + dest.getPath());
        }
        return this.fs.open(new Path(dest.getPath()), 128);
    }

    public OutputStream write(FsPath dest, boolean overwrite) throws IOException {
        String path = OSSFileSystem.checkOSSPath(dest.getPath());
        if (!this.exists(dest)) {
            if (!this.canWrite(dest.getParent())) {
                throw new IOException("You have not permission to access path " + dest.getParent());
            }
        } else if (!this.canWrite(dest)) {
            throw new IOException("You have not permission to access path " + path);
        }
        FSDataOutputStream out = this.fs.create(new Path(path), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL), overwrite, 0, (short)0, 0L, null);
        this.setPermission(dest, this.getDefaultFilePerm());
        return out;
    }

    public boolean create(String dest) throws IOException {
        if (!this.canExecute(this.getParentPath(dest))) {
            throw new IOException("You have not permission to access path " + dest);
        }
        boolean result = this.fs.createNewFile(new Path(OSSFileSystem.checkOSSPath(dest)));
        this.setPermission(new FsPath(dest), this.getDefaultFilePerm());
        return result;
    }

    @Override
    public boolean copy(String origin, String dest) throws IOException {
        if (!this.canExecute(this.getParentPath(dest))) {
            throw new IOException("You have not permission to access path " + dest);
        }
        boolean res = FileUtil.copy((org.apache.hadoop.fs.FileSystem)this.fs, (Path)new Path(OSSFileSystem.checkOSSPath(origin)), (org.apache.hadoop.fs.FileSystem)this.fs, (Path)new Path(OSSFileSystem.checkOSSPath(dest)), (boolean)false, (boolean)true, (org.apache.hadoop.conf.Configuration)this.fs.getConf());
        this.setPermission(new FsPath(dest), this.getDefaultFilePerm());
        return res;
    }

    public List<FsPath> list(FsPath path) throws IOException {
        FileStatus[] stat = this.fs.listStatus(new Path(OSSFileSystem.checkOSSPath(path.getPath())));
        ArrayList<FsPath> fsPaths = new ArrayList<FsPath>();
        for (FileStatus f : stat) {
            fsPaths.add(this.fillStorageFile(new FsPath(f.getPath().toUri().toString()), f));
        }
        return fsPaths;
    }

    public boolean canRead(FsPath dest) throws IOException {
        return true;
    }

    public boolean canRead(FsPath dest, String user) throws IOException {
        return false;
    }

    public boolean canWrite(FsPath dest) throws IOException {
        return true;
    }

    public boolean exists(FsPath dest) throws IOException {
        try {
            return this.fs.exists(new Path(OSSFileSystem.checkOSSPath(dest.getPath())));
        }
        catch (IOException e) {
            String message = e.getMessage();
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (message != null && message.matches(LinkisStorageConf.HDFS_FILE_SYSTEM_REST_ERRS()) || rootCauseMessage != null && rootCauseMessage.matches(LinkisStorageConf.HDFS_FILE_SYSTEM_REST_ERRS())) {
                logger.info("Failed to execute exists, retry", (Throwable)e);
                this.resetRootOSS();
                return this.fs.exists(new Path(OSSFileSystem.checkOSSPath(dest.getPath())));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRootOSS() throws IOException {
        if (this.fs != null) {
            OSSFileSystem oSSFileSystem = this;
            synchronized (oSSFileSystem) {
                if (this.fs != null) {
                    this.fs.close();
                    logger.warn(this.user + " FS reset close.");
                    this.init(null);
                }
            }
        }
    }

    public boolean delete(FsPath dest) throws IOException {
        String path = OSSFileSystem.checkOSSPath(dest.getPath());
        return this.fs.delete(new Path(path), true);
    }

    public boolean renameTo(FsPath oldDest, FsPath newDest) throws IOException {
        return this.fs.rename(new Path(OSSFileSystem.checkOSSPath(oldDest.getPath())), new Path(OSSFileSystem.checkOSSPath(newDest.getPath())));
    }

    public void close() throws IOException {
        if (null != this.fs) {
            this.fs.close();
        } else {
            logger.warn("FS was null, cannot close.");
        }
    }

    private FsPath fillStorageFile(FsPath fsPath, FileStatus fileStatus) throws IOException {
        fsPath.setAccess_time(fileStatus.getAccessTime());
        fsPath.setModification_time(fileStatus.getModificationTime());
        fsPath.setOwner(fileStatus.getOwner());
        fsPath.setGroup(fileStatus.getGroup());
        fsPath.setIsdir(fileStatus.isDirectory());
        return fsPath;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private static String checkOSSPath(String path) {
        try {
            boolean rmOSSPrefix;
            boolean checkOSSPath = (Boolean)StorageConfiguration.OSS_PATH_PREFIX_CHECK_ON().getValue();
            if (checkOSSPath && (rmOSSPrefix = ((Boolean)StorageConfiguration.OSS_PATH_PREFIX_REMOVE().getValue()).booleanValue())) {
                if (StringUtils.isBlank((CharSequence)path)) {
                    return path;
                }
                if (path.startsWith(OSS_PREFIX)) {
                    int remainIndex = OSS_PREFIX.length();
                    String[] t1 = path.substring(remainIndex).split("/", 2);
                    if (t1.length != 2) {
                        logger.warn("checkOSSPath Invalid path: " + path);
                        return path;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("checkOSSPath  ori path : {}, after path : {}", (Object)path, (Object)("/" + t1[1]));
                    }
                    return "/" + t1[1];
                }
                return path;
            }
        }
        catch (Exception e) {
            logger.warn("checkOSSPath error. msg : " + e.getMessage() + " ", (Throwable)e);
        }
        return path;
    }
}

