/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.security;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.RSAUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.exception.NonLoginException;
import org.apache.linkis.server.package$;
import org.apache.linkis.server.security.SSOUtils$;
import org.apache.linkis.server.security.SecurityFilter$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001\u0002\u0011\"\u00011BQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004J\u0001\u0001\u0006Ia\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u00199\u0006\u0001)A\u0005\u0019\"9\u0001\f\u0001b\u0001\n#I\u0006B\u0002/\u0001A\u0003%!\fC\u0003^\u0001\u0011\u0005c\fC\u0003h\u0001\u0011%\u0001\u000eC\u0003y\u0001\u0011\u0005\u0011\u0010\u0003\u0004y\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003G\u0001A\u0011CA\u0013\u0011\u001d\tI\u0003\u0001C!\u0003W9q!!\f\"\u0011\u0003\tyC\u0002\u0004!C!\u0005\u0011\u0011\u0007\u0005\u0007{=!\t!!\u000f\t\u0013\u0005mrB1A\u0005\n\u0005u\u0002\u0002CA&\u001f\u0001\u0006I!a\u0010\t\u0013\u00055sB1A\u0005\u0002\u0015J\u0006bBA(\u001f\u0001\u0006IA\u0017\u0005\n\u0003#z!\u0019!C\u0001KeCq!a\u0015\u0010A\u0003%!\fC\u0004\u0002V=!\t!a\u0016\t\u000f\u0005\rt\u0002\"\u0001\u0002f!9\u0011\u0011N\b\u0005\u0002\u0005-\u0004bBA8\u001f\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003kzA\u0011AA<\u0011\u001d\tyh\u0004C\u0001\u0003\u0003Cq!!\"\u0010\t\u0003\t9\tC\u0004\u0002\f>!\t!!$\t\u000f\u0005]u\u0002\"\u0001\u0002\u001a\nq1+Z2ve&$\u0018PR5mi\u0016\u0014(B\u0001\u0012$\u0003!\u0019XmY;sSRL(B\u0001\u0013&\u0003\u0019\u0019XM\u001d<fe*\u0011aeJ\u0001\u0007Y&t7.[:\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\r\u0001Q&\u000e\t\u0003]Mj\u0011a\f\u0006\u0003aE\nA\u0001\\1oO*\t!'\u0001\u0003kCZ\f\u0017B\u0001\u001b0\u0005\u0019y%M[3diB\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\bg\u0016\u0014h\u000f\\3u\u0015\u0005Q\u0014!\u00026bm\u0006D\u0018B\u0001\u001f8\u0005\u00191\u0015\u000e\u001c;fe\u00061A(\u001b8jiz\"\u0012a\u0010\t\u0003\u0001\u0002i\u0011!I\u0001\u0010e\u00164WM]3s-\u0006d\u0017\u000eZ1uKV\t1\t\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUIA\u0004C_>dW-\u00198\u0002!I,g-\u001a:feZ\u000bG.\u001b3bi\u0016\u0004\u0013\u0001\u00047pG\u0006d\u0017\t\u001a3sKN\u001cX#\u0001'\u0011\u00055#fB\u0001(S!\tyU)D\u0001Q\u0015\t\t6&\u0001\u0004=e>|GOP\u0005\u0003'\u0016\u000ba\u0001\u0015:fI\u00164\u0017BA+W\u0005\u0019\u0019FO]5oO*\u00111+R\u0001\u000eY>\u001c\u0017\r\\!eIJ,7o\u001d\u0011\u0002\u0011Q,7\u000f^+tKJ,\u0012A\u0017\t\u0003]mK!!V\u0018\u0002\u0013Q,7\u000f^+tKJ\u0004\u0013\u0001B5oSR$\"a\u00182\u0011\u0005\u0011\u0003\u0017BA1F\u0005\u0011)f.\u001b;\t\u000b\rD\u0001\u0019\u00013\u0002\u0019\u0019LG\u000e^3s\u0007>tg-[4\u0011\u0005Y*\u0017B\u000148\u000511\u0015\u000e\u001c;fe\u000e{gNZ5h\u000391\u0017\u000e\u001c;feJ+7\u000f]8og\u0016$\"!\u001b:\u0015\u0005}S\u0007\"B6\n\u0001\ba\u0017\u0001\u0003:fgB|gn]3\u0011\u00055\u0004X\"\u00018\u000b\u0005=<\u0014\u0001\u00025uiBL!!\u001d8\u0003'!#H\u000f]*feZdW\r\u001e*fgB|gn]3\t\u000bML\u0001\u0019\u0001;\u0002\u000f5,7o]1hKB\u0011QO^\u0007\u0002G%\u0011qo\t\u0002\b\u001b\u0016\u001c8/Y4f\u0003!!wNR5mi\u0016\u0014HC\u0001>})\t\u00195\u0010C\u0003l\u0015\u0001\u000fA\u000eC\u0003~\u0015\u0001\u0007a0A\u0004sKF,Xm\u001d;\u0011\u00055|\u0018bAA\u0001]\n\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u)\u001dy\u0016QAA\b\u00033Aq!a\u0002\f\u0001\u0004\tI!\u0001\btKJ4H.\u001a;SKF,Xm\u001d;\u0011\u0007Y\nY!C\u0002\u0002\u000e]\u0012abU3sm2,GOU3rk\u0016\u001cH\u000fC\u0004\u0002\u0012-\u0001\r!a\u0005\u0002\u001fM,'O\u001e7fiJ+7\u000f]8og\u0016\u00042ANA\u000b\u0013\r\t9b\u000e\u0002\u0010'\u0016\u0014h\u000f\\3u%\u0016\u001c\bo\u001c8tK\"9\u00111D\u0006A\u0002\u0005u\u0011a\u00034jYR,'o\u00115bS:\u00042ANA\u0010\u0013\r\t\tc\u000e\u0002\f\r&dG/\u001a:DQ\u0006Lg.\u0001\tbI\u0012\f5mY3tg\"+\u0017\rZ3sgR\u0019q,a\n\t\u000b-d\u0001\u0019\u00017\u0002\u000f\u0011,7\u000f\u001e:psR\tq,\u0001\bTK\u000e,(/\u001b;z\r&dG/\u001a:\u0011\u0005\u0001{1cA\b\u00024A\u0019A)!\u000e\n\u0007\u0005]RI\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003_\ta\u0001\\8hO\u0016\u0014XCAA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#S\u0005)1\u000f\u001c45U&!\u0011\u0011JA\"\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013aG(U\u0011\u0016\u0013vlU-T)\u0016ku,S$O\u001fJ+u,V'`+N+%+\u0001\u000fP)\"+%kX*Z'R+UjX%H\u001d>\u0013ViX+N?V\u001bVI\u0015\u0011\u00029\u0005cEjT,`\u0003\u000e\u001bUiU*`/&#\u0006jT+U?RKU*R(V)\u0006i\u0012\t\u0014'P/~\u000b5iQ#T'~;\u0016\n\u0016%P+R{F+S'F\u001fV#\u0006%\u0001\u0014hKRdunZ5o+N,'\u000f\u00165s_^\u001cX\t_2faRLwN\\,iK:$\u0016.\\3pkR$B!!\u0017\u0002`A!A)a\u0017M\u0013\r\ti&\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005\u0005t\u00031\u0001\u007f\u0003\r\u0011X-]\u0001\rO\u0016$Hj\\4j]V\u001bXM\u001d\u000b\u0005\u00033\n9\u0007\u0003\u0004\u0002ba\u0001\rA`\u0001\u0017SN\u0014V-];fgRLuM\\8sKRKW.Z8viR\u00191)!\u001c\t\r\u0005\u0005\u0014\u00041\u0001\u007f\u0003Y\tG\rZ%h]>\u0014X\rV5nK>,HoU5h]\u0006dGcA0\u0002t!)1N\u0007a\u0001Y\u0006\u0019\u0012n\u001a8pe\u0016$\u0016.\\3pkR\u001c\u0016n\u001a8bYR\u0011\u0011\u0011\u0010\t\u0004[\u0006m\u0014bAA?]\n11i\\8lS\u0016\f\u0011D]3n_Z,\u0017j\u001a8pe\u0016$\u0016.\\3pkR\u001c\u0016n\u001a8bYR\u0019q,a!\t\u000b-d\u0002\u0019\u00017\u0002!\u001d,G\u000fT8hS:,6/\u001a:oC6,Gc\u0001'\u0002\n\"1\u0011\u0011M\u000fA\u0002y\fAb]3u\u0019><\u0017N\\+tKJ$RaXAH\u0003'Ca!!%\u001f\u0001\u0004a\u0017\u0001\u0002:fgBDa!!&\u001f\u0001\u0004a\u0015\u0001C;tKJt\u0017-\\3\u0002\u001fI,Wn\u001c<f\u0019><\u0017N\\+tKJ$RaXAN\u0003;Ca!!\u0019 \u0001\u0004q\bBBAI?\u0001\u0007A\u000e")
public class SecurityFilter
implements Filter {
    private final boolean refererValidate = BoxesRunTime.unboxToBoolean((Object)ServerConfiguration$.MODULE$.BDP_SERVER_SECURITY_REFERER_VALIDATE().getValue());
    private final String localAddress = (String)ServerConfiguration$.MODULE$.BDP_SERVER_ADDRESS().getValue();
    private final String testUser = (String)ServerConfiguration$.MODULE$.BDP_TEST_USER().getValue();

    public static void removeLoginUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        SecurityFilter$.MODULE$.removeLoginUser(httpServletRequest, httpServletResponse);
    }

    public static void setLoginUser(HttpServletResponse httpServletResponse, String string) {
        SecurityFilter$.MODULE$.setLoginUser(httpServletResponse, string);
    }

    public static String getLoginUsername(HttpServletRequest httpServletRequest) {
        return SecurityFilter$.MODULE$.getLoginUsername(httpServletRequest);
    }

    public static void removeIgnoreTimeoutSignal(HttpServletResponse httpServletResponse) {
        SecurityFilter$.MODULE$.removeIgnoreTimeoutSignal(httpServletResponse);
    }

    public static Cookie ignoreTimeoutSignal() {
        return SecurityFilter$.MODULE$.ignoreTimeoutSignal();
    }

    public static void addIgnoreTimeoutSignal(HttpServletResponse httpServletResponse) {
        SecurityFilter$.MODULE$.addIgnoreTimeoutSignal(httpServletResponse);
    }

    public static boolean isRequestIgnoreTimeout(HttpServletRequest httpServletRequest) {
        return SecurityFilter$.MODULE$.isRequestIgnoreTimeout(httpServletRequest);
    }

    public static Option<String> getLoginUser(HttpServletRequest httpServletRequest) {
        return SecurityFilter$.MODULE$.getLoginUser(httpServletRequest);
    }

    public static Option<String> getLoginUserThrowsExceptionWhenTimeout(HttpServletRequest httpServletRequest) {
        return SecurityFilter$.MODULE$.getLoginUserThrowsExceptionWhenTimeout(httpServletRequest);
    }

    private boolean refererValidate() {
        return this.refererValidate;
    }

    private String localAddress() {
        return this.localAddress;
    }

    public String testUser() {
        return this.testUser;
    }

    public void init(FilterConfig filterConfig) {
    }

    private void filterResponse(Message message, HttpServletResponse response) {
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        response.setStatus(Message$.MODULE$.messageToHttpStatus(message));
        response.getOutputStream().print(Message$.MODULE$.response(message));
        response.getOutputStream().flush();
    }

    public boolean doFilter(HttpServletRequest request, HttpServletResponse response) {
        boolean bl;
        Object object = new Object();
        try {
            this.addAccessHeaders(response);
            if (this.refererValidate()) {
                String referer = request.getHeader("Referer");
                if (StringUtils.isNotEmpty((CharSequence)referer) && !referer.trim().contains(this.localAddress())) {
                    this.filterResponse(package$.MODULE$.validateFailed("\u4e0d\u5141\u8bb8\u7684\u8de8\u7ad9\u8bf7\u6c42\uff01"), response);
                    return false;
                }
                String string = request.getMethod().toUpperCase(Locale.getDefault());
                if ("GET".equals(string) ? true : ("POST".equals(string) ? true : ("PUT".equals(string) ? true : ("DELETE".equals(string) ? true : ("HEAD".equals(string) ? true : ("TRACE".equals(string) ? true : ("CONNECT".equals(string) ? true : "OPTIONS".equals(string)))))))) {
                } else {
                    this.filterResponse(package$.MODULE$.validateFailed("Do not use HTTP verbs to tamper with!(\u4e0d\u53ef\u4f7f\u7528HTTP\u52a8\u8bcd\u7be1\u6539\uff01)"), response);
                    return false;
                }
            }
            String string = request.getRequestURI();
            Object object2 = ServerConfiguration$.MODULE$.BDP_SERVER_SECURITY_SSL_URI().getValue();
            if (!(string != null ? !string.equals(object2) : object2 != null)) {
                Message message = Message$.MODULE$.ok("Get success!(\u83b7\u53d6\u6210\u529f\uff01)").data("enable", BoxesRunTime.boxToBoolean((boolean)SSOUtils$.MODULE$.sslEnable()));
                Object object3 = SSOUtils$.MODULE$.sslEnable() ? message.data("publicKey", RSAUtils$.MODULE$.getDefaultPublicKey()) : BoxedUnit.UNIT;
                this.filterResponse(message, response);
                bl = false;
            } else {
                String string2 = request.getRequestURI();
                Object object4 = ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_LOGIN_URI().getValue();
                if (!(string2 != null ? !string2.equals(object4) : object4 != null)) {
                    bl = true;
                } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_PASS_AUTH_REQUEST_URI())).exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SecurityFilter.$anonfun$doFilter$1(request, r)))) {
                    SecurityFilter$.MODULE$.org$apache$linkis$server$security$SecurityFilter$$logger().info(new StringBuilder(15).append("pass auth uri: ").append(request.getRequestURI()).toString());
                    bl = true;
                } else {
                    Option userName = (Option)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> SecurityFilter$.MODULE$.getLoginUser(request), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Throwable throwable = x0$1;
                        if (throwable instanceof NonLoginException) {
                            NonLoginException nonLoginException = (NonLoginException)((Object)((Object)throwable));
                            if (BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue())) {
                                return None$.MODULE$;
                            }
                            this.filterResponse(Message$.MODULE$.noLogin(nonLoginException.getMessage()).$less$less(request.getRequestURI()), response);
                            throw new NonLocalReturnControl.mcZ.sp(object, false);
                        }
                        if (throwable != null) {
                            Throwable throwable2 = throwable;
                            SecurityFilter$.MODULE$.org$apache$linkis$server$security$SecurityFilter$$logger().warn("", throwable2);
                            throw throwable2;
                        }
                        throw new MatchError((Object)throwable);
                    });
                    if (userName.isDefined()) {
                        bl = true;
                    } else if (BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue())) {
                        SecurityFilter$.MODULE$.org$apache$linkis$server$security$SecurityFilter$$logger().info(new StringBuilder(26).append("test mode! login for uri: ").append(request.getRequestURI()).toString());
                        SecurityFilter$.MODULE$.setLoginUser(response, this.testUser());
                        bl = true;
                    } else {
                        this.filterResponse(Message$.MODULE$.noLogin("You are not logged in, please login first!(\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55!)").$less$less(request.getRequestURI()), response);
                        bl = false;
                    }
                }
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.doFilter(request, response)) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        if (SecurityFilter$.MODULE$.isRequestIgnoreTimeout(request)) {
            SecurityFilter$.MODULE$.removeIgnoreTimeoutSignal(response);
            return;
        }
    }

    public void addAccessHeaders(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", (String)ServerConfiguration$.MODULE$.BDP_SERVER_WEB_ALLOW_ORIGIN().getValue());
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Headers", "authorization,Content-Type");
        response.setHeader("Access-Control-Allow-Methods", (String)ServerConfiguration$.MODULE$.BDP_SERVER_WEB_ALLOW_METHOD().getValue());
        DateFormat fullDateFormatEN = DateFormat.getDateTimeInstance(0, 0, new Locale("EN", "en"));
        response.setHeader("Date", fullDateFormatEN.format(new Date()));
    }

    public void destroy() {
    }

    public static final /* synthetic */ boolean $anonfun$doFilter$1(HttpServletRequest request$1, String r) {
        return !r.equals("") && request$1.getRequestURI().startsWith(r);
    }
}

