/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.restful;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.common.BmlProjectNoEditException;
import org.apache.linkis.bml.common.BmlQueryFailException;
import org.apache.linkis.bml.common.BmlServerParaErrorException;
import org.apache.linkis.bml.conf.BmlServerConfiguration;
import org.apache.linkis.bml.entity.DownloadModel;
import org.apache.linkis.bml.entity.ResourceTask;
import org.apache.linkis.bml.errorcode.BmlServerErrorCodeSummary;
import org.apache.linkis.bml.restful.RestfulUtils;
import org.apache.linkis.bml.service.BmlProjectService;
import org.apache.linkis.bml.service.DownloadService;
import org.apache.linkis.bml.service.ResourceService;
import org.apache.linkis.bml.service.TaskService;
import org.apache.linkis.bml.service.VersionService;
import org.apache.linkis.bml.util.HttpRequestHelper;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"bml(bigdata material library) project opreation"})
@RequestMapping(path={"/bml"})
@RestController
public class BmlProjectRestful {
    private static final Logger LOGGER = LoggerFactory.getLogger(BmlProjectRestful.class);
    private static final String PROJECT_NAME_STR = "projectName";
    private static final String EDIT_USERS_STR = "editUsers";
    private static final String ACCESS_USERS_STR = "accessUsers";
    public static final String DEFAULT_PROXY_USER = (String)BmlServerConfiguration.BML_DEFAULT_PROXY_USER().getValue();
    @Autowired
    private BmlProjectService bmlProjectService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private VersionService versionService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private DownloadService downloadService;

    @ApiOperation(value="createBmlProject", notes="create Bml project", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectName", required=true, dataType="String"), @ApiImplicitParam(name="editUsers", required=true, dataType="String"), @ApiImplicitParam(name="accessUsers", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"createBmlProject"}, method={RequestMethod.POST})
    public Message createBmlProject(HttpServletRequest request, @RequestBody JsonNode jsonNode) {
        String projectName = jsonNode.get(PROJECT_NAME_STR).textValue();
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("createBmlProject" + projectName));
        LOGGER.info("{} begins to create a project {} in bml", (Object)username, (Object)projectName);
        JsonNode editUserNode = jsonNode.get(EDIT_USERS_STR);
        JsonNode accessUserNode = jsonNode.get(ACCESS_USERS_STR);
        ArrayList<String> accessUsers = new ArrayList<String>();
        ArrayList<String> editUsers = new ArrayList<String>();
        if (editUserNode.isArray()) {
            for (JsonNode node : editUserNode) {
                editUsers.add(node.textValue());
            }
        }
        if (accessUserNode.isArray()) {
            for (JsonNode node : accessUserNode) {
                accessUsers.add(node.textValue());
            }
        }
        this.bmlProjectService.createBmlProject(projectName, username, editUsers, accessUsers);
        return Message.ok((String)"success to create project(\u521b\u5efa\u5de5\u7a0bok)");
    }

    @ApiOperation(value="uploadShareResource", notes="upload share resource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="system", required=false, dataType="String", value="system"), @ApiImplicitParam(name="resourceHeader", dataType="String", value="resource header"), @ApiImplicitParam(name="isExpire", dataType="String", value="is expire"), @ApiImplicitParam(name="expireType", dataType="String", value="expire type"), @ApiImplicitParam(name="expireTime", dataType="String", value="expire time"), @ApiImplicitParam(name="maxVersion", dataType="Integer", value="max version"), @ApiImplicitParam(name="projectName", required=true, dataType="String"), @ApiImplicitParam(name="file", required=true, dataType="List<MultipartFile>")})
    @RequestMapping(path={"uploadShareResource"}, method={RequestMethod.POST})
    public Message uploadShareResource(HttpServletRequest request, @RequestParam(name="system", required=false) String system, @RequestParam(name="resourceHeader", required=false) String resourceHeader, @RequestParam(name="isExpire", required=false) String isExpire, @RequestParam(name="expireType", required=false) String expireType, @RequestParam(name="expireTime", required=false) String expireTime, @RequestParam(name="maxVersion", required=false) Integer maxVersion, @RequestParam(name="projectName") String projectName, @RequestParam(name="file") List<MultipartFile> files) throws ErrorException {
        Message message;
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("uploadShareResource projectName:" + projectName));
        try {
            LOGGER.info("User {} starts uploading shared resources and is proxied as a Hadoop user for uploading(\u7528\u6237 {} \u5f00\u59cb\u4e0a\u4f20\u5171\u4eab\u8d44\u6e90,\u4f1a\u88ab\u4ee3\u7406\u6210hadoop\u7528\u6237\u8fdb\u884c\u4e0a\u4f20)", (Object)username, (Object)username);
            if (!this.bmlProjectService.checkEditPriv(projectName, username)) {
                LOGGER.error("{} does not have edit permission on project {}. Upload resource failed ({} \u5bf9\u5de5\u7a0b {} \u6ca1\u6709\u7f16\u8f91\u6743\u9650, \u4e0a\u4f20\u8d44\u6e90\u5931\u8d25)", new Object[]{username, projectName, username, projectName});
                throw new BmlProjectNoEditException(username + "does not have edit permission on project " + projectName + ". Upload resource failed" + username + " \u5bf9\u5de5\u7a0b { " + projectName + " }\u6ca1\u6709\u7f16\u8f91\u6743\u9650,\u4e0a\u4f20\u8d44\u6e90\u5931\u8d25");
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("system", system);
            properties.put("resourceHeader", resourceHeader);
            properties.put("isExpire", isExpire);
            properties.put("expireType", expireType);
            properties.put("expireTime", expireTime);
            properties.put("maxVersion", maxVersion);
            String clientIp = HttpRequestHelper.getIp(request);
            properties.put("clientIp", clientIp);
            ResourceTask resourceTask = this.taskService.createUploadTask(files, DEFAULT_PROXY_USER, properties);
            this.bmlProjectService.addProjectResource(resourceTask.getResourceId(), projectName);
            message = Message.ok((String)"The task of submitting and uploading resources was successful(\u63d0\u4ea4\u4e0a\u4f20\u8d44\u6e90\u4efb\u52a1\u6210\u529f)");
            message.data("resourceId", (Object)resourceTask.getResourceId());
            message.data("version", (Object)resourceTask.getVersion());
            message.data("taskId", (Object)resourceTask.getId());
            LOGGER.info("The task of submitting and uploading resources was successful (\u7528\u6237 {} \u63d0\u4ea4\u4e0a\u4f20\u8d44\u6e90\u4efb\u52a1\u6210\u529f), resourceId is {}", (Object)username, (Object)resourceTask.getResourceId());
        }
        catch (Exception e) {
            LOGGER.error("upload resource for user : {} failed, reason:", (Object)username, (Object)e);
            ErrorException exception = new ErrorException(50073, "The commit upload resource task failed: (\u63d0\u4ea4\u4e0a\u4f20\u8d44\u6e90\u4efb\u52a1\u5931\u8d25)" + e.getMessage());
            exception.initCause((Throwable)e);
            throw exception;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="updateShareResource", notes="update share resource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=true, dataType="String"), @ApiImplicitParam(name="file", required=true, dataType="MultipartFile", value="file")})
    @RequestMapping(path={"updateShareResource"}, method={RequestMethod.POST})
    public Message updateShareResource(HttpServletRequest request, @RequestParam(value="resourceId") String resourceId, @RequestParam(value="file") MultipartFile file) throws ErrorException {
        Message message;
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("updateShareResource:" + resourceId));
        if (StringUtils.isEmpty((CharSequence)resourceId) || !this.resourceService.checkResourceId(resourceId)) {
            LOGGER.error("the error resourceId  is {} ", (Object)resourceId);
            throw new BmlServerParaErrorException("the resourceId: " + resourceId + " is Null, illegal, or deleted (resourceId: " + resourceId + " \u4e3a\u7a7a,\u975e\u6cd5\u6216\u8005\u5df2\u88ab\u5220\u9664!)");
        }
        if (StringUtils.isEmpty((CharSequence)this.versionService.getNewestVersion(resourceId))) {
            LOGGER.error("If the material has not been uploaded or has been deleted, please call the upload interface first(resourceId:{} \u4e4b\u524d\u672a\u4e0a\u4f20\u7269\u6599,\u6216\u7269\u6599\u5df2\u88ab\u5220\u9664,\u8bf7\u5148\u8c03\u7528\u4e0a\u4f20\u63a5\u53e3.)", (Object)resourceId);
            throw new BmlServerParaErrorException("If the material has not been uploaded or has been deleted, please call the upload interface first (resourceId: " + resourceId + " \u4e4b\u524d\u672a\u4e0a\u4f20\u7269\u6599,\u6216\u7269\u6599\u5df2\u88ab\u5220\u9664,\u8bf7\u5148\u8c03\u7528\u4e0a\u4f20\u63a5\u53e3.!)");
        }
        try {
            String projectName = this.bmlProjectService.getProjectNameByResourceId(resourceId);
            if (!this.bmlProjectService.checkEditPriv(projectName, username)) {
                LOGGER.error("{} does not have edit permission on project {}. Upload resource failed ({} \u5bf9\u5de5\u7a0b {} \u6ca1\u6709\u7f16\u8f91\u6743\u9650, \u4e0a\u4f20\u8d44\u6e90\u5931\u8d25)", new Object[]{username, projectName, username, projectName});
                throw new BmlProjectNoEditException(username + "does not have edit permission on project: " + projectName + ". Upload resource failed (" + username + " \u5bf9\u5de5\u7a0b { " + projectName + " }\u6ca1\u6709\u7f16\u8f91\u6743\u9650,\u4e0a\u4f20\u8d44\u6e90\u5931\u8d25");
            }
            LOGGER.info("User {} starts updating resources {}, using proxy user Hadoop (\u7528\u6237 {} \u5f00\u59cb\u66f4\u65b0\u8d44\u6e90 {},\u4f7f\u7528\u4ee3\u7406\u7528\u6237hadoop)", new Object[]{username, resourceId, username, resourceId});
            String clientIp = HttpRequestHelper.getIp(request);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("clientIp", clientIp);
            ResourceTask resourceTask = null;
            String string = resourceId.intern();
            synchronized (string) {
                resourceTask = this.taskService.createUpdateTask(resourceId, DEFAULT_PROXY_USER, file, properties);
            }
            message = Message.ok((String)"The update resource task was submitted successfully(\u63d0\u4ea4\u66f4\u65b0\u8d44\u6e90\u4efb\u52a1\u6210\u529f)");
            message.data("resourceId", (Object)resourceId).data("version", (Object)resourceTask.getVersion()).data("taskId", (Object)resourceTask.getId());
        }
        catch (ErrorException e) {
            LOGGER.error("{} update resource failed, resourceId is {}, reason:", new Object[]{username, resourceId, e});
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("{} update resource failed, resourceId is {}, reason:", new Object[]{username, resourceId, e});
            ErrorException exception = new ErrorException(50073, "The commit upload resource task failed(\u63d0\u4ea4\u4e0a\u4f20\u8d44\u6e90\u4efb\u52a1\u5931\u8d25):" + e.getMessage());
            exception.initCause((Throwable)e);
            throw exception;
        }
        LOGGER.info("User {} ends updating resources {} (\u7528\u6237 {} \u7ed3\u675f\u66f4\u65b0\u8d44\u6e90 {} )", new Object[]{username, resourceId, username, resourceId});
        return message;
    }

    @ApiOperation(value="downloadShareResource", notes="download share resource", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", dataType="String"), @ApiImplicitParam(name="version", dataType="String")})
    @RequestMapping(path={"downloadShareResource"}, method={RequestMethod.GET})
    public void downloadShareResource(@RequestParam(value="resourceId", required=false) String resourceId, @RequestParam(value="version", required=false) String version, HttpServletResponse resp, HttpServletRequest request) throws IOException, ErrorException {
        String user = RestfulUtils.getUserName(request);
        Object message = null;
        resp.setContentType("application/x-msdownload");
        resp.setHeader("Content-Disposition", "attachment");
        String ip = HttpRequestHelper.getIp(request);
        DownloadModel downloadModel = new DownloadModel(resourceId, version, user, ip);
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)MessageFormat.format("downloadShareResource,resourceId:{0},version:{1}", resourceId, version));
        try {
            String projectName = this.bmlProjectService.getProjectNameByResourceId(resourceId);
            if (!this.bmlProjectService.checkAccessPriv(projectName, user)) {
                LOGGER.error("{} does not have view privileges on project {}. Download resource failed({} \u5bf9\u5de5\u7a0b {} \u6ca1\u6709\u67e5\u770b\u6743\u9650, \u4e0b\u8f7d\u8d44\u6e90\u5931\u8d25)", new Object[]{user, projectName, user, projectName});
                throw new BmlProjectNoEditException(user + " does not have view privileges on project " + projectName + ". Download resource failed" + user + " \u5bf9\u5de5\u7a0b { " + projectName + " }\u6ca1\u6709\u7f16\u8f91\u6743\u9650,\u4e0a\u4f20\u8d44\u6e90\u5931\u8d25");
            }
            LOGGER.info("user {} begin to downLoad resource resourceId is {}, version is {} ,ip is {}, \u5e76\u4ee3\u7406\u6210hadoop ", new Object[]{user, resourceId, version, ip});
            HashMap<String, Object> properties = new HashMap<String, Object>();
            boolean downloadResult = this.versionService.downloadResource(DEFAULT_PROXY_USER, resourceId, version, (OutputStream)resp.getOutputStream(), properties);
            downloadModel.setEndTime(new Date(System.currentTimeMillis()));
            downloadModel.setState(0);
            if (!downloadResult) {
                LOGGER.warn("ResourceId :{}, version:{} has a problem when user {} downloads the resource. The copied size is less than 0 (\u7528\u6237 {} \u4e0b\u8f7d\u8d44\u6e90 resourceId: {}, version:{} \u51fa\u73b0\u95ee\u9898,\u590d\u5236\u7684size\u5c0f\u4e8e0)", new Object[]{user, resourceId, version, user, resourceId, version});
                downloadModel.setState(1);
                throw new BmlQueryFailException(BmlServerErrorCodeSummary.FAILED_DOWNLOAD_RESOURCE.getErrorDesc());
            }
            this.downloadService.addDownloadRecord(downloadModel);
            LOGGER.info("User {} ends downloading the resource {} (\u7528\u6237 {} \u7ed3\u675f\u4e0b\u8f7d\u8d44\u6e90 {}) ", new Object[]{user, resourceId, user, resourceId});
        }
        catch (IOException e) {
            LOGGER.error("IO Exception: ResourceId :{}, version:{} (\u7528\u6237 {} \u4e0b\u8f7d\u8d44\u6e90 resourceId: {}, version:{} \u51fa\u73b0IO\u5f02\u5e38)", new Object[]{resourceId, version, user, resourceId, version, e});
            downloadModel.setEndTime(new Date());
            downloadModel.setState(1);
            this.downloadService.addDownloadRecord(downloadModel);
            throw new ErrorException(73562, "Sorry, the background IO error caused you to download the resources failed(\u62b1\u6b49,\u540e\u53f0IO\u9519\u8bef\u9020\u6210\u60a8\u672c\u6b21\u4e0b\u8f7d\u8d44\u6e90\u5931\u8d25)");
        }
        catch (Throwable t) {
            LOGGER.error("ResourceId :{}, version:{} abnormal when user {} downloads resource (\u7528\u6237 {} \u4e0b\u8f7d\u8d44\u6e90 resourceId: {}, version:{} \u51fa\u73b0\u5f02\u5e38)", new Object[]{resourceId, version, user, user, resourceId, version, t});
            downloadModel.setEndTime(new Date());
            downloadModel.setState(1);
            this.downloadService.addDownloadRecord(downloadModel);
            ErrorException errorException = new ErrorException(73561, "Sorry, the background service error caused you to download the resources failed (\u62b1\u6b49\uff0c\u540e\u53f0\u670d\u52a1\u51fa\u9519\u5bfc\u81f4\u60a8\u672c\u6b21\u4e0b\u8f7d\u8d44\u6e90\u5931\u8d25)");
            errorException.initCause(t);
            throw errorException;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)resp.getOutputStream());
        }
        LOGGER.info("{} Download resource {} successfully ({} \u4e0b\u8f7d\u8d44\u6e90 {} \u6210\u529f)", new Object[]{user, resourceId, user, resourceId});
    }

    @ApiOperation(value="getProjectInfo", notes="get project info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectName", dataType="String", value="project name")})
    @RequestMapping(path={"getProjectInfo"}, method={RequestMethod.GET})
    public Message getProjectInfo(HttpServletRequest request, @RequestParam(value="projectName", required=false) String projectName) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"getProjectInfo");
        return Message.ok((String)"Obtain project information successfully (\u83b7\u53d6\u5de5\u7a0b\u4fe1\u606f\u6210\u529f)");
    }

    @ApiOperation(value="attachResourceAndProject", notes="attach Resource and project", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectName", required=true, dataType="String"), @ApiImplicitParam(name="resourceId", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"attachResourceAndProject"}, method={RequestMethod.POST})
    public Message attachResourceAndProject(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws ErrorException {
        String projectName = jsonNode.get(PROJECT_NAME_STR).textValue();
        String resourceId = jsonNode.get("resourceId").textValue();
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)MessageFormat.format("attachResourceAndProject,resourceId:{0},projectName:{1}", resourceId, projectName));
        LOGGER.info("begin to attach {}  and {}", (Object)projectName, (Object)username);
        this.bmlProjectService.attach(projectName, resourceId);
        return Message.ok((String)"attach resource and project ok");
    }

    @ApiOperation(value="updateProjectUsers", notes="update project users info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectName", required=true, dataType="String"), @ApiImplicitParam(name="editUsers", required=true, dataType="String"), @ApiImplicitParam(name="accessUsers", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"updateProjectUsers"}, method={RequestMethod.POST})
    public Message updateProjectUsers(HttpServletRequest request, @RequestBody JsonNode jsonNode) throws ErrorException {
        JsonNode accessUsersNode;
        String projectName = jsonNode.get(PROJECT_NAME_STR).textValue();
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("updateProjectUsers,projectName:" + projectName));
        LOGGER.info("{} begins to update project users for {}", (Object)username, (Object)projectName);
        ArrayList<String> editUsers = new ArrayList<String>();
        ArrayList<String> accessUsers = new ArrayList<String>();
        JsonNode editUsersNode = jsonNode.get(EDIT_USERS_STR);
        if (editUsersNode.isArray()) {
            editUsersNode.forEach(node -> editUsers.add(node.textValue()));
        }
        if ((accessUsersNode = jsonNode.get(ACCESS_USERS_STR)).isArray()) {
            accessUsersNode.forEach(node -> accessUsers.add(node.textValue()));
        }
        this.bmlProjectService.updateProjectUsers(username, projectName, editUsers, accessUsers);
        return Message.ok((String)"Updated project related user success(\u66f4\u65b0\u5de5\u7a0b\u7684\u76f8\u5173\u7528\u6237\u6210\u529f)");
    }
}

