/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultDeserializer;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.conf.LinkisStorageConf$;
import org.apache.linkis.storage.domain.Dolphin$;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.ColLengthExceedException;
import org.apache.linkis.storage.exception.StorageErrorCode;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001\u0002\u0010 \u0001)B\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t+\u0002\u0011\t\u0011)A\u0005-\")Q\f\u0001C\u0001=\"91\r\u0001b\u0001\n\u0013!\u0007B\u00025\u0001A\u0003%Q\rC\u0005j\u0001\u0001\u0007\t\u0019!C\u0005U\"I1\u000e\u0001a\u0001\u0002\u0004%I\u0001\u001c\u0005\ne\u0002\u0001\r\u0011!Q!\nUB\u0011b\u001d\u0001A\u0002\u0003\u0007I\u0011\u0002;\t\u0013U\u0004\u0001\u0019!a\u0001\n\u00131\b\"\u0003=\u0001\u0001\u0004\u0005\t\u0015)\u0003I\u0011\u001dI\b\u00011A\u0005\niDqA \u0001A\u0002\u0013%q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0015B>\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013%\u0011q\u0001\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0002C\u0006\u0002\u0016\u0001\u0001\r\u0011!Q!\n\u0005%\u0001BB/\u0001\t\u0003\t9\u0002C\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!1\u0011\u0011\n\u0001\u0005BQDq!!#\u0001\t\u0003\tY\tC\u0004\u0002\u0010\u0002!\t!a\u0002\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0006bBA[\u0001\u0011\u0005\u0013q\u0017\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\t\t\u000f\u0001C!\u0003oCq!a<\u0001\t\u0003\n9D\u0001\fTi>\u0014\u0018mZ3SKN,H\u000e^*fiJ+\u0017\rZ3s\u0015\t\u0001\u0013%A\u0005sKN,H\u000e^:fi*\u0011!eI\u0001\bgR|'/Y4f\u0015\t!S%\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007-:TiE\u0002\u0001Y-\u0003B!L\u001a6\t6\taF\u0003\u0002!_)\u0011\u0001'M\u0001\u0003S>T!AM\u0012\u0002\r\r|W.\\8o\u0013\t!dFA\bSKN,H\u000e^*fiJ+\u0017\rZ3s!\t1t\u0007\u0004\u0001\u0005\u000ba\u0002!\u0019A\u001d\u0003\u0003-\u000b\"A\u000f!\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000f9{G\u000f[5oOB\u0011\u0011IQ\u0007\u0002_%\u00111i\f\u0002\t\u001b\u0016$\u0018\rR1uCB\u0011a'\u0012\u0003\u0006\r\u0002\u0011\ra\u0012\u0002\u0002-F\u0011!\b\u0013\t\u0003\u0003&K!AS\u0018\u0003\rI+7m\u001c:e!\tau*D\u0001N\u0015\tq\u0015'A\u0003vi&d7/\u0003\u0002Q\u001b\n9Aj\\4hS:<\u0017!\u0003:fgVdGoU3u!\u0011i3+\u000e#\n\u0005Qs#!\u0003*fgVdGoU3u\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\u0005][V\"\u0001-\u000b\u0005AJ&\"\u0001.\u0002\t)\fg/Y\u0005\u00039b\u00131\"\u00138qkR\u001cFO]3b[\u00061A(\u001b8jiz\"2aX1c!\u0011\u0001\u0007!\u000e#\u000e\u0003}AQ!U\u0002A\u0002ICQ!V\u0002A\u0002Y\u000bA\u0002Z3tKJL\u0017\r\\5{KJ,\u0012!\u001a\t\u0005[\u0019,D)\u0003\u0002h]\t\u0011\"+Z:vYR$Um]3sS\u0006d\u0017N_3s\u00035!Wm]3sS\u0006d\u0017N_3sA\u0005AQ.\u001a;b\t\u0006$\u0018-F\u00016\u00031iW\r^1ECR\fw\fJ3r)\ti\u0007\u000f\u0005\u0002<]&\u0011q\u000e\u0010\u0002\u0005+:LG\u000fC\u0004r\u000f\u0005\u0005\t\u0019A\u001b\u0002\u0007a$\u0013'A\u0005nKR\fG)\u0019;bA\u0005\u0019!o\\<\u0016\u0003!\u000bqA]8x?\u0012*\u0017\u000f\u0006\u0002no\"9\u0011OCA\u0001\u0002\u0004A\u0015\u0001\u0002:po\u0002\n\u0001B]8x\u0007>,h\u000e^\u000b\u0002wB\u00111\b`\u0005\u0003{r\u00121!\u00138u\u00031\u0011xn^\"pk:$x\fJ3r)\ri\u0017\u0011\u0001\u0005\bc6\t\t\u00111\u0001|\u0003%\u0011xn^\"pk:$\b%\u0001\u0002ggV\u0011\u0011\u0011\u0002\t\u0004\u0003\u0006-\u0011bAA\u0007_\t\u0011ai]\u0001\u0007MN|F%Z9\u0015\u00075\f\u0019\u0002\u0003\u0005r!\u0005\u0005\t\u0019AA\u0005\u0003\r17\u000f\t\u000b\u0006?\u0006e\u00111\u0004\u0005\u0006#J\u0001\rA\u0015\u0005\b\u0003;\u0011\u0002\u0019AA\u0010\u0003\u00151\u0018\r\\;f!\u0011\t\t#a\f\u000f\t\u0005\r\u00121\u0006\t\u0004\u0003KaTBAA\u0014\u0015\r\tI#K\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055B(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\t\u0019D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003[a\u0014\u0001B5oSR$\u0012!\\\u0001\te\u0016\fG\rT5oKR\u0011\u0011Q\b\t\u0006w\u0005}\u00121I\u0005\u0004\u0003\u0003b$!B!se\u0006L\bcA\u001e\u0002F%\u0019\u0011q\t\u001f\u0003\t\tKH/Z\u0001\nO\u0016$(+Z2pe\u0012DS!FA'\u00033\u0002RaOA(\u0003'J1!!\u0015=\u0005\u0019!\bN]8xgB\u0019q+!\u0016\n\u0007\u0005]\u0003LA\u0006J\u001f\u0016C8-\u001a9uS>t\u0017g\u0002\u0010\u0002 \u0005m\u0013qQ\u0019\nG\u0005u\u0013QMA?\u0003O*B!a\u0018\u0002bU\u0011\u0011q\u0004\u0003\b\u0003GJ#\u0019AA7\u0005\u0005!\u0016\u0002BA4\u0003S\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA6y\u00051A\u000f\u001b:poN\f2AOA8!\u0011\t\t(a\u001e\u000f\u0007m\n\u0019(C\u0002\u0002vq\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002z\u0005m$!\u0003+ie><\u0018M\u00197f\u0015\r\t)\bP\u0019\nG\u0005}\u0014\u0011QAB\u0003Wr1aOAA\u0013\r\tY\u0007P\u0019\u0006Emb\u0014Q\u0011\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005M\u0013!B:fi\u001a\u001bHcA7\u0002\u000e\"9\u0011Q\u0001\fA\u0002\u0005%\u0011!B4fi\u001a\u001b\u0018aC4fi6+G/\u0019#bi\u0006,\u0012\u0001\u0011\u0015\u00061\u00055\u0013qS\u0019\b=\u0005}\u0011\u0011TAPc%\u0019\u0013QLA3\u00037\u000b9'M\u0005$\u0003\u007f\n\t)!(\u0002lE*!e\u000f\u001f\u0002\u0006F\u001aa%a\u0015\u0002\tM\\\u0017\u000e\u001d\u000b\u0004w\u0006\u0015\u0006BBAT3\u0001\u000710A\u0005sK\u000e|'\u000f\u001a(v[\"*\u0011$!\u0014\u0002,F:a$a\b\u0002.\u0006M\u0016'C\u0012\u0002^\u0005\u0015\u0014qVA4c%\u0019\u0013qPAA\u0003c\u000bY'M\u0003#wq\n))M\u0002'\u0003'\n1bZ3u!>\u001c\u0018\u000e^5p]V\u0011\u0011\u0011\u0018\t\u0004w\u0005m\u0016bAA_y\t!Aj\u001c8hQ\u0015Q\u0012QJAac\u001dq\u0012qDAb\u0003\u0013\f\u0014bIA/\u0003K\n)-a\u001a2\u0013\r\ny(!!\u0002H\u0006-\u0014'\u0002\u0012<y\u0005\u0015\u0015g\u0001\u0014\u0002T\u00059\u0001.Y:OKb$XCAAh!\rY\u0014\u0011[\u0005\u0004\u0003'd$a\u0002\"p_2,\u0017M\u001c\u0015\u00067\u00055\u0013q[\u0019\b=\u0005}\u0011\u0011\\Apc%\u0019\u0013QLA3\u00037\f9'M\u0005$\u0003\u007f\n\t)!8\u0002lE*!e\u000f\u001f\u0002\u0006F\u001aa%a\u0015\u0002\u0013\u00054\u0018-\u001b7bE2,\u0007&\u0002\u000f\u0002N\u0005\u0015\u0018g\u0002\u0010\u0002 \u0005\u001d\u0018Q^\u0019\nG\u0005u\u0013QMAu\u0003O\n\u0014bIA@\u0003\u0003\u000bY/a\u001b2\u000b\tZD(!\"2\u0007\u0019\n\u0019&A\u0003dY>\u001cX\r")
public class StorageResultSetReader<K extends MetaData, V extends Record>
extends ResultSetReader<K, V>
implements Logging {
    private final ResultSet<K, V> resultSet;
    private final InputStream inputStream;
    private final ResultDeserializer<K, V> deserializer;
    private K metaData;
    private Record row;
    private int rowCount;
    private Fs fs;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        StorageResultSetReader storageResultSetReader = this;
        synchronized (storageResultSetReader) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ResultDeserializer<K, V> deserializer() {
        return this.deserializer;
    }

    private K metaData() {
        return this.metaData;
    }

    private void metaData_$eq(K x$1) {
        this.metaData = x$1;
    }

    private Record row() {
        return this.row;
    }

    private void row_$eq(Record x$1) {
        this.row = x$1;
    }

    private int rowCount() {
        return this.rowCount;
    }

    private void rowCount_$eq(int x$1) {
        this.rowCount = x$1;
    }

    private Fs fs() {
        return this.fs;
    }

    private void fs_$eq(Fs x$1) {
        this.fs = x$1;
    }

    public void init() {
        String resType = Dolphin$.MODULE$.getType(this.inputStream);
        String string = this.resultSet.resultSetType();
        String string2 = resType;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new IOException(new StringBuilder(35).append("File type does not match(\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d): ").append(ResultSetFactory$.MODULE$.resultSetType().getOrElse((Object)resType, (Function0 & Serializable & scala.Serializable)() -> "TABLE")).toString());
        }
    }

    public byte[] readLine() {
        int rowLen = 0;
        try {
            rowLen = Dolphin$.MODULE$.readInt(this.inputStream);
        }
        catch (StorageWarnException storageWarnException) {
            this.logger().info("Read finished(\u8bfb\u53d6\u5b8c\u6bd5)");
            return null;
        }
        catch (Throwable t) {
            throw t;
        }
        if ((long)rowLen > LinkisStorageConf$.MODULE$.LINKIS_READ_ROW_BYTE_MAX_LEN()) {
            throw new ColLengthExceedException(LinkisStorageErrorCodeSummary.RESULT_ROW_LENGTH.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.RESULT_ROW_LENGTH.getErrorDesc(), BoxesRunTime.boxToInteger((int)rowLen), BoxesRunTime.boxToLong((long)LinkisStorageConf$.MODULE$.LINKIS_READ_ROW_BYTE_MAX_LEN())));
        }
        byte[] bytes = null;
        try {
            bytes = new byte[rowLen];
        }
        catch (OutOfMemoryError e) {
            this.logger().error("Result set read oom, read size {} Byte", (Object)BoxesRunTime.boxToInteger((int)rowLen));
            throw new StorageErrorException(StorageErrorCode.FS_OOM.getCode(), StorageErrorCode.FS_OOM.getMessage(), e);
        }
        int len = StorageUtils$.MODULE$.readBytes(this.inputStream, bytes, rowLen);
        if (len != rowLen) {
            throw new StorageErrorException(StorageErrorCode.INCONSISTENT_DATA.getCode(), String.format(StorageErrorCode.INCONSISTENT_DATA.getMessage(), Integer.toString(len), Integer.toString(rowLen)));
        }
        this.rowCount_$eq(this.rowCount() + 1);
        return bytes;
    }

    public Record getRecord() throws IOException {
        if (this.metaData() == null) {
            throw new IOException("Must read metadata first(\u5fc5\u987b\u5148\u8bfb\u53d6metadata)");
        }
        if (this.row() == null) {
            throw new IOException("Can't get the value of the field, maybe the IO stream has been read or has been closed!(\u62ff\u4e0d\u5230\u5b57\u6bb5\u7684\u503c\uff0c\u4e5f\u8bb8IO\u6d41\u5df2\u8bfb\u53d6\u5b8c\u6bd5\u6216\u5df2\u88ab\u5173\u95ed\uff01)");
        }
        return this.row();
    }

    public void setFs(Fs fs) {
        this.fs_$eq(fs);
    }

    public Fs getFs() {
        return this.fs();
    }

    public MetaData getMetaData() throws IOException {
        if (this.metaData() == null) {
            this.init();
        }
        this.metaData_$eq(this.deserializer().createMetaData(this.readLine()));
        return this.metaData();
    }

    public int skip(int recordNum) throws IOException {
        int n;
        Object object = new Object();
        try {
            if (recordNum < 0) {
                return -1;
            }
            Object object2 = this.metaData() == null ? this.getMetaData() : BoxedUnit.UNIT;
            RichInt$.MODULE$.until$extension1(Predef$.MODULE$.intWrapper(recordNum), 0, -1).foreach((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> {
                long l;
                try {
                    l = $this.inputStream.skip(Dolphin$.MODULE$.readInt($this.inputStream));
                }
                catch (Throwable t) {
                    throw new NonLocalReturnControl.mcI.sp(object, recordNum - i);
                }
                return l;
            });
            n = recordNum;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    public long getPosition() throws IOException {
        return this.rowCount();
    }

    public boolean hasNext() throws IOException {
        Object object = this.metaData() == null ? this.getMetaData() : BoxedUnit.UNIT;
        byte[] line = this.readLine();
        if (line == null) {
            return false;
        }
        this.row_$eq(this.deserializer().createRecord(line));
        return this.row() != null;
    }

    public long available() throws IOException {
        return this.inputStream.available();
    }

    public void close() {
        this.inputStream.close();
        if (this.fs() != null) {
            Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fs().close());
            return;
        }
    }

    public StorageResultSetReader(ResultSet<K, V> resultSet, InputStream inputStream) {
        this.resultSet = resultSet;
        this.inputStream = inputStream;
        super(resultSet, inputStream);
        Logging.$init$((Logging)this);
        this.deserializer = resultSet.createResultSetDeserializer();
        this.rowCount = 0;
    }

    public StorageResultSetReader(ResultSet<K, V> resultSet, String value) {
        this(resultSet, new ByteArrayInputStream(value.getBytes(Dolphin$.MODULE$.CHAR_SET())));
    }
}

