/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.factory.impl;

import org.apache.linkis.common.io.Fs;
import org.apache.linkis.storage.factory.BuildFactory;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.fs.impl.HDFSFileSystem;
import org.apache.linkis.storage.io.IOMethodInterceptorCreator$;
import org.apache.linkis.storage.utils.StorageUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;

public class BuildHDFSFileSystem
implements BuildFactory {
    @Override
    public Fs getFs(String user, String proxyUser) {
        FileSystem fs = null;
        if (StorageUtils.isHDFSNode()) {
            fs = new HDFSFileSystem();
        } else {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(HDFSFileSystem.class.getSuperclass());
            enhancer.setCallback((Callback)IOMethodInterceptorCreator$.MODULE$.getIOMethodInterceptor(this.fsName()));
            fs = (FileSystem)enhancer.create();
        }
        fs.setUser(proxyUser);
        return fs;
    }

    @Override
    public Fs getFs(String user, String proxyUser, String label) {
        HDFSFileSystem fs = new HDFSFileSystem();
        fs.setUser(proxyUser);
        fs.setLabel(label);
        return fs;
    }

    @Override
    public String fsName() {
        return StorageUtils.HDFS();
    }
}

