/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.server.hook;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.ecm.core.engineconn.EngineConn;
import org.apache.linkis.ecm.server.hook.ECMHook;
import org.apache.linkis.ecm.server.service.LocalDirsHandleService;
import org.apache.linkis.ecm.server.service.impl.DefaultLocalDirsHandleService;
import org.apache.linkis.ecm.server.util.ECMUtils$;
import org.apache.linkis.manager.common.protocol.bml.BmlResource;
import org.apache.linkis.manager.engineplugin.common.launch.entity.EngineConnLaunchRequest;
import org.apache.linkis.manager.engineplugin.common.launch.process.Environment$;
import org.apache.linkis.manager.engineplugin.common.launch.process.ProcessEngineConnLaunchRequest;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.apache.linkis.udf.UDFClient$;
import org.apache.linkis.udf.vo.UDFInfoVo;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001M4AAC\u0006\u00011!)1\u0006\u0001C\u0001Y!9a\u0006\u0001a\u0001\n\u0013y\u0003b\u0002\u001c\u0001\u0001\u0004%Ia\u000e\u0005\u0007{\u0001\u0001\u000b\u0015\u0002\u0019\t\u000fy\u0002!\u0019!C\u0005\u007f!1q\t\u0001Q\u0001\n\u0001CQ\u0001\u0013\u0001\u0005B%CQa\u0019\u0001\u0005B\u0011DQA\u001a\u0001\u0005B\u001d\u0014\u0011CS1s+\u00123Ej\\1e\u000b\u000ek\u0005j\\8l\u0015\taQ\"\u0001\u0003i_>\\'B\u0001\b\u0010\u0003\u0019\u0019XM\u001d<fe*\u0011\u0001#E\u0001\u0004K\u000el'B\u0001\n\u0014\u0003\u0019a\u0017N\\6jg*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\r GA\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0011\u000e\u0003-I!AI\u0006\u0003\u000f\u0015\u001bU\nS8pWB\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0006kRLGn\u001d\u0006\u0003QE\taaY8n[>t\u0017B\u0001\u0016&\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0017\u0011\u0005\u0001\u0002\u0011A\u00067pG\u0006dG)\u001b:t\u0011\u0006tG\r\\3TKJ4\u0018nY3\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR!aM\u0007\u0002\u000fM,'O^5dK&\u0011QG\r\u0002\u0017\u0019>\u001c\u0017\r\u001c#jeND\u0015M\u001c3mKN+'O^5dK\u0006QBn\\2bY\u0012K'o\u001d%b]\u0012dWmU3sm&\u001cWm\u0018\u0013fcR\u0011\u0001h\u000f\t\u00035eJ!AO\u000e\u0003\tUs\u0017\u000e\u001e\u0005\by\r\t\t\u00111\u00011\u0003\rAH%M\u0001\u0018Y>\u001c\u0017\r\u001c#jeND\u0015M\u001c3mKN+'O^5dK\u0002\n!AZ:\u0016\u0003\u0001\u0003\"!Q#\u000e\u0003\tS!AP\"\u000b\u0005\u0011\u000b\u0012aB:u_J\fw-Z\u0005\u0003\r\n\u0013!BR5mKNK8\u000f^3n\u0003\r17\u000fI\u0001\rE\u00164wN]3MCVt7\r\u001b\u000b\u0004q)K\u0006\"B&\b\u0001\u0004a\u0015a\u0002:fcV,7\u000f\u001e\t\u0003\u001b^k\u0011A\u0014\u0006\u0003\u001fB\u000ba!\u001a8uSRL(BA)S\u0003\u0019a\u0017-\u001e8dQ*\u0011\u0001f\u0015\u0006\u0003)V\u000bA\"\u001a8hS:,\u0007\u000f\\;hS:T!AV\t\u0002\u000f5\fg.Y4fe&\u0011\u0001L\u0014\u0002\u0018\u000b:<\u0017N\\3D_:tG*Y;oG\"\u0014V-];fgRDQAW\u0004A\u0002m\u000bAaY8o]B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u000bK:<\u0017N\\3d_:t'B\u00011\u0010\u0003\u0011\u0019wN]3\n\u0005\tl&AC#oO&tWmQ8o]\u0006Y\u0011M\u001a;fe2\u000bWO\\2i)\tAT\rC\u0003[\u0011\u0001\u00071,A\u0004hKRt\u0015-\\3\u0016\u0003!\u0004\"!\u001b9\u000f\u0005)t\u0007CA6\u001c\u001b\u0005a'BA7\u0018\u0003\u0019a$o\\8u}%\u0011qnG\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002p7\u0001")
public class JarUDFLoadECMHook
implements ECMHook,
Logging {
    private LocalDirsHandleService localDirsHandleService;
    private final FileSystem fs;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        JarUDFLoadECMHook jarUDFLoadECMHook = this;
        synchronized (jarUDFLoadECMHook) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private LocalDirsHandleService localDirsHandleService() {
        return this.localDirsHandleService;
    }

    private void localDirsHandleService_$eq(LocalDirsHandleService x$1) {
        this.localDirsHandleService = x$1;
    }

    private FileSystem fs() {
        return this.fs;
    }

    @Override
    public void beforeLaunch(EngineConnLaunchRequest request, EngineConn conn) {
        EngineConnLaunchRequest engineConnLaunchRequest = request;
        if (engineConnLaunchRequest instanceof ProcessEngineConnLaunchRequest) {
            Object object;
            ProcessEngineConnLaunchRequest processEngineConnLaunchRequest = (ProcessEngineConnLaunchRequest)engineConnLaunchRequest;
            this.logger().info("start loading UDFs");
            String user = processEngineConnLaunchRequest.user();
            String ticketId = processEngineConnLaunchRequest.ticketId();
            boolean udfAllLoad = new StringOps(Predef$.MODULE$.augmentString(processEngineConnLaunchRequest.creationDesc().properties().getOrDefault("linkis.user.udf.all.load", "true"))).toBoolean();
            String udfIdStr = processEngineConnLaunchRequest.creationDesc().properties().getOrDefault("linkis.user.udf.custom.ids", "");
            long[] udfIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])udfIdStr.split(","))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JarUDFLoadECMHook.$anonfun$beforeLaunch$1(x$1))))).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToLong((long)JarUDFLoadECMHook.$anonfun$beforeLaunch$2(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            String engineType = LabelUtil$.MODULE$.getEngineType(processEngineConnLaunchRequest.labels());
            String workDir = this.localDirsHandleService().getEngineConnWorkDir(user, ticketId, engineType);
            String pubDir = this.localDirsHandleService().getEngineConnPublicDir();
            String udfDir = new StringBuilder(3).append(workDir).append(File.separator).append("udf").toString();
            FsPath fsPath = new FsPath(new StringBuilder(0).append(StorageUtils$.MODULE$.FILE_SCHEMA()).append(udfDir).toString());
            if (!this.fs().exists(fsPath)) {
                FileSystemUtils$.MODULE$.mkdirs(this.fs(), fsPath, Utils$.MODULE$.getJvmUser());
                object = BoxesRunTime.boxToBoolean((boolean)this.fs().setPermission(fsPath, "rwxrwxrwx"));
            } else {
                object = BoxedUnit.UNIT;
            }
            ArrayBuffer udfInfos = udfAllLoad ? UDFClient$.MODULE$.getJarUdf(processEngineConnLaunchRequest.user()) : UDFClient$.MODULE$.getJarUdfByIds(processEngineConnLaunchRequest.user(), udfIds);
            HashSet fileNameSet = new HashSet();
            udfInfos.foreach((Function1 & Serializable & scala.Serializable)udfInfo -> {
                JarUDFLoadECMHook.$anonfun$beforeLaunch$3(this, pubDir, fileNameSet, conn, udfDir, udfInfo);
                return BoxedUnit.UNIT;
            });
            HashSet udfJars = (HashSet)fileNameSet.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(0).append(udfDir).append(File.separator).append((String)x$1).toString(), HashSet$.MODULE$.canBuildFrom());
            processEngineConnLaunchRequest.environment().put(Environment$.MODULE$.UDF_JARS().toString(), udfJars.mkString(","));
            return;
        }
        throw new MatchError((Object)engineConnLaunchRequest);
    }

    @Override
    public void afterLaunch(EngineConn conn) {
    }

    @Override
    public String getName() {
        return "JarUDFLoadECMHook";
    }

    public static final /* synthetic */ boolean $anonfun$beforeLaunch$1(CharSequence x$1) {
        return StringUtils.isNotBlank((CharSequence)x$1);
    }

    public static final /* synthetic */ long $anonfun$beforeLaunch$2(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).toLong();
    }

    public static final /* synthetic */ void $anonfun$beforeLaunch$3(JarUDFLoadECMHook $this, String pubDir$1, HashSet fileNameSet$1, EngineConn conn$1, String udfDir$1, UDFInfoVo udfInfo) {
        String resourceId = udfInfo.getBmlResourceId();
        String version = udfInfo.getBmlResourceVersion();
        String bmlResourceDir = new StringBuilder(0).append(StorageUtils$.MODULE$.FILE_SCHEMA()).append(Paths.get(pubDir$1, resourceId, version).toFile().getPath()).toString();
        FsPath fsPath = new FsPath(bmlResourceDir);
        BmlResource bmlResource = new BmlResource();
        bmlResource.setResourceId(resourceId);
        bmlResource.setVersion(version);
        String fileName = udfInfo.getPath().substring(udfInfo.getPath().lastIndexOf("/") + 1);
        bmlResource.setFileName(fileName);
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (StringUtils.isEmpty((CharSequence)fileName) || fileNameSet$1.contains((Object)fileName)) {
                throw Breaks$.MODULE$.break();
            }
            fileNameSet$1.$plus$eq((Object)bmlResource.getFileName());
            if (!$this.fs().exists(fsPath)) {
                String string = resourceId.intern();
                synchronized (string) {
                    if (!$this.fs().exists(fsPath)) {
                        ECMUtils$.MODULE$.downLoadBmlResourceToLocal(bmlResource, udfInfo.getCreateUser().equals("bdp") ? "hadoop" : udfInfo.getCreateUser(), fsPath.getPath(), $this.fs());
                        $this.logger().info(new StringBuilder(34).append("Finished to download bml resource ").append(fsPath.getPath()).toString());
                    }
                }
            }
            conn$1.getEngineConnLaunchRunner().getEngineConnLaunch().getEngineConnManagerEnv().linkDirs().put((Object)new StringBuilder(0).append(fsPath.getPath()).append(File.separator).append(bmlResource.getFileName()).toString(), (Object)new StringBuilder(0).append(udfDir$1).append(File.separator).append(bmlResource.getFileName()).toString());
        });
    }

    public JarUDFLoadECMHook() {
        Logging.$init$((Logging)this);
        this.localDirsHandleService = new DefaultLocalDirsHandleService();
        this.fs = (FileSystem)FSFactory$.MODULE$.getFs(StorageUtils$.MODULE$.FILE());
        this.fs().init(null);
    }
}

