/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.server.restful;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.common.domain.MetaPartitionInfo;
import org.apache.linkis.metadata.query.common.exception.MetaMethodInvokeException;
import org.apache.linkis.metadata.query.server.service.MetadataQueryService;
import org.apache.linkis.metadata.query.server.utils.MetadataUtils;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metadatamanager"})
@Deprecated
public class MetadataCoreRestful {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataCoreRestful.class);
    @Autowired
    private MetadataQueryService metadataAppService;

    @RequestMapping(value={"/dbs/{dataSourceId}"}, method={RequestMethod.GET})
    public Message getDatabases(@PathVariable(value="dataSourceId") String dataSourceId, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceId).matches()) {
                return Message.error((String)"'dataSourceId' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getDatabases, dataSourceId:" + dataSourceId));
            List<String> databases = this.metadataAppService.getDatabasesByDsId(dataSourceId, system, userName);
            return Message.ok().data("dbs", databases);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get database list[\u83b7\u53d6\u5e93\u4fe1\u606f\u5931\u8d25], id:[" + dataSourceId + "], system:[" + system + "]", e);
        }
    }

    @RequestMapping(value={"/tables/{dataSourceId}/db/{database}"}, method={RequestMethod.GET})
    public Message getTables(@PathVariable(value="dataSourceId") String dataSourceId, @PathVariable(value="database") String database, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u79f0\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceId).matches()) {
                return Message.error((String)"'dataSourceId' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getTables, dataSourceId:" + dataSourceId));
            List<String> tables = this.metadataAppService.getTablesByDsId(dataSourceId, database, system, userName);
            return Message.ok().data("tables", tables);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get table list[\u83b7\u53d6\u8868\u4fe1\u606f\u5931\u8d25], id:[" + dataSourceId + "], system:[" + system + "], database:[" + database + "]", e);
        }
    }

    @RequestMapping(value={"/props/{dataSourceId}/db/{database}/table/{table}"}, method={RequestMethod.GET})
    public Message getTableProps(@PathVariable(value="dataSourceId") String dataSourceId, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceId).matches()) {
                return Message.error((String)"'dataSourceId' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getTableProps, dataSourceId:" + dataSourceId));
            Map<String, String> tableProps = this.metadataAppService.getTablePropsByDsId(dataSourceId, database, table, system, userName);
            return Message.ok().data("props", tableProps);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get table properties[\u83b7\u53d6\u8868\u53c2\u6570\u4fe1\u606f\u5931\u8d25], id:[" + dataSourceId + "], system:[" + system + "], database:[" + database + "], table:[" + table + "]", e);
        }
    }

    @RequestMapping(value={"/partitions/{dataSourceId}/db/{database}/table/{table}"}, method={RequestMethod.GET})
    public Message getPartitions(@PathVariable(value="dataSourceId") String dataSourceId, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestParam(value="system") String system, @RequestParam(name="traverse", required=false, defaultValue="false") Boolean traverse, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceId).matches()) {
                return Message.error((String)"'dataSourceId' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getPartitions, dataSourceId:" + dataSourceId));
            MetaPartitionInfo partitionInfo = this.metadataAppService.getPartitionsByDsId(dataSourceId, database, table, system, traverse, userName);
            return Message.ok().data("partitions", (Object)partitionInfo).data("props", (Object)partitionInfo);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get partitions[\u83b7\u53d6\u8868\u5206\u533a\u4fe1\u606f\u5931\u8d25], id:[" + dataSourceId + "], system:[" + system + "], database:[" + database + "], table:[" + table + "]", e);
        }
    }

    @RequestMapping(value={"/props/{dataSourceId}/db/{database}/table/{table}/partition/{partition}"}, method={RequestMethod.GET})
    public Message getPartitionProps(@PathVariable(value="dataSourceId") String dataSourceId, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @PathVariable(value="partition") String partition, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceId).matches()) {
                return Message.error((String)"'dataSourceId' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(partition).matches()) {
                return Message.error((String)"'partition' is invalid[partition\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getPartitionProps, dataSourceId:" + dataSourceId));
            Map<String, String> partitionProps = this.metadataAppService.getPartitionPropsByDsId(dataSourceId, database, table, partition, system, userName);
            return Message.ok().data("props", partitionProps);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get partition properties[\u83b7\u53d6\u5206\u533a\u53c2\u6570\u4fe1\u606f\u5931\u8d25], id:[" + dataSourceId + "], system:[" + system + "], database:[" + database + "], table:[" + table + "], partition:[" + partition + "]", e);
        }
    }

    @RequestMapping(value={"/columns/{dataSourceId}/db/{database}/table/{table}"}, method={RequestMethod.GET})
    public Message getColumns(@PathVariable(value="dataSourceId") String dataSourceId, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceId).matches()) {
                return Message.error((String)"'dataSourceId' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getColumns, dataSourceId:" + dataSourceId));
            List<MetaColumnInfo> columns = this.metadataAppService.getColumnsByDsId(dataSourceId, database, table, system, userName);
            return Message.ok().data("columns", columns);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get column list[\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25], id:[" + dataSourceId + "], system:[" + system + "], database:[" + database + "], table:[" + table + "]", e);
        }
    }

    private Message errorToResponseMessage(String uiMessage, Exception e) {
        if (e instanceof MetaMethodInvokeException) {
            MetaMethodInvokeException invokeException = (MetaMethodInvokeException)e;
            if (LOG.isDebugEnabled()) {
                String argumentJson = null;
                try {
                    argumentJson = Json.toJson((Object)invokeException.getArgs(), null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOG.trace(uiMessage + " => Method: " + invokeException.getMethod() + ", Arguments:" + argumentJson, (Throwable)e);
            }
            uiMessage = uiMessage + " possible reason[\u53ef\u80fd\u539f\u56e0]: (" + invokeException.getCause().getMessage() + ")";
        } else if (e instanceof ErrorException) {
            uiMessage = uiMessage + " possible reason[\u53ef\u80fd\u539f\u56e0]: (" + e.getMessage() + ")";
        }
        LOG.error(uiMessage, (Throwable)e);
        return Message.error((String)uiMessage);
    }
}

