/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.hadoop.common.conf.HadoopConf;
import org.apache.linkis.metadata.query.common.exception.MetaRuntimeException;
import org.apache.linkis.metadata.query.common.service.AbstractFsMetaService;
import org.apache.linkis.metadata.query.common.service.MetadataConnection;
import org.apache.linkis.metadata.query.service.HdfsConnection;
import org.apache.linkis.metadata.query.service.HdfsParamsMapper;
import org.apache.linkis.metadata.query.service.conf.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsMetaService
extends AbstractFsMetaService<HdfsConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsMetaService.class);
    private static final String PARAM_FILTER_RULE = "filter";
    private static final CommonVars<String> DEFAULT_FILTER_RULES = CommonVars.apply((String)"wds.linkis.server.mdm.service.hadoop.filter.rules", (Object)StringUtils.join((Object[])new String[]{"fs.defaultFS", "dfs.nameservices", "dfs.ha.namenodes.<service>", "dfs.namenode.rpc-address.<suffix>", "dfs.client.failover.proxy.provider.<suffix>"}, (String)","));

    public MetadataConnection<HdfsConnection> getConnection(String creator, Map<String, Object> params) throws Exception {
        Map<String, String> hadoopConf = this.toMap(params, (String)HdfsParamsMapper.PARAM_HADOOP_CONF.getValue());
        if (Objects.nonNull(hadoopConf) && !hadoopConf.isEmpty()) {
            return new MetadataConnection((Object)new HdfsConnection("", creator, hadoopConf, !this.useCache()), true);
        }
        String clusterLabel = (String)Optional.ofNullable(this.toMap(params, "labels")).orElse(Collections.emptyMap()).get(HdfsParamsMapper.PARAM_HADOOP_LABEL_CLUSTER.getValue());
        LOG.info("Use Hadoop root config directory: " + HadoopConf.hadoopConfDir());
        return new MetadataConnection((Object)new HdfsConnection("", creator, clusterLabel, !this.useCache()), true);
    }

    public Map<String, String> queryConnectionInfo(HdfsConnection connection, Map<String, String> queryParams) {
        ArrayList<String> filterRules = new ArrayList<String>();
        AtomicReference uriReference = new AtomicReference();
        LOG.info("query hdfs ConnectionInfo for uri: {}", (Object)queryParams.get("uri"));
        Optional.ofNullable(queryParams.get("uri")).ifPresent(uri -> {
            try {
                uriReference.set(new URI((String)uri));
            }
            catch (URISyntaxException e) {
                LOG.warn("Unrecognized uri value: [" + uri + "]", (Throwable)e);
            }
        });
        Optional.ofNullable(queryParams.get(PARAM_FILTER_RULE)).ifPresent(rules -> {
            if (StringUtils.isNotBlank((CharSequence)rules)) {
                filterRules.addAll(Arrays.asList(rules.split(",")));
            }
        });
        if (filterRules.isEmpty()) {
            filterRules.addAll(Arrays.asList(((String)DEFAULT_FILTER_RULES.getValue()).split(",")));
        }
        return ConfigurationUtils.filterConfiguration(connection.getFileSystem(), filterRules, (URI)uriReference.get());
    }

    private Map<String, String> toMap(Map<String, Object> connectParams, String key) {
        Map<String, String> valueMap = new HashMap<String, String>();
        Object mapObj = connectParams.get(key);
        if (Objects.nonNull(mapObj)) {
            try {
                valueMap = !(mapObj instanceof Map) ? (Map)Json.fromJson((String)String.valueOf(mapObj), Map.class, (Class[])new Class[]{String.class, String.class}) : (Map)mapObj;
            }
            catch (Exception e) {
                throw new MetaRuntimeException("Cannot parse the param:[" + key + "]", null);
            }
        }
        return valueMap;
    }
}

