/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.scheduled;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.linkis.monitor.config.MonitorConfig;
import org.apache.linkis.monitor.constants.Constants;
import org.apache.linkis.monitor.core.pac.DataFetcher;
import org.apache.linkis.monitor.core.scanner.DefaultScanner;
import org.apache.linkis.monitor.factory.MapperFactory;
import org.apache.linkis.monitor.jobhistory.errorcode.JobHistoryErrCodeRule;
import org.apache.linkis.monitor.jobhistory.errorcode.JobHistoryErrorCodeAlertSender;
import org.apache.linkis.monitor.jobhistory.index.JobIndexRule;
import org.apache.linkis.monitor.jobhistory.index.JobIndexSender;
import org.apache.linkis.monitor.jobhistory.jobtime.JobTimeExceedAlertSender;
import org.apache.linkis.monitor.jobhistory.jobtime.JobTimeExceedRule;
import org.apache.linkis.monitor.jobhistory.labels.JobHistoryLabelsAlertSender;
import org.apache.linkis.monitor.jobhistory.labels.JobHistoryLabelsRule;
import org.apache.linkis.monitor.jobhistory.runtime.CommonJobRunTimeRule;
import org.apache.linkis.monitor.jobhistory.runtime.CommonRunTimeAlertSender;
import org.apache.linkis.monitor.jobhistory.runtime.JobHistoryRunTimeAlertSender;
import org.apache.linkis.monitor.jobhistory.runtime.JobHistoryRunTimeRule;
import org.apache.linkis.monitor.until.CacheUtils;
import org.apache.linkis.monitor.until.JobMonitorUtils;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.MonitorAlertUtils;
import org.apache.linkis.monitor.utils.log.LogUtils;
import org.slf4j.Logger;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:linkis-et-monitor.properties"}, encoding="UTF-8")
public class JobHistoryMonitor {
    private static final Logger logger = LogUtils.stdOutLogger();
    private static final long backtrackNum = 1000000L;

    @Scheduled(cron="${linkis.monitor.jobHistory.finished.cron}")
    public void jobHistoryFinishedScan() {
        long id;
        logger.info("Start scan jobHistoryFinishedScan");
        long intervalMs = 1200000L;
        long maxIntervalMs = Constants.ERRORCODE_MAX_INTERVALS_SECONDS() * 1000L;
        long endTime = System.currentTimeMillis();
        long startTime = endTime - intervalMs;
        long realIntervals = Math.min(endTime - startTime, maxIntervalMs);
        DefaultScanner scanner = new DefaultScanner();
        DefaultScanner scannerIndex = new DefaultScanner();
        boolean shouldStart = true;
        if (null == CacheUtils.cacheBuilder.getIfPresent((Object)"jobHistoryId")) {
            long maxId = MapperFactory.getJobHistoryMapper().selectMaxId();
            long beginId = 0L;
            if (maxId > 1000000L) {
                beginId = maxId - 1000000L;
            }
            id = MapperFactory.getJobHistoryMapper().selectIdByHalfDay(beginId);
            logger.info("JobHistoryId is null, scan from the minimum ID:" + id);
            CacheUtils.cacheBuilder.put((Object)"jobHistoryId", (Object)id);
        } else {
            id = (Long)CacheUtils.cacheBuilder.getIfPresent((Object)"jobHistoryId");
            logger.info("Get JobHistoryId from cache ID:" + id);
        }
        List<DataFetcher> fetchers = JobMonitorUtils.generateFetchersfortime(startTime, endTime, id, "updated_time");
        if (fetchers.isEmpty()) {
            logger.warn("generated 0 dataFetchers, plz check input");
            return;
        }
        try {
            Map<String, AlertDesc> errorCodeAlerts = MonitorAlertUtils.getAlerts(Constants.SCAN_PREFIX_ERRORCODE(), null);
            if (errorCodeAlerts == null || errorCodeAlerts.size() == 0) {
                logger.info("JobHistoryErrCodeRule Alert error,Please check the linkis-et-monitor-ims.properties file");
            } else {
                logger.info("JobHistoryErrCodeRule Alert load {} success", (Object)errorCodeAlerts.size());
                JobMonitorUtils.addIntervalToImsAlerts(errorCodeAlerts, realIntervals);
                JobHistoryErrCodeRule jobHistoryErrCodeRule = new JobHistoryErrCodeRule(errorCodeAlerts.keySet(), new JobHistoryErrorCodeAlertSender(errorCodeAlerts));
                scanner.addScanRule(jobHistoryErrCodeRule);
            }
        }
        catch (Exception e) {
            logger.warn("JobHistoryErrCodeRule Scan Error msg: " + e.getMessage());
        }
        try {
            Map<String, AlertDesc> userLabelAlerts = MonitorAlertUtils.getAlerts(Constants.USER_LABEL_MONITOR(), null);
            if (userLabelAlerts == null || userLabelAlerts.size() == 0) {
                logger.info("JobHistoryLabelsRule Alert error,Please check the linkis-et-monitor-ims.properties file");
            } else {
                logger.info("JobHistoryLabelsRule Alert load {} success", (Object)userLabelAlerts.size());
                JobHistoryLabelsRule jobHistoryLabelsRule = new JobHistoryLabelsRule(new JobHistoryLabelsAlertSender());
                scanner.addScanRule(jobHistoryLabelsRule);
            }
        }
        catch (Exception e) {
            logger.warn("JobHistoryLabelsRule Scan Error msg: " + e.getMessage());
        }
        try {
            Map<String, AlertDesc> jobResultAlerts = MonitorAlertUtils.getAlerts(Constants.SCAN_PREFIX_ERRORCODE(), null);
            if (jobResultAlerts == null || jobResultAlerts.size() == 0) {
                logger.info("JobHistoryRunTimeRule Alert error,Please check the linkis-et-monitor-ims.properties file");
            } else {
                logger.info("JobHistoryRunTimeRule Alert load {} success", (Object)jobResultAlerts.size());
                JobHistoryRunTimeRule jobHistoryRunTimeRule = new JobHistoryRunTimeRule(new JobHistoryRunTimeAlertSender());
                scanner.addScanRule(jobHistoryRunTimeRule);
            }
        }
        catch (Exception e) {
            logger.warn("JobHistoryRunTimeRule Scan Error msg: " + e.getMessage());
        }
        try {
            Map<String, AlertDesc> dssJobResultAlerts = MonitorAlertUtils.getAlerts(Constants.SCAN_PREFIX_ERRORCODE(), null);
            if (dssJobResultAlerts == null || dssJobResultAlerts.size() == 0) {
                logger.info("CommonJobRunTimeRule Alert error,Please check the linkis-et-monitor-ims.properties file");
            } else {
                logger.info("CommonJobRunTimeRule Alert load {} success", (Object)dssJobResultAlerts.size());
                CommonJobRunTimeRule commonJobRunTimeRule = new CommonJobRunTimeRule(new CommonRunTimeAlertSender());
                scanner.addScanRule(commonJobRunTimeRule);
            }
        }
        catch (Exception e) {
            logger.warn("CommonJobRunTimeRule Scan Error msg: " + e.getMessage());
        }
        JobMonitorUtils.run(scanner, fetchers, true);
        JobIndexRule jobIndexRule = new JobIndexRule(new JobIndexSender());
        scannerIndex.addScanRule(jobIndexRule);
        List<DataFetcher> createFetcher = JobMonitorUtils.generateFetchersfortime(startTime, endTime, id, "department");
        JobMonitorUtils.run(scannerIndex, createFetcher, true);
    }

    @Scheduled(cron="${linkis.monitor.jobHistory.timeout.cron}")
    public void jobHistoryUnfinishedScan() {
        long id = (Long)Optional.ofNullable(CacheUtils.cacheBuilder.getIfPresent((Object)"jobhistoryScan")).orElse(MonitorConfig.JOB_HISTORY_TIME_EXCEED.getValue());
        long intervalMs = Constants.TIMEOUT_INTERVALS_SECONDS() * 1000L;
        long maxIntervalMs = Constants.ERRORCODE_MAX_INTERVALS_SECONDS() * 1000L;
        long endTime = System.currentTimeMillis();
        long startTime = endTime - intervalMs;
        long realIntervals = Math.min(endTime - startTime, maxIntervalMs);
        DefaultScanner scanner = new DefaultScanner();
        boolean shouldStart = false;
        List<DataFetcher> fetchers = JobMonitorUtils.generateFetchers(startTime, endTime, maxIntervalMs, id, "created_time");
        if (fetchers.isEmpty()) {
            logger.warn("generated 0 dataFetchers, plz check input");
            return;
        }
        Map<String, AlertDesc> jobTimeAlerts = MonitorAlertUtils.getAlerts(Constants.SCAN_PREFIX_UNFINISHED_JOBTIME_EXCEED_SEC(), null);
        if (jobTimeAlerts == null || jobTimeAlerts.size() == 0) {
            logger.info("[INFO] Loaded 0 alerts jobtime alert-rule from alert properties file.");
        } else {
            logger.info("[INFO] Loaded {} alerts jobtime alert-rules from alert properties file.", (Object)jobTimeAlerts.size());
            shouldStart = true;
            JobMonitorUtils.addIntervalToImsAlerts(jobTimeAlerts, realIntervals);
            JobTimeExceedRule jobTimeExceedRule = new JobTimeExceedRule(jobTimeAlerts.keySet(), new JobTimeExceedAlertSender(jobTimeAlerts));
            scanner.addScanRule(jobTimeExceedRule);
        }
        JobMonitorUtils.run(scanner, fetchers, shouldStart);
    }
}

