/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.jobhistory.runtime;

import java.io.Serializable;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.monitor.constants.Constants$;
import org.apache.linkis.monitor.core.ob.Event;
import org.apache.linkis.monitor.core.ob.Observer;
import org.apache.linkis.monitor.jobhistory.entity.JobHistory;
import org.apache.linkis.monitor.jobhistory.exception.AnomalyScannerException;
import org.apache.linkis.monitor.jobhistory.runtime.JobHistoryRunTimeHitEvent;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.MonitorAlertUtils$;
import org.apache.linkis.monitor.utils.alert.ims.PooledImsAlertUtils$;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0002\u0004\u0001'!)!\u0006\u0001C\u0001W!9a\u0006\u0001b\u0001\n\u0013y\u0003B\u0002\u001d\u0001A\u0003%\u0001\u0007C\u0003:\u0001\u0011\u0005#H\u0001\rD_6lwN\u001c*v]RKW.Z!mKJ$8+\u001a8eKJT!a\u0002\u0005\u0002\u000fI,h\u000e^5nK*\u0011\u0011BC\u0001\u000bU>\u0014\u0007.[:u_JL(BA\u0006\r\u0003\u001diwN\\5u_JT!!\u0004\b\u0002\r1Lgn[5t\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0006\u000e#!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0003_\nT!a\b\u0006\u0002\t\r|'/Z\u0005\u0003Cq\u0011\u0001b\u00142tKJ4XM\u001d\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nQ!\u001e;jYNT!a\n\u0007\u0002\r\r|W.\\8o\u0013\tICEA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005a\u0003CA\u0017\u0001\u001b\u00051\u0011A\u00033bi\u00164uN]7biV\t\u0001\u0007\u0005\u00022m5\t!G\u0003\u00024i\u0005!A/\u001a=u\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003!MKW\u000e\u001d7f\t\u0006$XMR8s[\u0006$\u0018a\u00033bi\u00164uN]7bi\u0002\na!\u001e9eCR,GcA\u001e?\u0007B\u0011Q\u0003P\u0005\u0003{Y\u0011A!\u00168ji\")q\b\u0002a\u0001\u0001\u0006\tQ\r\u0005\u0002\u001c\u0003&\u0011!\t\b\u0002\u0006\u000bZ,g\u000e\u001e\u0005\u0006\t\u0012\u0001\r!R\u0001\u000fU>\u0014\u0007*[:u_JLH*[:u!\t)b)\u0003\u0002H-\t\u0019\u0011I\\=")
public class CommonRunTimeAlertSender
implements Observer,
Logging {
    private final SimpleDateFormat dateFormat;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        CommonRunTimeAlertSender commonRunTimeAlertSender = this;
        synchronized (commonRunTimeAlertSender) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    @Override
    public void update(Event e, Object jobHistoryList) {
        if (!(e instanceof JobHistoryRunTimeHitEvent)) {
            throw new AnomalyScannerException(21304, new StringBuilder(74).append("Wrong event that triggers JobHistoryErrorCodeAlertSender. Input DataType: ").append(e.getClass().getCanonicalName()).toString());
        }
        if (!(jobHistoryList instanceof List) || jobHistoryList == null) {
            throw new AnomalyScannerException(21304, new StringBuilder(64).append("Wrong input for JobHistoryErrorCodeAlertSender. Input DataType: ").append(jobHistoryList.getClass().getCanonicalName()).toString());
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)jobHistoryList).asScala()).foreach((Function1 & Serializable & scala.Serializable)a -> {
            CommonRunTimeAlertSender.$anonfun$update$1(this, a);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(CommonRunTimeAlertSender $this, Object a) {
        if (a == null) {
            $this.logger().warn("Ignore null input data");
            return;
        }
        if (!(a instanceof JobHistory)) {
            $this.logger().warn(new StringBuilder(31).append("Ignore wrong input data Type : ").append(a.getClass().getCanonicalName()).toString());
            return;
        }
        JobHistory jobHistory = (JobHistory)a;
        Map observeInfoMap = (Map)BDPJettyServerHelper$.MODULE$.gson().fromJson(jobHistory.getObserveInfo(), Map.class);
        Map extraMap = MapUtils.getMap((Map)observeInfoMap, (Object)"extra");
        observeInfoMap.put("title", new StringBuilder(13).append(extraMap.get("title").toString()).append(",\u4efb\u52a1id\uff1a").append(jobHistory.getId()).append(",\u6267\u884c\u7ed3\u679c :").append(jobHistory.getStatus()).toString());
        observeInfoMap.put("$detail", new StringBuilder(7).append(extraMap.get("detail").toString()).append(",\u6267\u884c\u7ed3\u679c :").append(jobHistory.getStatus()).toString());
        observeInfoMap.put("$submitUser", jobHistory.getSubmitUser());
        observeInfoMap.put("$status", jobHistory.getStatus());
        observeInfoMap.put("$id", jobHistory.getId().toString());
        observeInfoMap.put("$date", $this.dateFormat().format(new Date()));
        String alterSysInfo = "";
        if (extraMap.get("alterSysInfo") != null) {
            alterSysInfo = extraMap.get("alterSysInfo").toString();
        }
        observeInfoMap.put("$sysid", alterSysInfo);
        String alterObject = "";
        if (extraMap.get("alterObject") != null) {
            alterObject = extraMap.get("alterObject").toString();
        }
        observeInfoMap.put("$object", alterObject);
        observeInfoMap.put("$ip", InetAddress.getLocalHost().getHostAddress());
        observeInfoMap.remove("taskId");
        observeInfoMap.remove("extra");
        Map<String, AlertDesc> alters = MonitorAlertUtils$.MODULE$.getAlerts(Constants$.MODULE$.JOB_RESULT_IM(), observeInfoMap);
        PooledImsAlertUtils$.MODULE$.addAlert(alters.get("12016"));
    }

    public CommonRunTimeAlertSender() {
        Logging.$init$((Logging)this);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

