/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.upstream.handler;

import java.io.Serializable;
import java.util.List;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.upstream.handler.ECTaskKillHandlerRequest;
import org.apache.linkis.engineconn.computation.executor.upstream.handler.MonitorHandler;
import org.apache.linkis.engineconn.computation.executor.upstream.handler.MonitorHandlerRequest;
import org.apache.linkis.engineconn.computation.executor.upstream.wrapper.ConnectionInfoWrapper;
import org.apache.linkis.engineconn.computation.executor.upstream.wrapper.ECTaskEntranceConnectionWrapper;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.entrance.ExecuteOnceLabel;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}2A\u0001B\u0003\u0001-!)\u0011\u0006\u0001C\u0001U!)A\u0006\u0001C![!)a\u0007\u0001C\u0005o\t\tRi\u0011+bg.\\\u0015\u000e\u001c7IC:$G.\u001a:\u000b\u0005\u00199\u0011a\u00025b]\u0012dWM\u001d\u0006\u0003\u0011%\t\u0001\"\u001e9tiJ,\u0017-\u001c\u0006\u0003\u0015-\t\u0001\"\u001a=fGV$xN\u001d\u0006\u0003\u00195\t1bY8naV$\u0018\r^5p]*\u0011abD\u0001\u000bK:<\u0017N\\3d_:t'B\u0001\t\u0012\u0003\u0019a\u0017N\\6jg*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019B\u0001A\f\u001eCA\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0010\u000e\u0003\u0015I!\u0001I\u0003\u0003\u001d5{g.\u001b;pe\"\u000bg\u000e\u001a7feB\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0006kRLGn\u001d\u0006\u0003M=\taaY8n[>t\u0017B\u0001\u0015$\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0016\u0011\u0005y\u0001\u0011A\u00025b]\u0012dW\r\u0006\u0002/cA\u0011\u0001dL\u0005\u0003ae\u0011A!\u00168ji\")!G\u0001a\u0001g\u00059!/Z9vKN$\bC\u0001\u00105\u0013\t)TAA\u000bN_:LGo\u001c:IC:$G.\u001a:SKF,Xm\u001d;\u0002\r\u0011|7*\u001b7m)\tq\u0003\bC\u0003:\u0007\u0001\u0007!(A\u0004xe\u0006\u0004\b/\u001a:\u0011\u0005mjT\"\u0001\u001f\u000b\u0005e:\u0011B\u0001 =\u0005U\u0019uN\u001c8fGRLwN\\%oM><&/\u00199qKJ\u0004")
public class ECTaskKillHandler
implements MonitorHandler,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ECTaskKillHandler eCTaskKillHandler = this;
        synchronized (eCTaskKillHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public void handle(MonitorHandlerRequest request) {
        if (request == null) {
            this.logger().error("illegal input for handler: null");
            return;
        }
        MonitorHandlerRequest monitorHandlerRequest = request;
        if (monitorHandlerRequest instanceof ECTaskKillHandlerRequest) {
            List<ConnectionInfoWrapper> toBeKilled = ((ECTaskKillHandlerRequest)request).getData();
            if (toBeKilled != null && toBeKilled.size() != 0) {
                for (ConnectionInfoWrapper element : toBeKilled) {
                    Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        this.logger().error(new StringBuilder(49).append("ERROR: entrance : ").append(element.getUpstreamConnection().getUpstreamServiceInstanceName()).append(" lose connect, will kill job : ").append(element.getKey()).toString());
                        this.doKill(element);
                    }, (Function1 & Serializable & scala.Serializable)t -> {
                        ECTaskKillHandler.$anonfun$handle$2(this, element, t);
                        return BoxedUnit.UNIT;
                    });
                }
                return;
            }
            return;
        }
        this.logger().error(new StringBuilder(27).append("illegal input for handler: ").append(request.getClass().getCanonicalName()).toString());
    }

    private void doKill(ConnectionInfoWrapper wrapper) {
        if (wrapper != null) {
            ConnectionInfoWrapper connectionInfoWrapper = wrapper;
            if (connectionInfoWrapper instanceof ECTaskEntranceConnectionWrapper) {
                ECTaskEntranceConnectionWrapper eCTaskEntranceConnectionWrapper = (ECTaskEntranceConnectionWrapper)connectionInfoWrapper;
                if (eCTaskEntranceConnectionWrapper.getExecutor() == null || eCTaskEntranceConnectionWrapper.getEngineConnTask() == null) {
                    this.logger().error("Failed to kill job, executor or engineConnTask in wrapper is null");
                    return;
                }
                eCTaskEntranceConnectionWrapper.getExecutor().killTask(eCTaskEntranceConnectionWrapper.getEngineConnTask().getTaskId());
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])eCTaskEntranceConnectionWrapper.getEngineConnTask().getLables())).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ECTaskKillHandler.$anonfun$doKill$1(x$1)))) {
                    this.logger().warn("upstream monitor tries to shutdown engineConn because executeOnce-label was found");
                    ExecutorManager$.MODULE$.getInstance().getReportExecutor().tryShutdown();
                    return;
                }
                return;
            }
            this.logger().error(new StringBuilder(19).append("invalid data-type: ").append(wrapper.getClass().getCanonicalName()).toString());
            return;
        }
        this.logger().error("wrapper is null");
    }

    public static final /* synthetic */ void $anonfun$handle$2(ECTaskKillHandler $this, ConnectionInfoWrapper element$1, Throwable t) {
        $this.logger().error(new StringBuilder(20).append("Failed to kill job: ").append(element$1.getKey()).toString(), t);
    }

    public static final /* synthetic */ boolean $anonfun$doKill$1(Label x$1) {
        return x$1 instanceof ExecuteOnceLabel;
    }

    public ECTaskKillHandler() {
        Logging.$init$((Logging)this);
    }
}

