/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.metadata.query.common.cache.CacheConfiguration;
import org.apache.linkis.metadata.query.common.cache.CacheManager;

public class ConnCacheManager
implements CacheManager {
    private ConcurrentHashMap<String, Cache> cacheStore = new ConcurrentHashMap();
    private static CacheManager manager;

    private ConnCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheManager custom() {
        if (null != manager) return manager;
        Class<ConnCacheManager> clazz = ConnCacheManager.class;
        synchronized (ConnCacheManager.class) {
            if (null != manager) return manager;
            manager = new ConnCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    @Override
    public <V> Cache<String, V> buildCache(String cacheId, RemovalListener<String, V> removalListener) {
        return this.cacheStore.computeIfAbsent(cacheId, id -> CacheBuilder.newBuilder().maximumSize(((Long)CacheConfiguration.CACHE_MAX_SIZE.getValue()).longValue()).expireAfterWrite(((Long)CacheConfiguration.CACHE_EXPIRE_TIME.getValue()).longValue(), TimeUnit.SECONDS).removalListener(removalListener).build());
    }

    @Override
    public <V> LoadingCache<String, V> buildCache(String cacheId, CacheLoader<String, V> loader, RemovalListener<String, V> removalListener) {
        return (LoadingCache)this.cacheStore.computeIfAbsent(cacheId, id -> CacheBuilder.newBuilder().maximumSize(((Long)CacheConfiguration.CACHE_MAX_SIZE.getValue()).longValue()).expireAfterWrite(((Long)CacheConfiguration.CACHE_EXPIRE_TIME.getValue()).longValue(), TimeUnit.SECONDS).removalListener(removalListener).build(loader));
    }
}

