/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.spi;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;

public class InvalidSubscriberException
extends Exception {
    private static final long serialVersionUID = 4258884942423525335L;
    private Class<?> subscriberClass;
    private Set<Method> offendingMethods;

    public InvalidSubscriberException(Class<?> subscriberClass, Map<Method, String> errors) {
        super(InvalidSubscriberException.getErrorMessage(subscriberClass, errors));
        this.subscriberClass = subscriberClass;
        this.offendingMethods = errors.keySet();
    }

    public Set<Method> getOffendingMethods() {
        return this.offendingMethods;
    }

    public Class<?> getSubscriberClass() {
        return this.subscriberClass;
    }

    private static String getErrorMessage(Class<?> subscriberClass, Map<Method, String> errors) {
        StringBuilder errMsgBuilder = new StringBuilder();
        errMsgBuilder.append("Invalid subscriber class: ");
        errMsgBuilder.append(subscriberClass);
        errMsgBuilder.append(". Errors: \n");
        for (Map.Entry<Method, String> anEntry : errors.entrySet()) {
            errMsgBuilder.append("Method: ");
            errMsgBuilder.append(anEntry.getKey().toGenericString());
            errMsgBuilder.append(" is invalid. Error: ");
            errMsgBuilder.append(anEntry.getValue());
            errMsgBuilder.append("\n");
        }
        return errMsgBuilder.toString();
    }
}

