/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.impl;

import com.netflix.eventbus.utils.EventBusUtils;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicGauge;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StatsTimer;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConsumerStats {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventConsumerStats.class);
    final StatsTimer enqueueStats;
    final StatsTimer consumptionStats;
    final StatsTimer filterStats;
    final AtomicLong QUEUE_SIZE_COUNTER;
    final BasicGauge<Long> QUEUE_SIZE_GAUGE;
    final Counter QUEUE_OFFER_RETRY_COUNTER;
    final Counter EVENT_ENQUEUE_REJECTED_COUNTER;

    public EventConsumerStats(String consumerName, long collectionDurationInMillis) {
        String statsPrefix = "eventbus_consumer_" + consumerName;
        this.QUEUE_SIZE_COUNTER = new AtomicLong();
        this.QUEUE_SIZE_GAUGE = new BasicGauge(MonitorConfig.builder((String)(statsPrefix + "_queue_size")).build(), (Callable)new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return EventConsumerStats.this.QUEUE_SIZE_COUNTER.get();
            }
        });
        this.QUEUE_OFFER_RETRY_COUNTER = new BasicCounter(MonitorConfig.builder((String)(statsPrefix + "_queue_retry")).build());
        this.EVENT_ENQUEUE_REJECTED_COUNTER = new BasicCounter(MonitorConfig.builder((String)(statsPrefix + "_enqueue_reject")).build());
        this.enqueueStats = EventBusUtils.newStatsTimer(statsPrefix + "_enqueue", collectionDurationInMillis);
        this.consumptionStats = EventBusUtils.newStatsTimer(statsPrefix + "_consumption", collectionDurationInMillis);
        this.filterStats = EventBusUtils.newStatsTimer(statsPrefix + "_filter", collectionDurationInMillis);
        try {
            DefaultMonitorRegistry.getInstance().register(this.QUEUE_SIZE_GAUGE);
            DefaultMonitorRegistry.getInstance().register((Monitor)this.QUEUE_OFFER_RETRY_COUNTER);
            DefaultMonitorRegistry.getInstance().register((Monitor)this.EVENT_ENQUEUE_REJECTED_COUNTER);
            DefaultMonitorRegistry.getInstance().register((Monitor)this.enqueueStats);
            DefaultMonitorRegistry.getInstance().register((Monitor)this.consumptionStats);
            DefaultMonitorRegistry.getInstance().register((Monitor)this.filterStats);
        }
        catch (Throwable th) {
            LOGGER.error("Unable to register to event bus consumer stats to servo.", th);
        }
    }
}

