/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.entity.cluster;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.label.entity.EMNodeLabel;
import org.apache.linkis.manager.label.entity.EngineNodeLabel;
import org.apache.linkis.manager.label.entity.Feature;
import org.apache.linkis.manager.label.entity.GenericLabel;
import org.apache.linkis.manager.label.entity.UserModifiable;
import org.apache.linkis.manager.label.entity.annon.ValueSerialNum;
import org.apache.linkis.manager.label.errorcode.LabelCommonErrorCodeSummary;
import org.apache.linkis.manager.label.exception.LabelErrorException;

public class ClusterLabel
extends GenericLabel
implements EMNodeLabel,
EngineNodeLabel,
UserModifiable {
    public ClusterLabel() {
        this.setLabelKey("yarnCluster");
    }

    @Override
    public Feature getFeature() {
        return Feature.CORE;
    }

    @ValueSerialNum(value=1)
    public void setClusterName(String clusterName) {
        if (null == this.getValue()) {
            this.setValue((Map<String, String>)new HashMap<String, String>());
        }
        ((Map)this.getValue()).put("clusterName", clusterName);
    }

    public String getClusterName() {
        if (null != ((Map)this.getValue()).get("clusterName")) {
            return (String)((Map)this.getValue()).get("clusterName");
        }
        return null;
    }

    @ValueSerialNum(value=0)
    public void setClusterType(String clusterType) {
        if (null == this.getValue()) {
            this.setValue((Map<String, String>)new HashMap<String, String>());
        }
        ((Map)this.getValue()).put("clusterType", clusterType);
    }

    public String getClusterType() {
        if (null != ((Map)this.getValue()).get("clusterType")) {
            return (String)((Map)this.getValue()).get("clusterType");
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ClusterLabel) {
            if (null != this.getClusterName() && null != this.getClusterType()) {
                return this.getClusterName().equals(((ClusterLabel)other).getClusterName()) && this.getClusterType().equals(((ClusterLabel)other).getClusterType());
            }
            return false;
        }
        return false;
    }

    @Override
    public void valueCheck(String stringValue) throws LabelErrorException {
        if (!StringUtils.isEmpty((CharSequence)stringValue) && stringValue.split("-").length != 2) {
            throw new LabelErrorException(LabelCommonErrorCodeSummary.CLUSTER_LABEL_VALUE_ERROR.getErrorCode(), LabelCommonErrorCodeSummary.CLUSTER_LABEL_VALUE_ERROR.getErrorDesc());
        }
    }
}

