/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.builder;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.linkis.manager.label.builder.LabelBuilder;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.CombinedLabelImpl;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.errorcode.LabelCommonErrorCodeSummary;
import org.apache.linkis.manager.label.exception.LabelErrorException;

public class CombinedLabelBuilder
implements LabelBuilder {
    private static LabelBuilderFactory labelFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();

    @Override
    public boolean canBuild(String labelKey) {
        return labelKey.startsWith("combined_");
    }

    @Override
    public Label<?> build(String labelKey, @Nullable Object valueObj) throws LabelErrorException {
        if (null != valueObj || valueObj instanceof List) {
            try {
                List labels = (List)valueObj;
                return new CombinedLabelImpl(labels);
            }
            catch (Throwable e) {
                throw new LabelErrorException(LabelCommonErrorCodeSummary.FAILED_BUILD_COMBINEDLABEL.getErrorCode(), LabelCommonErrorCodeSummary.FAILED_BUILD_COMBINEDLABEL.getErrorDesc(), e);
            }
        }
        return null;
    }

    public Label<?> buildFromStringValue(String labelKey, String stringValue) throws LabelErrorException {
        String[] keyList = labelKey.replace("combined_", "").split("_");
        String[] valueList = stringValue.split(",");
        ArrayList labels = new ArrayList();
        for (int i = 0; i < keyList.length; ++i) {
            Object label = labelFactory.createLabel(keyList[i], valueList[i]);
            labels.add(label);
        }
        Label<?> newLabel = this.build(labelKey, labels);
        return newLabel;
    }
}

