/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.operator.once;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.context.CliCtx;
import org.apache.linkis.cli.application.entity.operator.JobOper;
import org.apache.linkis.cli.application.interactor.job.common.KeyParser;
import org.apache.linkis.cli.application.operator.JobOperBuilder;
import org.apache.linkis.cli.application.operator.once.OnceJobDesc;
import org.apache.linkis.cli.application.operator.once.OnceJobOper;
import org.apache.linkis.cli.application.utils.CliUtils;

public class OnceOperBuilder
implements JobOperBuilder {
    @Override
    public JobOper build(CliCtx ctx) {
        OnceJobDesc desc = new OnceJobDesc();
        Map<String, Object> confMap = ctx.getVarAccess().getVar(Map.class, "wds.linkis.client.param.conf");
        Map<String, Object> runtimeMap = ctx.getVarAccess().getVar(Map.class, "wds.linkis.client.param.runtime");
        Map varMap = ctx.getVarAccess().getVar(Map.class, "wds.linkis.client.param.var");
        Map<String, Object> labelMap = ctx.getVarAccess().getVar(Map.class, "wds.linkis.client.label");
        Map<String, Object> sourceMap = ctx.getVarAccess().getVar(Map.class, "wds.linkis.client.source");
        Map<String, Object> executionMap = ctx.getVarAccess().getVar(Map.class, "wds.linkis.client.exec");
        Map<String, Object> jobContentMap = ctx.getVarAccess().getVar(Map.class, "wds.linkis.client.jobContent");
        confMap = confMap == null ? new HashMap() : confMap;
        runtimeMap = runtimeMap == null ? new HashMap() : runtimeMap;
        varMap = varMap == null ? new HashMap() : varMap;
        labelMap = labelMap == null ? new HashMap() : labelMap;
        sourceMap = sourceMap == null ? new HashMap() : sourceMap;
        executionMap = executionMap == null ? new HashMap() : executionMap;
        jobContentMap = jobContentMap == null ? new HashMap() : jobContentMap;
        confMap = KeyParser.removePrefixForKeysInMap(confMap);
        runtimeMap = KeyParser.removePrefixForKeysInMap(runtimeMap);
        labelMap = KeyParser.removePrefixForKeysInMap(labelMap);
        sourceMap = KeyParser.removePrefixForKeysInMap(sourceMap);
        executionMap = KeyParser.removePrefixForKeysInMap(executionMap);
        jobContentMap = KeyParser.removePrefixForKeysInMap(jobContentMap);
        for (String key : ctx.getVarAccess().getAllVarKeys()) {
            Object val = ctx.getVarAccess().getVar(Object.class, key);
            if (val instanceof Map || val == null) continue;
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.param.conf")) {
                KeyParser.removePrefixAndPutValToMap(confMap, key, val, "wds.linkis.client.param.conf");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.param.var")) {
                KeyParser.removePrefixAndPutValToMap(varMap, key, val, "wds.linkis.client.param.var");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.param.runtime")) {
                KeyParser.removePrefixAndPutValToMap(runtimeMap, key, val, "wds.linkis.client.param.runtime");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.exec")) {
                KeyParser.removePrefixAndPutValToMap(executionMap, key, val, "wds.linkis.client.exec");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.label")) {
                KeyParser.removePrefixAndPutValToMap(labelMap, key, val, "wds.linkis.client.label");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.source")) {
                KeyParser.removePrefixAndPutValToMap(sourceMap, key, val, "wds.linkis.client.source");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.jobContent")) {
                KeyParser.removePrefixAndPutValToMap(jobContentMap, key, val, "wds.linkis.client.jobContent");
                continue;
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)"wds.linkis.client.common")) continue;
        }
        Boolean isAsync = ctx.getVarAccess().getVarOrDefault(Boolean.class, "wds.linkis.client.common.async.submit", false);
        String creator = isAsync == false ? ctx.getVarAccess().getVarOrDefault(String.class, "wds.linkis.client.common.creator", "LINKISCLI") : ctx.getVarAccess().getVarOrDefault(String.class, "wds.linkis.client.common.creator", "LINKISCLIASYNC");
        String code = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.exec.code");
        String engineType = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.label.engineType");
        String runType = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.label.codeType");
        String scriptPath = ctx.getVarAccess().getVarOrDefault(String.class, "wds.linkis.client.source.scriptPath", "LinkisCli");
        String osUser = System.getProperty("user.name");
        String[] adminUsers = StringUtils.split((String)"hadoop,root,shangda", (char)',');
        HashSet<String> adminSet = new HashSet<String>();
        for (String admin : adminUsers) {
            adminSet.add(admin);
        }
        String submitUsr = CliUtils.getSubmitUser(ctx.getVarAccess(), osUser, adminSet);
        String proxyUsr = CliUtils.getProxyUser(ctx.getVarAccess(), submitUsr, adminSet);
        String enableExecuteOnce = ctx.getVarAccess().getVarOrDefault(String.class, "wds.linkis.client.label.executeOnce", "true");
        if (Boolean.parseBoolean(enableExecuteOnce)) {
            labelMap.put("executeOnce", "");
        } else {
            labelMap.remove("executeOnce");
        }
        String codePath = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.code.path");
        Object extraArgsObj = ctx.getVarAccess().getVar(Object.class, "wds.linkis.client.common.extraArguments");
        if (extraArgsObj != null && extraArgsObj instanceof String[] && StringUtils.isBlank((CharSequence)code) && StringUtils.isBlank((CharSequence)codePath)) {
            String[] extraArgs = (String[])extraArgsObj;
            codePath = extraArgs[0];
            if (extraArgs.length > 1) {
                runtimeMap.put("extraArguments", Arrays.copyOfRange(extraArgs, 1, extraArgs.length));
            }
        }
        if (StringUtils.isBlank((CharSequence)code) && StringUtils.isNotBlank((CharSequence)codePath)) {
            code = CliUtils.readFile(codePath);
        }
        executionMap.put("code", code);
        labelMap.put("engineType", engineType);
        labelMap.put("codeType", runType);
        labelMap.put("userCreator", proxyUsr + "-" + creator);
        sourceMap.put("scriptPath", scriptPath);
        runtimeMap.put("hive.resultset.use.unique.column.names", true);
        desc.setVarAccess(ctx.getVarAccess());
        desc.setCreator(creator);
        desc.setParamConfMap(confMap);
        desc.setParamRunTimeMap(runtimeMap);
        desc.setParamVarsMap(varMap);
        desc.setLabelMap(labelMap);
        desc.setSourceMap(sourceMap);
        desc.setExecutionMap(executionMap);
        desc.setSubmitUser(submitUsr);
        desc.setProxyUser(proxyUsr);
        desc.setJobContentMap(jobContentMap);
        OnceJobOper onceJobOper = new OnceJobOper();
        onceJobOper.init(desc);
        return onceJobOper;
    }
}

