/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.validate;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.ValidateException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.operator.once.OnceJobDesc;

public class OnceDescValidator {
    public void doValidation(OnceJobDesc desc) throws LinkisClientRuntimeException {
        Object val;
        boolean ok = true;
        StringBuilder reasonSb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)desc.getSubmitUser())) {
            reasonSb.append("Submit User cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)desc.getProxyUser())) {
            reasonSb.append("proxy(execute) User cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (desc.getLabelMap() == null) {
            reasonSb.append("labelMap cannot be null").append(System.lineSeparator());
            ok = false;
        }
        if (desc.getExecutionMap() == null) {
            reasonSb.append("ExecutionMap cannot be null").append(System.lineSeparator());
            ok = false;
        }
        if (desc.getSourceMap() == null) {
            reasonSb.append("SourceMap cannot be null").append(System.lineSeparator());
            ok = false;
        }
        if (desc.getParamConfMap() == null) {
            reasonSb.append("startupMap cannot be null").append(System.lineSeparator());
            ok = false;
        }
        if (desc.getParamVarsMap() == null) {
            reasonSb.append("variableMap cannot be null").append(System.lineSeparator());
            ok = false;
        }
        if (desc.getParamRunTimeMap() == null) {
            reasonSb.append("runTimeMap cannot be null").append(System.lineSeparator());
            ok = false;
        }
        if (desc.getJobContentMap() == null) {
            reasonSb.append("jobContentMap cannot be null").append(System.lineSeparator());
            ok = false;
        }
        for (Map.Entry<String, Object> entry : desc.getExecutionMap().entrySet()) {
            if (!StringUtils.contains((CharSequence)entry.getKey(), (CharSequence)" ")) continue;
            reasonSb.append("ExecutionMap key cannot contains space character. key: ").append(entry.getKey()).append(System.lineSeparator());
            ok = false;
        }
        for (Map.Entry<String, Object> entry : desc.getLabelMap().entrySet()) {
            if (StringUtils.contains((CharSequence)entry.getKey(), (CharSequence)" ")) {
                reasonSb.append("LabelMap key cannot contains space character. key: ").append(entry.getKey()).append(System.lineSeparator());
                ok = false;
            }
            if (!((val = entry.getValue()) instanceof String) || !StringUtils.contains((CharSequence)((String)val), (CharSequence)" ")) continue;
            reasonSb.append("LabelMap value cannot contains space character. key: ").append(entry.getKey()).append("value: ").append(val).append(System.lineSeparator());
            ok = false;
        }
        for (Map.Entry<String, Object> entry : desc.getParamConfMap().entrySet()) {
            if (!StringUtils.contains((CharSequence)entry.getKey(), (CharSequence)" ")) continue;
            reasonSb.append("startUpMap key cannot contains space character. key: ").append(entry.getKey()).append(System.lineSeparator());
            ok = false;
        }
        for (Map.Entry<String, Object> entry : desc.getParamVarsMap().entrySet()) {
            if (StringUtils.contains((CharSequence)entry.getKey(), (CharSequence)" ")) {
                reasonSb.append("variablesMap key cannot contains space character. key: ").append(entry.getKey()).append(System.lineSeparator());
                ok = false;
            }
            val = entry.getValue();
        }
        for (Map.Entry<String, Object> entry : desc.getSourceMap().entrySet()) {
            if (StringUtils.contains((CharSequence)entry.getKey(), (CharSequence)" ")) {
                reasonSb.append("sourceMap key cannot contains space character. key: ").append(entry.getKey()).append(System.lineSeparator());
                ok = false;
            }
            if (!((val = entry.getValue()) instanceof String) || !StringUtils.contains((CharSequence)((String)val), (CharSequence)" ")) continue;
            reasonSb.append("sourceMap value cannot contains space character. key: ").append(entry.getKey()).append("value: ").append(val).append(System.lineSeparator());
            ok = false;
        }
        for (Map.Entry<String, Object> entry : desc.getJobContentMap().entrySet()) {
            if (!StringUtils.contains((CharSequence)entry.getKey(), (CharSequence)" ")) continue;
            reasonSb.append("jobContentMap key cannot contains space character. key: ").append(entry.getKey()).append(System.lineSeparator());
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)((String)desc.getLabelMap().get("engineType")))) {
            reasonSb.append("engineType").append(" cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)((String)desc.getLabelMap().get("codeType")))) {
            reasonSb.append("codeType").append(" cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)((String)desc.getSourceMap().get("scriptPath")))) {
            reasonSb.append("scriptPath").append(" cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)((String)desc.getExecutionMap().get("code"))) && StringUtils.indexOfIgnoreCase((CharSequence)((String)desc.getLabelMap().get("engineType")), (CharSequence)"sqoop") == -1) {
            reasonSb.append("code").append(" cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)((String)desc.getLabelMap().get("userCreator")))) {
            reasonSb.append("userCreator").append(" cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        } else {
            String userCreator = (String)desc.getLabelMap().get("userCreator");
            if (StringUtils.indexOf((CharSequence)desc.getProxyUser(), (CharSequence)"-") != -1) {
                reasonSb.append("'proxyUser' should not contain special character '-'").append(System.lineSeparator());
                ok = false;
            } else {
                int idx = StringUtils.indexOf((CharSequence)userCreator, (CharSequence)"-");
                if (idx == -1) {
                    reasonSb.append("userCreator").append("should contain exactly one character '-'").append(System.lineSeparator());
                    ok = false;
                } else {
                    String user = StringUtils.substring((String)userCreator, (int)0, (int)idx);
                    String creator = StringUtils.substring((String)userCreator, (int)(idx + 1));
                    if (StringUtils.isBlank((CharSequence)user) || StringUtils.isBlank((CharSequence)creator)) {
                        reasonSb.append("user or creator should not be blank").append(System.lineSeparator());
                        ok = false;
                    } else {
                        String forBiddenChars = "-";
                        if (StringUtils.containsAny((CharSequence)creator, (CharSequence)forBiddenChars)) {
                            reasonSb.append("'creator' should not contain any special characters except '_'").append(System.lineSeparator());
                            ok = false;
                        }
                    }
                }
            }
        }
        if (!ok) {
            throw new ValidateException("VLD0008", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, "LinkisJob validation failed. Reason: " + reasonSb.toString());
        }
    }
}

