/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.common;

import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.linkis.cli.application.operator.ujes.LinkisOperResultAdapter;

public class LogData {
    private String user;
    private String jobId;
    private String execId;
    private LinkedBlockingDeque<String> logBuffer = new LinkedBlockingDeque();
    private String logPath;
    private Integer nextLogLineIdx;
    private Boolean hasNextLogLine;
    private volatile Boolean logFin = false;

    public LogData(String user, String jobId, String execId) {
        this.user = user;
        this.jobId = jobId;
        this.execId = execId;
    }

    public String getUser() {
        return this.user;
    }

    public String getJobID() {
        return this.jobId;
    }

    public String getExecID() {
        return this.execId;
    }

    public final String getLogPath() {
        return this.logPath;
    }

    public final void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String consumeLog() {
        LinkedList logs = new LinkedList();
        this.logBuffer.drainTo(logs, this.logBuffer.size());
        StringBuilder tmp = new StringBuilder();
        for (String str : logs) {
            tmp.append(str);
        }
        return tmp.toString();
    }

    public void appendLog(String log) {
        this.logBuffer.add(log);
    }

    public Integer getNextLogLineIdx() {
        return this.nextLogLineIdx;
    }

    public void setNextLogLineIdx(Integer nextLogLineIdx) {
        this.nextLogLineIdx = nextLogLineIdx;
    }

    public Boolean hasNextLogLine() {
        return this.hasNextLogLine;
    }

    public void setHasNextLogLine(Boolean hasNextLogLine) {
        this.hasNextLogLine = hasNextLogLine;
    }

    public void updateLog(LinkisOperResultAdapter adapter) {
        if (adapter.getLogPath() != null) {
            this.setLogPath(adapter.getLogPath());
        }
        if (adapter.getLog() != null && adapter.getNextLogLine() != null && adapter.hasNextLogLine() != null) {
            this.setNextLogLineIdx(adapter.getNextLogLine());
            this.setHasNextLogLine(adapter.hasNextLogLine());
            this.appendLog(adapter.getLog());
        }
    }

    public void setLogFin() {
        this.logFin = true;
    }

    public Boolean isLogFin() {
        return this.logFin;
    }
}

