/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class KeyParser {
    public static Map<String, Object> removePrefixForKeysInMap(Map<String, Object> map) {
        String[] PREFIX;
        for (String prefix : PREFIX = new String[]{"wds.linkis.client.param.conf", "wds.linkis.client.param.runtime", "wds.linkis.client.param.var", "wds.linkis.client.exec", "wds.linkis.client.source", "wds.linkis.client.label", "wds.linkis.client.jobContent"}) {
            map = KeyParser.removePrefixForKeysInMap(map, prefix);
        }
        return map;
    }

    public static void removePrefixAndPutValToMap(Map<String, Object> map, String key, Object value, String prefix) {
        String realKey = KeyParser.getRealKey(key, prefix);
        if (StringUtils.isNotBlank((CharSequence)realKey) && !(value instanceof Map)) {
            map.put(realKey, value);
        }
    }

    private static Map<String, Object> removePrefixForKeysInMap(Map<String, Object> map, String prefix) {
        if (map == null) {
            return null;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            String realKey = KeyParser.getRealKey(key, prefix);
            if (!StringUtils.isNotBlank((CharSequence)realKey)) continue;
            if (StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) {
                newMap.put(realKey, map.get(key));
                continue;
            }
            newMap.put(key, map.get(key));
        }
        return newMap;
    }

    private static String getRealKey(String key, String prefix) {
        String realKey = key;
        if (StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) {
            realKey = StringUtils.substring((String)key, (int)(prefix.length() + 1));
        }
        return realKey;
    }
}

