/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.instance.label.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.linkis.instance.label.async.AsyncConsumerQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericAsyncConsumerQueue<T>
implements AsyncConsumerQueue<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericAsyncConsumerQueue.class);
    private ArrayBlockingQueue<T> innerQueue;
    private ReentrantLock consumeLock = new ReentrantLock();
    private ExecutorService consumeService;
    private Condition consumeCondition = this.consumeLock.newCondition();
    private AtomicInteger consumeBatchSize = new AtomicInteger(-1);
    private boolean exit = true;

    public GenericAsyncConsumerQueue(int maxQueueSize) {
        this.innerQueue = new ArrayBlockingQueue(maxQueueSize);
        this.consumeService = Executors.newSingleThreadExecutor();
    }

    @Override
    public int size() {
        return this.innerQueue.size();
    }

    @Override
    public boolean offer(T entity) {
        if (this.innerQueue.offer(entity)) {
            this.tryToNotifyConsumer();
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(T entity, long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.innerQueue.offer(entity, timeout, timeUnit)) {
            this.tryToNotifyConsumer();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void consumer(int batchSize, long interval, TimeUnit timeUnit, Consumer<List<T>> consumer) {
        if (!this.exit) {
            throw new IllegalStateException("The consumer has been defined, please don't define repeatedly");
        }
        this.consumeBatchSize.set(batchSize);
        this.consumeService.submit(() -> {
            long triggerTime = System.currentTimeMillis();
            long intervalInMillis = TimeUnit.MILLISECONDS.convert(interval, timeUnit);
            while (!this.exit) {
                long nowMillsTime = System.currentTimeMillis();
                if (triggerTime >= nowMillsTime) {
                    LOG.trace("wait until the next time: " + triggerTime);
                    this.consumeLock.lock();
                    try {
                        this.consumeCondition.await(triggerTime - nowMillsTime, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Interrupt in awaiting action, message: [" + e.getMessage() + "]", (Throwable)e);
                        continue;
                    }
                    finally {
                        if (!this.consumeLock.isLocked()) continue;
                        this.consumeLock.unlock();
                        continue;
                    }
                    try {
                        ArrayList elementsWaitForDeal = new ArrayList();
                        this.innerQueue.drainTo(elementsWaitForDeal, this.innerQueue.size());
                        if (!elementsWaitForDeal.isEmpty()) {
                            consumer.accept(elementsWaitForDeal);
                        }
                    }
                    catch (Throwable e) {
                        LOG.error("Exception in consuming queue, message: [" + e.getMessage() + "]", e);
                    }
                }
                triggerTime = System.currentTimeMillis() + intervalInMillis;
            }
        });
        this.exit = false;
    }

    private void tryToNotifyConsumer() {
        if (this.innerQueue.size() >= this.consumeBatchSize.get()) {
            this.consumeLock.lock();
            try {
                if (!this.innerQueue.isEmpty()) {
                    this.consumeCondition.signalAll();
                }
            }
            finally {
                this.consumeLock.unlock();
            }
        }
    }
}

