/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security.token;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.authentication.service.TokenService;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.security.GatewaySSOUtils$;
import org.apache.linkis.gateway.security.SecurityFilter$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class TokenAuthentication$
implements Logging {
    public static TokenAuthentication$ MODULE$;
    private TokenService tokenService;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new TokenAuthentication$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        TokenAuthentication$ tokenAuthentication$ = this;
        synchronized (tokenAuthentication$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private TokenService tokenService() {
        return this.tokenService;
    }

    private void tokenService_$eq(TokenService x$1) {
        this.tokenService = x$1;
    }

    public void setTokenService(TokenService tokenService) {
        this.tokenService_$eq(tokenService);
    }

    public boolean isTokenRequest(GatewayContext gatewayContext) {
        return gatewayContext.getRequest().getHeaders().containsKey(GatewayConfiguration$.MODULE$.TOKEN_KEY()) && gatewayContext.getRequest().getHeaders().containsKey(GatewayConfiguration$.MODULE$.TOKEN_USER_KEY()) || gatewayContext.getRequest().getCookies().containsKey(GatewayConfiguration$.MODULE$.TOKEN_KEY()) && gatewayContext.getRequest().getCookies().containsKey(GatewayConfiguration$.MODULE$.TOKEN_USER_KEY());
    }

    public boolean tokenAuth(GatewayContext gatewayContext, boolean login) {
        ObjectRef authMsg;
        boolean ok;
        if (!BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_TOKEN_AUTHENTICATION().getValue())) {
            Message message = Message$.MODULE$.noLogin("Gateway\u672a\u542f\u7528token\u8ba4\u8bc1\uff0c\u8bf7\u91c7\u7528\u5176\u4ed6\u8ba4\u8bc1\u65b9\u5f0f!").$less$less(gatewayContext.getRequest().getRequestURI());
            SecurityFilter$.MODULE$.filterResponse(gatewayContext, message);
            return false;
        }
        ObjectRef token = ObjectRef.create((Object)gatewayContext.getRequest().getHeaders().get(GatewayConfiguration$.MODULE$.TOKEN_KEY())[0]);
        ObjectRef tokenUser = ObjectRef.create((Object)gatewayContext.getRequest().getHeaders().get(GatewayConfiguration$.MODULE$.TOKEN_USER_KEY())[0]);
        ObjectRef host = ObjectRef.create((Object)gatewayContext.getRequest().getRequestRealIpAddr());
        if (StringUtils.isBlank((CharSequence)((String)token.elem)) || StringUtils.isBlank((CharSequence)((String)tokenUser.elem))) {
            token.elem = gatewayContext.getRequest().getCookies().get(GatewayConfiguration$.MODULE$.TOKEN_KEY())[0].getValue();
            tokenUser.elem = gatewayContext.getRequest().getCookies().get(GatewayConfiguration$.MODULE$.TOKEN_USER_KEY())[0].getValue();
            if (StringUtils.isBlank((CharSequence)((String)token.elem)) || StringUtils.isBlank((CharSequence)((String)tokenUser.elem))) {
                Message message = Message$.MODULE$.noLogin(new StringBuilder(36).append("\u8bf7\u5728Header\u6216Cookie\u4e2d\u540c\u65f6\u6307\u5b9a").append(GatewayConfiguration$.MODULE$.TOKEN_KEY()).append(" \u548c ").append(GatewayConfiguration$.MODULE$.TOKEN_USER_KEY()).append("\uff0c\u4ee5\u4fbf\u5b8c\u6210token\u8ba4\u8bc1\uff01").toString()).$less$less(gatewayContext.getRequest().getRequestURI());
                SecurityFilter$.MODULE$.filterResponse(gatewayContext, message);
                return false;
            }
        }
        boolean tokenAlive = false;
        String[] tokenAliveArr = gatewayContext.getRequest().getHeaders().get(GatewayConfiguration$.MODULE$.TOKEN_ALIVE_KEY());
        String tokenAliveStr = "";
        if (tokenAliveArr != null && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokenAliveArr)).isEmpty()) {
            tokenAliveStr = gatewayContext.getRequest().getHeaders().get(GatewayConfiguration$.MODULE$.TOKEN_ALIVE_KEY())[0];
        } else {
            Cookie[] tokenAliveCookieArr = gatewayContext.getRequest().getCookies().get(GatewayConfiguration$.MODULE$.TOKEN_ALIVE_KEY());
            if (tokenAliveCookieArr != null && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokenAliveCookieArr)).isEmpty()) {
                tokenAliveStr = tokenAliveCookieArr[0].getValue();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)tokenAliveStr) && tokenAliveStr.toLowerCase().equals(GatewayConfiguration$.MODULE$.TOKEN_ALIVE_TRUE())) {
            tokenAlive = true;
        }
        if (ok = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.tokenService().doAuth((String)token$1.elem, (String)tokenUser$1.elem, (String)host$1.elem), arg_0 -> TokenAuthentication$.$anonfun$tokenAuth$2$adapted(authMsg = ObjectRef.create((Object)Message$.MODULE$.noLogin(new StringBuilder(28).append("\u672a\u6388\u6743\u7684token").append((String)token.elem).append("\uff0c\u65e0\u6cd5\u5c06\u8bf7\u6c42\u7ed1\u5b9a\u7ed9tokenUser").append((String)tokenUser.elem).append("!").toString()).$less$less(gatewayContext.getRequest().getRequestURI())), token, tokenUser, gatewayContext, arg_0)))) {
            this.logger().info(new StringBuilder(66).append("Token authentication succeed, uri: ").append(gatewayContext.getRequest().getRequestURI()).append(", token: ").append((String)token.elem).append(", tokenUser: ").append((String)tokenUser.elem).append(", host: ").append((String)host.elem).append(".").toString());
            if (login) {
                this.logger().info(new StringBuilder(58).append("Token authentication succeed, uri: ").append(gatewayContext.getRequest().getRequestURI()).append(", token: ").append((String)token.elem).append(", tokenUser: ").append((String)tokenUser.elem).append(".").toString());
                GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, (String)tokenUser.elem);
                Message msg = Message$.MODULE$.ok("login successful(\u767b\u5f55\u6210\u529f)\uff01").data("userName", (Object)((String)tokenUser.elem)).data("isAdmin", (Object)BoxesRunTime.boxToBoolean((boolean)false));
                SecurityFilter$.MODULE$.filterResponse(gatewayContext, msg);
                return false;
            }
            if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_TOEKN_AUTHENTICATION_ALIVE().getValue()) || tokenAlive) {
                if (this.logger().isDebugEnabled()) {
                    this.logger().debug(new StringBuilder(52).append("Token auth of user : ").append((String)tokenUser.elem).append(" has param : tokenAlive : true.").toString());
                }
                GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext.getRequest(), (String)tokenUser.elem, true);
            } else {
                GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext.getRequest(), (String)tokenUser.elem, false);
            }
            return true;
        }
        this.logger().info(new StringBuilder(63).append("Token authentication fail, uri: ").append(gatewayContext.getRequest().getRequestURI()).append(", token: ").append((String)token.elem).append(", tokenUser: ").append((String)tokenUser.elem).append(", host: ").append((String)host.elem).append(".").toString());
        SecurityFilter$.MODULE$.filterResponse(gatewayContext, (Message)authMsg.elem);
        return false;
    }

    public boolean tokenAuth$default$2() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$tokenAuth$2(ObjectRef authMsg$1, ObjectRef token$1, ObjectRef tokenUser$1, GatewayContext gatewayContext$1, Throwable t) {
        authMsg$1.elem = Message$.MODULE$.noLogin(new StringBuilder(58).append("Token Authentication Failed, token: ").append((String)token$1.elem).append("\uff0ctokenUser: ").append((String)tokenUser$1.elem).append(", reason: ").append(t.getMessage()).toString()).$less$less(gatewayContext$1.getRequest().getRequestURI());
        return false;
    }

    private TokenAuthentication$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ Object $anonfun$tokenAuth$2$adapted(ObjectRef authMsg$1, ObjectRef token$1, ObjectRef tokenUser$1, GatewayContext gatewayContext$1, Throwable t) {
        return BoxesRunTime.boxToBoolean((boolean)TokenAuthentication$.$anonfun$tokenAuth$2(authMsg$1, token$1, tokenUser$1, gatewayContext$1, t));
    }
}

