/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.route;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.errorcode.LinkisModuleErrorCodeSummary;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.route.GatewayRouter;
import org.apache.linkis.rpc.interceptor.ServiceInstanceUtils$;
import org.apache.linkis.rpc.sender.SpringCloudFeignConfigurationCache$;
import org.apache.linkis.server.exception.NoApplicationExistsException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000114Q\u0001C\u0005\u0002\u0002QAQa\n\u0001\u0005\u0002!BqA\u000b\u0001C\u0002\u0013E1\u0006\u0003\u00040\u0001\u0001\u0006I\u0001\f\u0005\u0006a\u0001!\t\"\r\u0005\u0006\u0007\u0002!\tb\u0012\u0005\u00061\u0002!\t\"\u0017\u0005\u0006Q\u0002!\t\"\u001b\u0002\u0016\u0003\n\u001cHO]1di\u001e\u000bG/Z<bsJ{W\u000f^3s\u0015\tQ1\"A\u0003s_V$XM\u0003\u0002\r\u001b\u00059q-\u0019;fo\u0006L(B\u0001\b\u0010\u0003\u0019a\u0017N\\6jg*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u000b\u001c?A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u000f\u000e\u0003%I!AH\u0005\u0003\u001b\u001d\u000bG/Z<bsJ{W\u000f^3s!\t\u0001S%D\u0001\"\u0015\t\u00113%A\u0003vi&d7O\u0003\u0002%\u001b\u000511m\\7n_:L!AJ\u0011\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u000b\t\u00039\u0001\ta\"\u001a8bE2,GMU3ge\u0016\u001c\b.F\u0001-!\t1R&\u0003\u0002//\t9!i\\8mK\u0006t\u0017aD3oC\ndW\r\u001a*fMJ,7\u000f\u001b\u0011\u00023\u0019Lg\u000eZ!oIJ+gM]3tQ&3gj\u001c;Fq&\u001cHo\u001d\u000b\u0004e\u0001\u0013\u0005c\u0001\f4k%\u0011Ag\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YjdBA\u001c<!\tAt#D\u0001:\u0015\tQ4#\u0001\u0004=e>|GOP\u0005\u0003y]\ta\u0001\u0015:fI\u00164\u0017B\u0001 @\u0005\u0019\u0019FO]5oO*\u0011Ah\u0006\u0005\u0006\u0003\u0012\u0001\r!N\u0001\ng\u0016\u0014h/[2f\u0013\u0012Daa\u0011\u0003\u0005\u0002\u0004!\u0015a\u00034j]\u0012\u001cVM\u001d<jG\u0016\u00042AF#3\u0013\t1uC\u0001\u0005=Eft\u0017-\\3?)\r\u0011\u0004J\u0013\u0005\u0006\u0013\u0016\u0001\r!N\u0001\u0010a\u0006\u00148/\u001a3TKJ4\u0018nY3JI\")1*\u0002a\u0001\u0019\u0006YAo\\8NC:LH)Z1m!\u00111Rj\u0014\u001a\n\u00059;\"!\u0003$v]\u000e$\u0018n\u001c82!\r\u0001V+\u000e\b\u0003#Ns!\u0001\u000f*\n\u0003aI!\u0001V\f\u0002\u000fA\f7m[1hK&\u0011ak\u0016\u0002\u0005\u0019&\u001cHO\u0003\u0002U/\u0005\u0019\"/\u001a;bS:\fE\u000e\\%o%\u0016<\u0017n\u001d;ssR\u0019!,\u001a4\u0011\u0007m\u0003\u0017-D\u0001]\u0015\tif,\u0001\u0003vi&d'\"A0\u0002\t)\fg/Y\u0005\u0003-r\u0003\"AY2\u000e\u0003\rJ!\u0001Z\u0012\u0003\u001fM+'O^5dK&s7\u000f^1oG\u0016DQ!\u0011\u0004A\u0002UBQa\u001a\u0004A\u0002i\u000b\u0001c]3sm&\u001cW-\u00138ti\u0006t7-Z:\u0002+I,Wn\u001c<f\u00032dgI]8n%\u0016<\u0017n\u001d;ssR\u0019!L[6\t\u000b\u0005;\u0001\u0019A\u001b\t\u000b\u001d<\u0001\u0019\u0001.")
public abstract class AbstractGatewayRouter
implements GatewayRouter,
Logging {
    private final boolean enabledRefresh;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public int order() {
        return GatewayRouter.order$(this);
    }

    private Logger logger$lzycompute() {
        AbstractGatewayRouter abstractGatewayRouter = this;
        synchronized (abstractGatewayRouter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public boolean enabledRefresh() {
        return this.enabledRefresh;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<String> findAndRefreshIfNotExists(String serviceId, Function0<Option<String>> findService) {
        Object object;
        ObjectRef service = ObjectRef.create((Object)((Option)findService.apply()));
        if (((Option)service.elem).isEmpty()) {
            NoApplicationExistsException applicationNotExists = new NoApplicationExistsException(LinkisModuleErrorCodeSummary.NOT_EXISTS_APPLICATION.getErrorCode(), MessageFormat.format(LinkisModuleErrorCodeSummary.NOT_EXISTS_APPLICATION.getErrorDesc(), serviceId));
            if (!this.enabledRefresh()) throw applicationNotExists;
            object = Utils$.MODULE$.tryThrow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.waitUntil((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                ServiceInstanceUtils$.MODULE$.refreshServiceInstances();
                service$1.elem = (Option)findService.apply();
                return ((Option)service$1.elem).nonEmpty();
            }, ServiceInstanceUtils$.MODULE$.serviceRefreshMaxWaitTime(), 500, 2000L), (Function1 & Serializable & scala.Serializable)t -> {
                this.logger().warn(new StringBuilder(66).append("Need a random ").append(serviceId).append(" instance, but no one can find in Discovery refresh.").toString(), t);
                applicationNotExists.initCause(t);
                return applicationNotExists;
            });
            return (Option)service.elem;
        } else {
            object = BoxedUnit.UNIT;
        }
        return (Option)service.elem;
    }

    public Option<String> findService(String parsedServiceId, Function1<List<String>, Option<String>> tooManyDeal) {
        List services = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(SpringCloudFeignConfigurationCache$.MODULE$.getDiscoveryClient().getServices()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractGatewayRouter.$anonfun$findService$1(parsedServiceId, x$1)))).toList();
        if (services.length() == 1) {
            return new Some(services.head());
        }
        if (services.length() > 1) {
            return (Option)tooManyDeal.apply((Object)services);
        }
        return None$.MODULE$;
    }

    public java.util.List<ServiceInstance> retainAllInRegistry(String serviceId, java.util.List<ServiceInstance> serviceInstances) {
        ServiceInstance[] instancesInRegistry = ServiceInstanceUtils$.MODULE$.getRPCServerLoader().getServiceInstances(serviceId);
        return (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(serviceInstances).asScala()).filter((Function1 & Serializable & scala.Serializable)instance -> BoxesRunTime.boxToBoolean((boolean)AbstractGatewayRouter.$anonfun$retainAllInRegistry$1(instancesInRegistry, instance)))).asJava();
    }

    public java.util.List<ServiceInstance> removeAllFromRegistry(String serviceId, java.util.List<ServiceInstance> serviceInstances) {
        ObjectRef serviceInstancesInRegistry = ObjectRef.create((Object)ServiceInstanceUtils$.MODULE$.getRPCServerLoader().getServiceInstances(serviceId));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(serviceInstances).asScala()).foreach((Function1 & Serializable & scala.Serializable)serviceInstance -> {
            serviceInstancesInRegistry.elem = (ServiceInstance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ServiceInstance[])serviceInstancesInRegistry.elem))).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals((Object)serviceInstance)));
            return BoxedUnit.UNIT;
        });
        if ((ServiceInstance[])serviceInstancesInRegistry.elem == null) {
            return new ArrayList<ServiceInstance>();
        }
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ServiceInstance[])serviceInstancesInRegistry.elem))).toList()).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$findService$1(String parsedServiceId$1, String x$1) {
        return x$1.toLowerCase(Locale.getDefault()).contains(parsedServiceId$1.toLowerCase(Locale.getDefault()));
    }

    public static final /* synthetic */ boolean $anonfun$retainAllInRegistry$1(ServiceInstance[] instancesInRegistry$1, ServiceInstance instance) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instancesInRegistry$1)).contains((Object)instance);
    }

    public AbstractGatewayRouter() {
        GatewayRouter.$init$(this);
        Logging.$init$((Logging)this);
        this.enabledRefresh = BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.GATEWAY_SERVER_REFRESH_ENABLED().getValue());
    }
}

