/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.entrance.EntranceServer;
import org.apache.linkis.entrance.conf.EntranceConfiguration;
import org.apache.linkis.entrance.scheduler.EntranceSchedulerContext;
import org.apache.linkis.entrance.utils.JobHistoryHelper;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.publicservice.common.lock.entity.CommonLock;
import org.apache.linkis.publicservice.common.lock.service.CommonLockService;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.scheduler.queue.SchedulerEventState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import scala.Enumeration;

@Component(value="entranceFailoverServer")
public class EntranceFailoverJobServer {
    private static final Logger logger = LoggerFactory.getLogger(EntranceFailoverJobServer.class);
    @Autowired
    private EntranceServer entranceServer;
    @Autowired
    private CommonLockService commonLockService;
    private static String ENTRANCE_FAILOVER_LOCK = "ENTRANCE_FAILOVER_LOCK";
    private ScheduledExecutorService scheduledExecutor;
    private Future future;

    @PostConstruct
    public void init() {
        if (EntranceConfiguration.ENTRANCE_FAILOVER_ENABLED()) {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(Utils.threadFactory((String)"Linkis-Failover-Scheduler-Thread-", (boolean)true));
            this.failoverTask();
        }
    }

    @EventListener
    private void shutdownFailover(ContextClosedEvent event) {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(true);
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            logger.info("Entrance Failover Server exit!");
        }
    }

    public void failoverTask() {
        this.future = this.scheduledExecutor.scheduleWithFixedDelay(() -> {
            EntranceSchedulerContext schedulerContext = (EntranceSchedulerContext)this.entranceServer.getEntranceContext().getOrCreateScheduler().getSchedulerContext();
            if (schedulerContext.getOfflineFlag()) {
                return;
            }
            CommonLock commonLock = new CommonLock();
            commonLock.setLockObject(ENTRANCE_FAILOVER_LOCK);
            Boolean locked = false;
            try {
                List<JobRequest> jobRequests;
                locked = this.commonLockService.lock(commonLock, Long.valueOf(30000L));
                if (!locked.booleanValue()) {
                    return;
                }
                logger.info("success locked {}", (Object)ENTRANCE_FAILOVER_LOCK);
                ServiceInstance[] serviceInstances = Sender.getInstances((String)Sender.getThisServiceInstance().getApplicationName());
                if (serviceInstances == null || serviceInstances.length <= 0) {
                    return;
                }
                Map<String, Long> serverInstanceMap = Arrays.stream(serviceInstances).collect(Collectors.toMap(ServiceInstance::getInstance, ServiceInstance::getRegistryTimestamp, (k1, k2) -> k2));
                if (!serverInstanceMap.containsKey(Sender.getThisInstance())) {
                    logger.warn("server has just started and has not get self info, it does not failover");
                    return;
                }
                long expiredTimestamp = 0L;
                if (EntranceConfiguration.ENTRANCE_FAILOVER_DATA_INTERVAL_TIME() > 0L) {
                    expiredTimestamp = System.currentTimeMillis() - EntranceConfiguration.ENTRANCE_FAILOVER_DATA_INTERVAL_TIME();
                }
                if ((jobRequests = JobHistoryHelper.queryWaitForFailoverTask(serverInstanceMap, this.getUnCompleteStatus(), expiredTimestamp, EntranceConfiguration.ENTRANCE_FAILOVER_DATA_NUM_LIMIT())).isEmpty()) {
                    return;
                }
                List ids = jobRequests.stream().map(JobRequest::getId).collect(Collectors.toList());
                logger.info("success query failover jobs , job size: {}, ids: {}", (Object)ids.size(), ids);
                for (JobRequest jobRequest : jobRequests) {
                    this.entranceServer.failoverExecute(jobRequest);
                }
                logger.info("finished execute failover jobs, job ids: {}", ids);
            }
            catch (Exception e) {
                logger.error("failover failed", (Throwable)e);
            }
            finally {
                if (locked.booleanValue()) {
                    this.commonLockService.unlock(commonLock);
                }
            }
        }, EntranceConfiguration.ENTRANCE_FAILOVER_SCAN_INIT_TIME(), EntranceConfiguration.ENTRANCE_FAILOVER_SCAN_INTERVAL(), TimeUnit.MILLISECONDS);
    }

    private List<String> getUnCompleteStatus() {
        ArrayList<String> status = new ArrayList<String>();
        Enumeration.ValueSet values = SchedulerEventState.values();
        for (Enumeration.Value next : values) {
            if (SchedulerEventState.isCompleted((Enumeration.Value)next)) continue;
            status.add(next.toString());
        }
        return status;
    }
}

