/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.job;

import java.io.Closeable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.log.LogUtils;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.entrance.exception.EntranceErrorException;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.job.EntranceExecuteRequest;
import org.apache.linkis.entrance.log.LogHandler;
import org.apache.linkis.entrance.log.LogReader;
import org.apache.linkis.entrance.log.LogWriter;
import org.apache.linkis.entrance.log.WebSocketCacheLogReader;
import org.apache.linkis.entrance.log.WebSocketLogWriter;
import org.apache.linkis.entrance.persistence.PersistenceManager;
import org.apache.linkis.entrance.utils.CommonLogPathUtils;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.protocol.task.RequestTask$;
import org.apache.linkis.orchestrator.plans.ast.QueryParams$;
import org.apache.linkis.protocol.utils.TaskUtils;
import org.apache.linkis.scheduler.executer.ExecuteRequest;
import org.apache.linkis.scheduler.queue.JobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class EntranceExecutionJob
extends EntranceJob
implements LogHandler {
    private static final Logger logger = LoggerFactory.getLogger(EntranceExecutionJob.class);
    private static final ThreadLocal<SimpleDateFormat> dateFormatLocal = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private LogReader logReader;
    private LogWriter logWriter;
    private Object logWriterLocker = new Object();
    private WebSocketCacheLogReader webSocketCacheLogReader;
    private WebSocketLogWriter webSocketLogWriter;
    private PersistenceManager persistenceManager;

    public EntranceExecutionJob(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public Object getLogWriterLocker() {
        return this.logWriterLocker;
    }

    @Override
    public void setLogReader(LogReader logReader) {
        this.logReader = logReader;
    }

    @Override
    public Option<LogReader> getLogReader() {
        return Option.apply((Object)this.logReader);
    }

    @Override
    public void setLogWriter(LogWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    public Option<LogWriter> getLogWriter() {
        return Option.apply((Object)this.logWriter);
    }

    @Override
    public Option<WebSocketCacheLogReader> getWebSocketLogReader() {
        return Option.apply((Object)this.webSocketCacheLogReader);
    }

    @Override
    public void setWebSocketLogReader(WebSocketCacheLogReader webSocketCacheLogReader) {
        this.webSocketCacheLogReader = webSocketCacheLogReader;
    }

    @Override
    public void setWebSocketLogWriter(WebSocketLogWriter webSocketLogWriter) {
        this.webSocketLogWriter = webSocketLogWriter;
    }

    @Override
    public Option<WebSocketLogWriter> getWebSocketLogWriter() {
        return Option.apply((Object)this.webSocketLogWriter);
    }

    public void init() throws EntranceErrorException {
        this.updateNewestAccessByClientTimestamp();
    }

    public ExecuteRequest jobToExecuteRequest() throws EntranceErrorException {
        HashMap starupMapTmp = new HashMap();
        Map starupMapOri = TaskUtils.getStartupMap(this.getParams());
        JobRequest jobRequest = this.getJobRequest();
        if (starupMapOri.isEmpty()) {
            TaskUtils.addStartupMap(this.getParams(), (Map)starupMapOri);
        }
        if (!starupMapOri.containsKey(JobRequestConstants.JOB_REQUEST_LIST())) {
            starupMapOri.put(JobRequestConstants.JOB_ID(), String.valueOf(jobRequest.getId()));
        }
        for (Map.Entry entry : starupMapOri.entrySet()) {
            if (null == entry.getKey() || null == entry.getValue()) continue;
            starupMapTmp.put(entry.getKey(), entry.getValue().toString());
        }
        Map runtimeMapOri = TaskUtils.getRuntimeMap(this.getParams());
        if (null == runtimeMapOri || runtimeMapOri.isEmpty()) {
            TaskUtils.addRuntimeMap(this.getParams(), new HashMap());
            runtimeMapOri = TaskUtils.getRuntimeMap(this.getParams());
        }
        if (!runtimeMapOri.containsKey(JobRequestConstants.JOB_ID())) {
            runtimeMapOri.put(JobRequestConstants.JOB_ID(), String.valueOf(jobRequest.getId()));
        }
        HashMap runtimeMapTmp = new HashMap();
        for (Map.Entry entry : runtimeMapOri.entrySet()) {
            if (null == entry.getKey() || null == entry.getValue()) continue;
            runtimeMapTmp.put(entry.getKey(), entry.getValue().toString());
        }
        String resultSetPathRoot = (String)GovernanceCommonConf.RESULT_SET_STORE_PATH().getValue(runtimeMapTmp);
        if (!runtimeMapTmp.containsKey(GovernanceCommonConf.RESULT_SET_STORE_PATH().key())) {
            String resultParentPath = CommonLogPathUtils.getResultParentPath(jobRequest);
            CommonLogPathUtils.buildCommonPath(resultParentPath);
            resultSetPathRoot = CommonLogPathUtils.getResultPath(jobRequest);
        }
        HashMap<String, String> jobMap = new HashMap<String, String>();
        jobMap.put(RequestTask$.MODULE$.RESULT_SET_STORE_PATH(), resultSetPathRoot);
        runtimeMapOri.put(QueryParams$.MODULE$.JOB_KEY(), jobMap);
        jobRequest.setResultLocation(resultSetPathRoot);
        EntranceExecuteRequest executeRequest = new EntranceExecuteRequest(this);
        ArrayList labels = new ArrayList(jobRequest.getLabels());
        executeRequest.setLabels(labels);
        return executeRequest;
    }

    public String getName() {
        return "jobGroupId:" + String.valueOf(this.getJobRequest().getId()) + " execID:" + this.getId();
    }

    public String getId() {
        return super.getId();
    }

    public JobInfo getJobInfo() {
        Map metricsMap;
        String execID = this.getId();
        String state = this.getState().toString();
        float progress = this.getProgress();
        SimpleDateFormat simpleDateFormat = dateFormatLocal.get();
        if (this.getJobRequest().getMetrics() == null) {
            this.getJobRequest().setMetrics(new HashMap());
        }
        String createTime = (metricsMap = this.getJobRequest().getMetrics()).containsKey("submitTime") ? simpleDateFormat.format(metricsMap.get("submitTime")) : "not created";
        String scheduleTime = metricsMap.containsKey("scheduleTime") ? simpleDateFormat.format(metricsMap.get("scheduleTime")) : "not scheduled";
        String startTime = metricsMap.containsKey("runningTime") ? simpleDateFormat.format(metricsMap.get("runningTime")) : "not submitted to orchestrator";
        String endTime = metricsMap.containsKey("completeTime") ? simpleDateFormat.format(metricsMap.get("completeTime")) : "on running or not started";
        String runTime = metricsMap.containsKey("completeTime") ? ByteTimeUtils.msDurationToString((long)(((Date)metricsMap.get("completeTime")).getTime() - ((Date)metricsMap.get("submitTime")).getTime())) : "The task did not end normally and the usage time could not be counted.(\u4efb\u52a1\u5e76\u672a\u6b63\u5e38\u7ed3\u675f\uff0c\u65e0\u6cd5\u7edf\u8ba1\u4f7f\u7528\u65f6\u95f4)";
        String jobToOrchestrator = metricsMap.containsKey("jobToOrchestrator") ? simpleDateFormat.format(metricsMap.get("jobToOrchestrator")) : "not to orchestrator";
        String jobRequestEC = metricsMap.containsKey("requestECTime") ? simpleDateFormat.format(metricsMap.get("requestECTime")) : "not request ec";
        String jobSubmitToEC = metricsMap.containsKey("jobToECTIme") ? simpleDateFormat.format(metricsMap.get("jobToECTIme")) : "not submit to  ec";
        StringBuffer sb = new StringBuffer();
        sb.append("Task time point information(\u4efb\u52a1\u65f6\u95f4\u8282\u70b9\u4fe1\u606f):\n").append("[Task creation time(\u4efb\u52a1\u521b\u5efa\u65f6\u95f4)]  :").append(createTime).append("\n").append("[Task scheduling time(\u4efb\u52a1\u8c03\u5ea6\u65f6\u95f4)]:").append(scheduleTime).append("\n").append("[Task start time(\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4)]     :").append(startTime).append("\n").append("[Task end time(\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4)]       :").append(endTime).append("\n").append(LogUtils.generateInfo((String)"")).append("[Task submit to Orchestrator time]:").append(jobToOrchestrator).append("\n").append("[Task request EngineConn time]    :").append(jobRequestEC).append("\n").append("[Task submit to EngineConn time]  :").append(jobSubmitToEC).append("\n").append(LogUtils.generateInfo((String)("Your task jobId(\u60a8\u7684\u4efb\u52a1) " + this.getJobRequest().getId() + " The total time spent is(\u603b\u8017\u65f6\u65f6\u95f4\u4e3a): " + runTime)));
        String metric = sb.toString();
        return new JobInfo(execID, null, state, progress, metric);
    }

    public void close() throws IOException {
        logger.info("job:" + this.jobRequest().getId() + " is closing");
        try {
            if (this.getLogWriter().isDefined()) {
                IOUtils.closeQuietly((Closeable)((Closeable)this.getLogWriter().get()));
            } else {
                logger.info("job:" + this.jobRequest().getId() + "LogWriter is null");
            }
            if (this.getLogReader().isDefined()) {
                IOUtils.closeQuietly((Closeable)((Closeable)this.getLogReader().get()));
            }
        }
        catch (Exception e) {
            logger.warn("Close logWriter and logReader failed. {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void clear() {
        super.clear();
        this.setParams(null);
        JobRequest jobRequest = this.getJobRequest();
        jobRequest.setExecutionCode(null);
        jobRequest.setMetrics(null);
    }
}

