/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.crypto.CryptoConfiguration;
import com.aliyun.oss.crypto.CryptoModuleBase;
import com.aliyun.oss.crypto.CryptoModuleDispatcher;
import com.aliyun.oss.crypto.EncryptionMaterials;
import com.aliyun.oss.crypto.KmsEncryptionMaterials;
import com.aliyun.oss.crypto.MultipartUploadCryptoContext;
import com.aliyun.oss.crypto.OSSDirect;
import com.aliyun.oss.internal.OSSDownloadOperationEncrypted;
import com.aliyun.oss.internal.OSSUploadOperationEncrypted;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.DownloadFileResult;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.aliyun.oss.model.UploadPartCopyRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class OSSEncryptionClient
extends OSSClient {
    public static final String USER_AGENT_SUFFIX = "/OSSEncryptionClient";
    private final EncryptionMaterials encryptionMaterials;
    private final CryptoConfiguration cryptoConfig;
    private final OSSDirect ossDirect = new OSSDirectImpl();

    public OSSEncryptionClient(String endpoint, CredentialsProvider credsProvider, ClientConfiguration clientConfig, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        super(endpoint, credsProvider, clientConfig);
        this.assertParameterNotNull(credsProvider, "CredentialsProvider");
        this.assertParameterNotNull(encryptionMaterials, "EncryptionMaterials");
        if (encryptionMaterials instanceof KmsEncryptionMaterials) {
            ((KmsEncryptionMaterials)encryptionMaterials).setKmsCredentialsProvider(credsProvider);
        }
        this.cryptoConfig = cryptoConfig == null ? CryptoConfiguration.DEFAULT : cryptoConfig;
        this.encryptionMaterials = encryptionMaterials;
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest req) throws OSSException, ClientException {
        CryptoModuleDispatcher crypto = new CryptoModuleDispatcher(this.ossDirect, this.encryptionMaterials, this.cryptoConfig);
        return crypto.putObjectSecurely(req);
    }

    @Override
    public OSSObject getObject(GetObjectRequest req) throws OSSException, ClientException {
        if (req.isUseUrlSignature()) {
            throw new ClientException("Encryption client error, get object with url opreation is disabled in encryption client.Please use normal oss client method {@OSSClient#getObject(GetObjectRequest req)}.");
        }
        CryptoModuleDispatcher crypto = new CryptoModuleDispatcher(this.ossDirect, this.encryptionMaterials, this.cryptoConfig);
        return crypto.getObjectSecurely(req);
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest req, File file) throws OSSException, ClientException {
        CryptoModuleDispatcher crypto = new CryptoModuleDispatcher(this.ossDirect, this.encryptionMaterials, this.cryptoConfig);
        return crypto.getObjectSecurely(req, file);
    }

    @Override
    public UploadFileResult uploadFile(UploadFileRequest uploadFileRequest) throws Throwable {
        OSSUploadOperationEncrypted ossUploadOperationEncrypted = new OSSUploadOperationEncrypted(this, this.encryptionMaterials);
        this.setUploadOperation(ossUploadOperationEncrypted);
        return super.uploadFile(uploadFileRequest);
    }

    @Override
    public DownloadFileResult downloadFile(DownloadFileRequest downloadFileRequest) throws Throwable {
        ObjectMetadata objectMetadata;
        long objectSize;
        Payer payer;
        GenericRequest genericRequest = new GenericRequest(downloadFileRequest.getBucketName(), downloadFileRequest.getKey());
        String versionId = downloadFileRequest.getVersionId();
        if (versionId != null) {
            genericRequest.setVersionId(versionId);
        }
        if ((payer = downloadFileRequest.getRequestPayer()) != null) {
            genericRequest.setRequestPayer(payer);
        }
        if ((objectSize = (objectMetadata = this.getObjectMetadata(genericRequest)).getContentLength()) <= downloadFileRequest.getPartSize()) {
            GetObjectRequest getObjectRequest = OSSEncryptionClient.convertToGetObjectRequest(downloadFileRequest);
            objectMetadata = this.getObject(getObjectRequest, new File(downloadFileRequest.getDownloadFile()));
            DownloadFileResult downloadFileResult = new DownloadFileResult();
            downloadFileResult.setObjectMetadata(objectMetadata);
            return downloadFileResult;
        }
        if (!CryptoModuleBase.hasEncryptionInfo(objectMetadata)) {
            return super.downloadFile(downloadFileRequest);
        }
        long partSize = downloadFileRequest.getPartSize();
        if (0L != partSize % 16L || partSize <= 0L) {
            throw new IllegalArgumentException("download file part size is not 16 bytes alignment.");
        }
        OSSDownloadOperationEncrypted ossDownloadOperationEncrypted = new OSSDownloadOperationEncrypted(this);
        this.setDownloadOperation(ossDownloadOperationEncrypted);
        return super.downloadFile(downloadFileRequest);
    }

    private static GetObjectRequest convertToGetObjectRequest(DownloadFileRequest downloadFileRequest) {
        int limit;
        Payer payer;
        String versionId;
        GetObjectRequest getObjectRequest = new GetObjectRequest(downloadFileRequest.getBucketName(), downloadFileRequest.getKey());
        getObjectRequest.setMatchingETagConstraints(downloadFileRequest.getMatchingETagConstraints());
        getObjectRequest.setNonmatchingETagConstraints(downloadFileRequest.getNonmatchingETagConstraints());
        getObjectRequest.setModifiedSinceConstraint(downloadFileRequest.getModifiedSinceConstraint());
        getObjectRequest.setUnmodifiedSinceConstraint(downloadFileRequest.getUnmodifiedSinceConstraint());
        getObjectRequest.setResponseHeaders(downloadFileRequest.getResponseHeaders());
        long[] range = downloadFileRequest.getRange();
        if (range != null) {
            getObjectRequest.setRange(range[0], range[1]);
        }
        if ((versionId = downloadFileRequest.getVersionId()) != null) {
            getObjectRequest.setVersionId(versionId);
        }
        if ((payer = downloadFileRequest.getRequestPayer()) != null) {
            getObjectRequest.setRequestPayer(payer);
        }
        if ((limit = downloadFileRequest.getTrafficLimit()) > 0) {
            getObjectRequest.setTrafficLimit(limit);
        }
        return getObjectRequest;
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request, MultipartUploadCryptoContext context) throws OSSException, ClientException {
        CryptoModuleDispatcher crypto = new CryptoModuleDispatcher(this.ossDirect, this.encryptionMaterials, this.cryptoConfig);
        return crypto.initiateMultipartUploadSecurely(request, context);
    }

    public UploadPartResult uploadPart(UploadPartRequest request, MultipartUploadCryptoContext context) {
        CryptoModuleDispatcher crypto = new CryptoModuleDispatcher(this.ossDirect, this.encryptionMaterials, this.cryptoConfig);
        return crypto.uploadPartSecurely(request, context);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request, MultipartUploadCryptoContext context) throws OSSException, ClientException {
        return super.completeMultipartUpload(request);
    }

    @Override
    @Deprecated
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws ClientException {
        throw new ClientException("Encryption client error, you should provide a multipart upload context to the encryption client. Please use  encryption client method {@link OSSEncryptionClient#initiateMultipartUpload(InitiateMultipartUploadRequest request, MultipartUploadCryptoContext context)}.");
    }

    @Override
    @Deprecated
    public UploadPartResult uploadPart(UploadPartRequest request) throws ClientException {
        throw new ClientException("Encryption client error, you should provide a multipart upload context to the encryption client. Please use  encryption client method {@link OSSEncryptionClient#uploadPart(UploadPartRequest request, MultipartUploadCryptoContext context)}.");
    }

    @Override
    @Deprecated
    public AppendObjectResult appendObject(AppendObjectRequest appendObjectRequest) throws ClientException {
        throw new ClientException("Encryption client error, this method is disabled in encryption client.Please use normal oss client method {@link OSSClient#appendObject(AppendObjectRequest appendObjectRequest)} method");
    }

    @Override
    @Deprecated
    public UploadPartCopyResult uploadPartCopy(UploadPartCopyRequest request) throws ClientException {
        throw new ClientException("Encryption client error, this method is disabled in encryption client.Please use normal oss client method {@link OSSClient#uploadPartCopy(UploadPartCopyRequest request)}");
    }

    @Override
    @Deprecated
    public PutObjectResult putObject(URL signedUrl, InputStream requestContent, long contentLength, Map<String, String> requestHeaders, boolean useChunkEncoding) throws ClientException {
        throw new ClientException("Encryption client error, this method is disabled in encryption client.Please use normal oss client method {@link OSSClient#putObject(URL signedUrl, InputStream requestContent, long contentLength, Map<String, String> requestHeaders, boolean useChunkEncoding)");
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private final class OSSDirectImpl
    implements OSSDirect {
        private OSSDirectImpl() {
        }

        @Override
        public ClientConfiguration getInnerClientConfiguration() {
            return OSSEncryptionClient.this.getClientConfiguration();
        }

        @Override
        public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
            return OSSEncryptionClient.super.putObject(putObjectRequest);
        }

        @Override
        public OSSObject getObject(GetObjectRequest getObjectRequest) {
            return OSSEncryptionClient.super.getObject(getObjectRequest);
        }

        @Override
        public void abortMultipartUpload(AbortMultipartUploadRequest request) {
            OSSEncryptionClient.super.abortMultipartUpload(request);
        }

        @Override
        public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) {
            return OSSEncryptionClient.super.completeMultipartUpload(request);
        }

        @Override
        public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) {
            return OSSEncryptionClient.super.initiateMultipartUpload(request);
        }

        @Override
        public UploadPartResult uploadPart(UploadPartRequest request) {
            return OSSEncryptionClient.super.uploadPart(request);
        }
    }
}

