/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.errorcode.client;

import org.apache.linkis.errorcode.client.ClientConfiguration;
import org.apache.linkis.errorcode.client.LinkisErrorCodeClient;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.config.ClientConfig;
import org.apache.linkis.httpclient.config.ClientConfigBuilder;
import org.apache.linkis.httpclient.dws.DWSHttpClient;
import org.apache.linkis.httpclient.dws.authentication.TokenAuthenticationStrategy;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;

public class ErrorCodeClientBuilder {
    private String linkisGatewayUrl = ClientConfiguration.getGatewayUrl();
    private AuthenticationStrategy authenticationStrategy = new TokenAuthenticationStrategy();
    private ClientConfigBuilder clientConfigBuilder = ClientConfigBuilder.newBuilder();
    private long connectionTimeout = ClientConfiguration.getConnectTimeOut();
    private long readTimeOut = ClientConfiguration.getReadTimeOut();
    private String authTokenKey = ClientConfiguration.getAuthKey();
    private String authTokenValue = ClientConfiguration.getAuthValue();
    private String version = ClientConfiguration.getVersion();
    private int maxConnection = 100;
    private static final String CLIENT_NAME = "ErrorCode-Client";

    public LinkisErrorCodeClient build() {
        ClientConfig clientConfig = this.clientConfigBuilder.addServerUrl(this.linkisGatewayUrl).connectionTimeout(this.connectionTimeout).discoveryEnabled(false).loadbalancerEnabled(false).maxConnectionSize(this.maxConnection).retryEnabled(false).readTimeout(this.readTimeOut).setAuthenticationStrategy(this.authenticationStrategy).setAuthTokenKey(this.authTokenKey).setAuthTokenValue(this.authTokenValue).build();
        DWSClientConfig dwsClientConfig = new DWSClientConfig(clientConfig);
        dwsClientConfig.setDWSVersion(this.version);
        DWSHttpClient dwsHttpClient = new DWSHttpClient(dwsClientConfig, CLIENT_NAME);
        return new LinkisErrorCodeClient(dwsHttpClient);
    }

    public ErrorCodeClientBuilder setVersion(String version) {
        this.version = version;
        return this;
    }
}

