/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.strategy.async;

import java.io.Serializable;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.orchestrator.conf.OrchestratorConfiguration$;
import org.apache.linkis.orchestrator.core.ResultSet;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorCodeSummary$;
import org.apache.linkis.orchestrator.execution.ArrayResultSetTaskResponse;
import org.apache.linkis.orchestrator.execution.AsyncTaskResponse;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.RetryTaskResponse;
import org.apache.linkis.orchestrator.execution.SucceedTaskResponse;
import org.apache.linkis.orchestrator.execution.TaskResponse;
import org.apache.linkis.orchestrator.execution.impl.DefaultFailedTaskResponse;
import org.apache.linkis.orchestrator.execution.impl.DefaultResultSetTaskResponse;
import org.apache.linkis.orchestrator.listener.execution.ExecTaskRunnerCompletedEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.strategy.ExecTaskStatusInfo;
import org.apache.linkis.orchestrator.strategy.ResultSetExecTask;
import org.apache.linkis.orchestrator.strategy.StatusInfoExecTask;
import org.apache.linkis.orchestrator.strategy.async.AsyncExecTask;
import org.apache.linkis.orchestrator.strategy.async.AsyncExecTaskRunner;
import org.apache.linkis.orchestrator.utils.OrchestratorLoggerUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\u000f\u001e\u0001)B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0005\u0011\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0003\")!\n\u0001C\u0001\u0017\"9a\n\u0001a\u0001\n\u0013y\u0005bB-\u0001\u0001\u0004%IA\u0017\u0005\u0007G\u0002\u0001\u000b\u0015\u0002)\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n\u0013)\u0007\"\u00037\u0001\u0001\u0004\u0005\r\u0011\"\u0003n\u0011%y\u0007\u00011A\u0001B\u0003&a\rC\u0004q\u0001\t\u0007I\u0011B9\t\u000f\u0005\u0005\u0001\u0001)A\u0005e\"I\u00111\u0001\u0001A\u0002\u0013%\u0011Q\u0001\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0005\u0003\u001fA\u0001\"a\u0005\u0001A\u0003&\u0011q\u0001\u0005\u0007\u0003+\u0001A\u0011I3\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!9\u0011\u0011\u0005\u0001\u0005B\u0005e\u0001bBA\u0012\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\tI\u0003\u0001C!\u0003WAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005\r\u0003\u0001\"\u0005\u0002F!9\u0011\u0011\u000b\u0001\u0005B\u0005\u001d\u0002bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\t\t\u0007\u0001C!\u0003G\u0012q#Q:z]\u000e,\u00050Z2UCN\\'+\u001e8oKJLU\u000e\u001d7\u000b\u0005yy\u0012!B1ts:\u001c'B\u0001\u0011\"\u0003!\u0019HO]1uK\u001eL(B\u0001\u0012$\u00031y'o\u00195fgR\u0014\u0018\r^8s\u0015\t!S%\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Y3g\u000e\t\u0003YEj\u0011!\f\u0006\u0003]=\nA\u0001\\1oO*\t\u0001'\u0001\u0003kCZ\f\u0017B\u0001\u001a.\u0005\u0019y%M[3diB\u0011A'N\u0007\u0002;%\u0011a'\b\u0002\u0014\u0003NLhnY#yK\u000e$\u0016m]6Sk:tWM\u001d\t\u0003quj\u0011!\u000f\u0006\u0003um\nQ!\u001e;jYNT!\u0001P\u0012\u0002\r\r|W.\\8o\u0013\tq\u0014HA\u0004M_\u001e<\u0017N\\4\u0002\tQ\f7o[\u000b\u0002\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\ta\"L8/[2bY*\u0011a)I\u0001\u0006a2\fgn]\u0005\u0003\u0011\u000e\u0013\u0001\"\u0012=fGR\u000b7o[\u0001\u0006i\u0006\u001c8\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051k\u0005C\u0001\u001b\u0001\u0011\u0015y4\u00011\u0001B\u0003\u0019\u0019H/\u0019;vgV\t\u0001\u000b\u0005\u0002R/6\t!K\u0003\u0002T)\u00061QM\u001c;jifT!\u0001P+\u000b\u0005Y\u001b\u0013AC4pm\u0016\u0014h.\u00198dK&\u0011\u0001L\u0015\u0002\u0014\u000bb,7-\u001e;j_:tu\u000eZ3Ti\u0006$Xo]\u0001\u000bgR\fG/^:`I\u0015\fHCA.b!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\u0011)f.\u001b;\t\u000f\t,\u0011\u0011!a\u0001!\u0006\u0019\u0001\u0010J\u0019\u0002\u000fM$\u0018\r^;tA\u0005aA/Y:l%\u0016\u001c\bo\u001c8tKV\ta\r\u0005\u0002hU6\t\u0001N\u0003\u0002jC\u0005IQ\r_3dkRLwN\\\u0005\u0003W\"\u0014A\u0002V1tWJ+7\u000f]8og\u0016\f\u0001\u0003^1tWJ+7\u000f]8og\u0016|F%Z9\u0015\u0005ms\u0007b\u00022\t\u0003\u0003\u0005\rAZ\u0001\u000ei\u0006\u001c8NU3ta>t7/\u001a\u0011\u0002\u0015I,7/\u001e7u'\u0016$8/F\u0001s!\r\u0019\bP_\u0007\u0002i*\u0011QO^\u0001\b[V$\u0018M\u00197f\u0015\t9X,\u0001\u0006d_2dWm\u0019;j_:L!!\u001f;\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003wzl\u0011\u0001 \u0006\u0003{\u0006\nAaY8sK&\u0011q\u0010 \u0002\n%\u0016\u001cX\u000f\u001c;TKR\f1B]3tk2$8+\u001a;tA\u0005Q!/Z:vYR\u001c\u0016N_3\u0016\u0005\u0005\u001d\u0001c\u0001/\u0002\n%\u0019\u00111B/\u0003\u0007%sG/\u0001\bsKN,H\u000e^*ju\u0016|F%Z9\u0015\u0007m\u000b\t\u0002\u0003\u0005c\u001b\u0005\u0005\t\u0019AA\u0004\u0003-\u0011Xm];miNK'0\u001a\u0011\u0002\u001f\u001d,G\u000fV1tWJ+7\u000f]8og\u0016\f1\"[:D_6\u0004H.\u001a;fIV\u0011\u00111\u0004\t\u00049\u0006u\u0011bAA\u0010;\n9!i\\8mK\u0006t\u0017!C5t%Vtg.\u001b8h\u0003%I7oU;dG\u0016,G-A\u0002sk:$\u0012aW\u0001\u0010iJ\fgn]5f]R\u001cF/\u0019;vgR\u00191,!\f\t\u000b9#\u0002\u0019\u0001)\u0002%\u00054G/\u001a:Ti\u0006$Xo]\"iC:<W\r\u001a\u000b\u00067\u0006M\u0012q\u0007\u0005\u0007\u0003k)\u0002\u0019\u0001)\u0002\u0015\u0019\u0014x.\\*uCR,8\u000f\u0003\u0004\u0002:U\u0001\r\u0001U\u0001\ti>\u001cF/\u0019;vg\u0006\u0019\"-\u001a4pe\u0016\u001cF/\u0019;vg\u000eC\u0017M\\4fIR)1,a\u0010\u0002B!1\u0011Q\u0007\fA\u0002ACa!!\u000f\u0017\u0001\u0004\u0001\u0016!G5t/\u0006LGOR8s!\u0016\u00148/[:uK\u0012$\u0016.\\3pkR$B!a\u0007\u0002H!9\u0011\u0011J\fA\u0002\u0005-\u0013!G:uCJ$x+Y5u\r>\u0014\b+\u001a:tSN$X\r\u001a+j[\u0016\u00042\u0001XA'\u0013\r\ty%\u0018\u0002\u0005\u0019>tw-A\u0005j]R,'O];qi\u0006i1/\u001a;SKN,H\u000e^*ju\u0016$2aWA,\u0011\u001d\t\u0019!\u0007a\u0001\u0003\u000f\tA\"\u00193e%\u0016\u001cX\u000f\u001c;TKR$2aWA/\u0011\u0019\tyF\u0007a\u0001u\u0006I!/Z:vYR\u001cV\r^\u0001\u000b[\u0006\u00148NR1jY\u0016$G#B.\u0002f\u0005}\u0004bBA47\u0001\u0007\u0011\u0011N\u0001\tKJ\u0014xN]'tOB!\u00111NA=\u001d\u0011\ti'!\u001e\u0011\u0007\u0005=T,\u0004\u0002\u0002r)\u0019\u00111O\u0015\u0002\rq\u0012xn\u001c;?\u0013\r\t9(X\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]T\fC\u0004\u0002\u0002n\u0001\r!a!\u0002\u000b\r\fWo]3\u0011\t\u0005\u0015\u0015q\u0012\b\u0005\u0003\u000f\u000bYI\u0004\u0003\u0002p\u0005%\u0015\"\u00010\n\u0007\u00055U,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00151\u0013\u0002\n)\"\u0014xn^1cY\u0016T1!!$^\u0001")
public class AsyncExecTaskRunnerImpl
implements AsyncExecTaskRunner,
Logging {
    private final ExecTask task;
    private ExecutionNodeStatus status;
    private TaskResponse taskResponse;
    private final ArrayBuffer<ResultSet> resultSets;
    private int resultSize;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AsyncExecTaskRunnerImpl asyncExecTaskRunnerImpl = this;
        synchronized (asyncExecTaskRunnerImpl) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public ExecTask task() {
        return this.task;
    }

    private ExecutionNodeStatus status() {
        return this.status;
    }

    private void status_$eq(ExecutionNodeStatus x$1) {
        this.status = x$1;
    }

    private TaskResponse taskResponse() {
        return this.taskResponse;
    }

    private void taskResponse_$eq(TaskResponse x$1) {
        this.taskResponse = x$1;
    }

    private ArrayBuffer<ResultSet> resultSets() {
        return this.resultSets;
    }

    private int resultSize() {
        return this.resultSize;
    }

    private void resultSize_$eq(int x$1) {
        this.resultSize = x$1;
    }

    @Override
    public TaskResponse getTaskResponse() {
        return this.taskResponse();
    }

    @Override
    public boolean isCompleted() {
        return ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)this.status());
    }

    @Override
    public boolean isRunning() {
        return ExecutionNodeStatus.isRunning((ExecutionNodeStatus)this.status());
    }

    @Override
    public boolean isSucceed() {
        return ExecutionNodeStatus.isScheduled((ExecutionNodeStatus)this.status());
    }

    @Override
    public void run() {
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            OrchestratorLoggerUtils$.MODULE$.setJobIdMDC(this.task());
            this.logger().info(new StringBuilder(43).append("ExecTaskRunner Submit execTask(").append(this.task().getIDInfo()).append(") to running").toString());
            TaskResponse response = this.task().execute();
            this.taskResponse_$eq(response);
            TaskResponse taskResponse = response;
            if (taskResponse instanceof AsyncTaskResponse) {
                this.transientStatus(ExecutionNodeStatus.Running);
                return;
            }
            if (taskResponse instanceof SucceedTaskResponse) {
                this.logger().info(new StringBuilder(29).append("Succeed to execute ExecTask(").append(this.task().getIDInfo()).append(")").toString());
                this.transientStatus(ExecutionNodeStatus.Succeed);
                return;
            }
            if (taskResponse instanceof FailedTaskResponse) {
                this.logger().info(new StringBuilder(28).append("Failed to execute ExecTask(").append(this.task().getIDInfo()).append(")").toString());
                this.transientStatus(ExecutionNodeStatus.Failed);
                return;
            }
            if (taskResponse instanceof RetryTaskResponse) {
                this.logger().warn(new StringBuilder(24).append("ExecTask(").append(this.task().getIDInfo()).append(") need to retry").toString());
                this.transientStatus(ExecutionNodeStatus.WaitForRetry);
                return;
            }
            throw new MatchError((Object)taskResponse);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            AsyncExecTaskRunnerImpl.$anonfun$run$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        OrchestratorLoggerUtils$.MODULE$.removeJobIdMDC();
    }

    @Override
    public void transientStatus(ExecutionNodeStatus status) {
        if (status.ordinal() < this.status().ordinal()) {
            ExecutionNodeStatus executionNodeStatus = status;
            ExecutionNodeStatus executionNodeStatus2 = ExecutionNodeStatus.WaitForRetry;
            if (executionNodeStatus == null ? executionNodeStatus2 != null : !executionNodeStatus.equals(executionNodeStatus2)) {
                this.logger().info(new StringBuilder(56).append("Task").append(this.task().getIDInfo()).append(" status flip error! Cause: Failed to flip from ").append(this.status()).append(" to ").append(status).append(".").toString());
                return;
            }
        }
        this.logger().info(new StringBuilder(20).append(this.task().getIDInfo()).append(" change status ").append(this.status()).append(" => ").append(status).append(".").toString());
        this.beforeStatusChanged(this.status(), status);
        ExecutionNodeStatus oldStatus = this.status();
        this.status_$eq(status);
        this.afterStatusChanged(oldStatus, status);
    }

    public void afterStatusChanged(ExecutionNodeStatus fromStatus, ExecutionNodeStatus toStatus) {
        if (ExecutionNodeStatus.isSucceed((ExecutionNodeStatus)toStatus)) {
            ExecTask execTask = this.task();
            if (execTask instanceof ResultSetExecTask) {
                TaskResponse taskResponse;
                ResultSetExecTask resultSetExecTask = (ResultSetExecTask)execTask;
                if (this.resultSets().nonEmpty()) {
                    this.taskResponse_$eq(new DefaultResultSetTaskResponse((ResultSet[])this.resultSets().toArray(ClassTag$.MODULE$.apply(ResultSet.class))));
                }
                if ((taskResponse = this.taskResponse()) instanceof ArrayResultSetTaskResponse) {
                    ArrayResultSetTaskResponse arrayResultSetTaskResponse = (ArrayResultSetTaskResponse)taskResponse;
                    resultSetExecTask.addResultSet(arrayResultSetTaskResponse);
                }
            }
        }
        if (ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)toStatus)) {
            ExecTask execTask = this.task();
            if (execTask instanceof StatusInfoExecTask) {
                StatusInfoExecTask statusInfoExecTask = (StatusInfoExecTask)execTask;
                statusInfoExecTask.addExecTaskStatusInfo(new ExecTaskStatusInfo(toStatus, this.taskResponse()));
            }
            ExecTask execTask2 = this.task();
            if (execTask2 instanceof AsyncExecTask) {
                AsyncExecTask asyncExecTask = (AsyncExecTask)execTask2;
                asyncExecTask.clear(ExecutionNodeStatus.isSucceed((ExecutionNodeStatus)toStatus));
            }
            this.task().getPhysicalContext().broadcastSyncEvent(new ExecTaskRunnerCompletedEvent(this));
            return;
        }
    }

    public void beforeStatusChanged(ExecutionNodeStatus fromStatus, ExecutionNodeStatus toStatus) {
        ExecTask execTask = this.task();
        if (execTask instanceof AsyncExecTask) {
            if (ExecutionNodeStatus.isSucceed((ExecutionNodeStatus)toStatus) && (this.resultSize() < 0 || this.resultSets().size() < this.resultSize())) {
                long startWaitForPersistedTime = System.currentTimeMillis();
                ArrayBuffer<ResultSet> arrayBuffer = this.resultSets();
                synchronized (arrayBuffer) {
                    while (!(this.resultSize() >= 0 && this.resultSets().size() >= this.resultSize() || this.isWaitForPersistedTimeout(startWaitForPersistedTime))) {
                        this.resultSets().wait(1000L);
                    }
                }
                return;
            }
            return;
        }
    }

    public boolean isWaitForPersistedTimeout(long startWaitForPersistedTime) {
        return System.currentTimeMillis() - startWaitForPersistedTime >= ((TimeType)OrchestratorConfiguration$.MODULE$.TASK_MAX_PERSIST_WAIT_TIME().getValue()).toLong();
    }

    @Override
    public void interrupt() {
        this.markFailed("Job be cancelled", null);
        ExecTask execTask = this.task();
        if (execTask instanceof AsyncExecTask) {
            AsyncExecTask asyncExecTask = (AsyncExecTask)execTask;
            asyncExecTask.kill();
        }
        this.transientStatus(ExecutionNodeStatus.Cancelled);
    }

    @Override
    public void setResultSize(int resultSize) {
        this.logger().info(new StringBuilder(39).append("BaseExecTaskRunner ").append(this.task().getIDInfo()).append(" get result size is ").append(resultSize).toString());
        if (this.resultSize() == -1) {
            this.resultSize_$eq(resultSize);
        }
        this.resultSets().notify();
    }

    @Override
    public void addResultSet(ResultSet resultSet) {
        this.logger().info(new StringBuilder(44).append("BaseExecTaskRunner ").append(this.task().getIDInfo()).append(" get result, now size is ").append(this.resultSets().size()).toString());
        this.resultSets().$plus$eq((Object)resultSet);
        this.resultSets().notify();
    }

    @Override
    public void markFailed(String errorMsg, Throwable cause) {
        this.taskResponse_$eq(new DefaultFailedTaskResponse(errorMsg, OrchestratorErrorCodeSummary$.MODULE$.EXECUTION_ERROR_CODE(), cause));
    }

    public static final /* synthetic */ void $anonfun$run$2(AsyncExecTaskRunnerImpl $this, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable != null) {
            Throwable throwable2 = throwable;
            $this.logger().error(new StringBuilder(23).append("Failed to execute task ").append($this.task().getIDInfo()).toString(), throwable2);
            $this.taskResponse_$eq(new DefaultFailedTaskResponse(throwable2.getMessage(), OrchestratorErrorCodeSummary$.MODULE$.EXECUTION_ERROR_CODE(), throwable2));
            $this.transientStatus(ExecutionNodeStatus.Failed);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public AsyncExecTaskRunnerImpl(ExecTask task) {
        this.task = task;
        Logging.$init$((Logging)this);
        this.status = ExecutionNodeStatus.Inited;
        this.resultSets = new ArrayBuffer();
        this.resultSize = -1;
    }
}

