/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.execution.impl;

import java.io.Serializable;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.orchestrator.domain.Node;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorCodeSummary$;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorException;
import org.apache.linkis.orchestrator.execution.CompletedTaskResponse;
import org.apache.linkis.orchestrator.execution.ExecutionTask;
import org.apache.linkis.orchestrator.execution.SucceedTaskResponse;
import org.apache.linkis.orchestrator.execution.TaskResponse;
import org.apache.linkis.orchestrator.execution.impl.DefaultFailedTaskResponse;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.utils.OrchestratorIDCreator;
import org.apache.linkis.orchestrator.utils.OrchestratorIDCreator$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\u0010 \u00011B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")A\n\u0001C\u0001\u001b\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006B\u0002.\u0001A\u0003%A\u000bC\u0004\\\u0001\t\u0007I\u0011\u0002/\t\re\u0004\u0001\u0015!\u0003^\u0011\u001dQ\b\u00011A\u0005\nmD\u0011\"a\u0003\u0001\u0001\u0004%I!!\u0004\t\u000f\u0005e\u0001\u0001)Q\u0005y\"Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%I!a\n\t\u0017\u0005-\u0002\u00011A\u0001B\u0003&\u0011q\u0004\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0003C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0003bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003cAq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002N\u0001!\t%a\u0014\t\r\u0005E\u0003\u0001\"\u0011|\u0011\u001d\t\u0019\u0006\u0001C!\u0003+Bq!a\u0017\u0001\t\u0003\ni\u0006C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u0011\u0011\u000f\u0001\u0005B\u0005u\u0001bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003w\u0002A\u0011IA\u0018\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002\u0016\u0002!\t%a&\u0003#\t\u000b7/Z#yK\u000e,H/[8o)\u0006\u001c8N\u0003\u0002!C\u0005!\u0011.\u001c9m\u0015\t\u00113%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011A%J\u0001\r_J\u001c\u0007.Z:ue\u0006$xN\u001d\u0006\u0003M\u001d\na\u0001\\5oW&\u001c(B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001[M:\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0005\u00025k5\t\u0011%\u0003\u00027C\tiQ\t_3dkRLwN\u001c+bg.\u0004\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u000bU$\u0018\u000e\\:\u000b\u0005q*\u0013AB2p[6|g.\u0003\u0002?s\t9Aj\\4hS:<\u0017AD7bqB\u000b'/\u00197mK2L7/\u001c\t\u0003]\u0005K!AQ\u0018\u0003\u0007%sG/\u0001\u0007s_>$X\t_3d)\u0006\u001c8\u000e\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006A\u0001\u000f[=tS\u000e\fGN\u0003\u0002JG\u0005)\u0001\u000f\\1og&\u00111J\u0012\u0002\t\u000bb,7\rV1tW\u00061A(\u001b8jiz\"2A\u0014)R!\ty\u0005!D\u0001 \u0011\u0015y4\u00011\u0001A\u0011\u0015\u00195\u00011\u0001E\u0003!9\u0018-\u001b;M_\u000e\\W#\u0001+\u0011\u00079*v+\u0003\u0002W_\t)\u0011I\u001d:bsB\u0011a\u0006W\u0005\u00033>\u0012AAQ=uK\u0006Iq/Y5u\u0019>\u001c7\u000eI\u0001\nY&\u001cH/\u001a8feN,\u0012!\u0018\t\u0004=\u000e,W\"A0\u000b\u0005\u0001\f\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003E>\n!bY8mY\u0016\u001cG/[8o\u0013\t!wLA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u00014w\u001d\t9GO\u0004\u0002ig:\u0011\u0011N\u001d\b\u0003UFt!a\u001b9\u000f\u00051|W\"A7\u000b\u00059\\\u0013A\u0002\u001fs_>$h(C\u0001+\u0013\tA\u0013&\u0003\u0002'O%\u0011A%J\u0005\u0003E\rJ!!^\u0011\u0002#\u0005\u001b\u0018P\\2UCN\\'+Z:q_:\u001cX-\u0003\u0002xq\nqaj\u001c;jMfd\u0015n\u001d;f]\u0016\u0014(BA;\"\u0003)a\u0017n\u001d;f]\u0016\u00148\u000fI\u0001\u0007gR\fG/^:\u0016\u0003q\u00042!`A\u0004\u001b\u0005q(bA@\u0002\u0002\u00051QM\u001c;jifT1\u0001PA\u0002\u0015\r\t)!J\u0001\u000bO>4XM\u001d8b]\u000e,\u0017bAA\u0005}\n\u0019R\t_3dkRLwN\u001c(pI\u0016\u001cF/\u0019;vg\u0006Q1\u000f^1ukN|F%Z9\u0015\t\u0005=\u0011Q\u0003\t\u0004]\u0005E\u0011bAA\n_\t!QK\\5u\u0011!\t9\"CA\u0001\u0002\u0004a\u0018a\u0001=%c\u000591\u000f^1ukN\u0004\u0013\u0001\u0003:fgB|gn]3\u0016\u0005\u0005}\u0001c\u0001\u001b\u0002\"%\u0019\u00111E\u0011\u0003\u0019Q\u000b7o\u001b*fgB|gn]3\u0002\u0019I,7\u000f]8og\u0016|F%Z9\u0015\t\u0005=\u0011\u0011\u0006\u0005\n\u0003/a\u0011\u0011!a\u0001\u0003?\t\u0011B]3ta>t7/\u001a\u0011\u0002\u0005%$WCAA\u0019!\u0011\t\u0019$a\u000f\u000f\t\u0005U\u0012q\u0007\t\u0003Y>J1!!\u000f0\u0003\u0019\u0001&/\u001a3fM&!\u0011QHA \u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011H\u0018\u0002\r%$w\fJ3r)\u0011\ty!!\u0012\t\u0013\u0005]q\"!AA\u0002\u0005E\u0012aA5eA\u0005\tr-\u001a;NCb\u0004\u0016M]1mY\u0016d\u0017n]7\u0016\u0003\u0001\u000b\u0001c^1ji\u001a{'oQ8na2,G/\u001a3\u0015\u0005\u0005=\u0011!C4fiN#\u0018\r^;t\u0003!qw\u000e^5gs6+G\u0003BA\b\u0003/Ba!!\u0017\u0015\u0001\u0004)\u0017\u0001\u00037jgR,g.\u001a:\u0002\u001f\u001d,GOU8pi\u0016CXm\u0019+bg.,\u0012\u0001R\u0001\u0010iJ\fgn]5f]R\u001cF/\u0019;vgR!\u0011qBA2\u0011\u0015Qh\u00031\u0001}\u0003I\tg\r^3s'R\fG/^:DQ\u0006tw-\u001a3\u0015\r\u0005=\u0011\u0011NA7\u0011\u0019\tYg\u0006a\u0001y\u0006QaM]8n'R\fG/^:\t\r\u0005=t\u00031\u0001}\u0003!!xn\u0015;biV\u001c\u0018aC4fiJ+7\u000f]8og\u0016\f1CY3g_J,7\u000b^1ukN\u001c\u0005.\u00198hK\u0012$b!a\u0004\u0002x\u0005e\u0004BBA63\u0001\u0007A\u0010\u0003\u0004\u0002pe\u0001\r\u0001`\u0001\u0006O\u0016$\u0018\nZ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0005\u0015q\u0011\t\u0004]\u0005\r\u0015bAAC_\t9!i\\8mK\u0006t\u0007bBAE7\u0001\u0007\u00111R\u0001\u0004_\nT\u0007c\u0001\u0018\u0002\u000e&\u0019\u0011qR\u0018\u0003\u0007\u0005s\u00170\u0001\u0005iCND7i\u001c3f)\u0005\u0001\u0015!D7be.\u001cu.\u001c9mKR,G\r\u0006\u0003\u0002\u0010\u0005e\u0005bBAN;\u0001\u0007\u0011QT\u0001\u001ai\u0006\u001c8nQ8na2,G/\u001a3UCN\\'+Z:q_:\u001cX\rE\u00025\u0003?K1!!)\"\u0005U\u0019u.\u001c9mKR,G\rV1tWJ+7\u000f]8og\u0016\u0004")
public class BaseExecutionTask
implements ExecutionTask,
Logging {
    private final int maxParallelism;
    private final ExecTask rootExecTask;
    private final byte[] waitLock;
    private final ArrayBuffer<Function1<TaskResponse, BoxedUnit>> listeners;
    private ExecutionNodeStatus status;
    private TaskResponse response;
    private String id;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public String getName() {
        return Node.getName$(this);
    }

    private Logger logger$lzycompute() {
        BaseExecutionTask baseExecutionTask = this;
        synchronized (baseExecutionTask) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private byte[] waitLock() {
        return this.waitLock;
    }

    private ArrayBuffer<Function1<TaskResponse, BoxedUnit>> listeners() {
        return this.listeners;
    }

    private ExecutionNodeStatus status() {
        return this.status;
    }

    private void status_$eq(ExecutionNodeStatus x$1) {
        this.status = x$1;
    }

    private TaskResponse response() {
        return this.response;
    }

    private void response_$eq(TaskResponse x$1) {
        this.response = x$1;
    }

    private String id() {
        return this.id;
    }

    private void id_$eq(String x$1) {
        this.id = x$1;
    }

    @Override
    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    @Override
    public void waitForCompleted() {
        if (ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)this.getStatus())) {
            return;
        }
        byte[] byArray = this.waitLock();
        synchronized (byArray) {
            while (!ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)this.getStatus())) {
                this.waitLock().wait();
            }
        }
    }

    @Override
    public ExecutionNodeStatus getStatus() {
        return this.status();
    }

    @Override
    public void notifyMe(Function1<TaskResponse, BoxedUnit> listener) {
        this.listeners().$plus$eq(listener);
    }

    @Override
    public ExecTask getRootExecTask() {
        return this.rootExecTask;
    }

    @Override
    public void transientStatus(ExecutionNodeStatus status) {
        if (status.ordinal() < this.status().ordinal()) {
            ExecutionNodeStatus executionNodeStatus = status;
            ExecutionNodeStatus executionNodeStatus2 = ExecutionNodeStatus.WaitForRetry;
            if (executionNodeStatus == null ? executionNodeStatus2 != null : !executionNodeStatus.equals(executionNodeStatus2)) {
                throw new OrchestratorErrorException(OrchestratorErrorCodeSummary$.MODULE$.EXECUTION_FOR_EXECUTION_ERROR_CODE(), new StringBuilder(56).append("Task status flip error! Cause: Failed to flip from ").append(this.status()).append(" to ").append(status).append(".").toString());
            }
        }
        this.logger().info(new StringBuilder(20).append(this.getId()).append(" change status ").append(this.status()).append(" => ").append(status).append(".").toString());
        this.beforeStatusChanged(this.status(), status);
        ExecutionNodeStatus oldStatus = this.status();
        this.status_$eq(status);
        this.afterStatusChanged(oldStatus, status);
    }

    public void afterStatusChanged(ExecutionNodeStatus fromStatus, ExecutionNodeStatus toStatus) {
        if (ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)toStatus)) {
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.listeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
                listener.apply((Object)this.getResponse());
                return BoxedUnit.UNIT;
            }), this.logger());
            byte[] byArray = this.waitLock();
            synchronized (byArray) {
                this.waitLock().notify();
            }
            return;
        }
    }

    @Override
    public TaskResponse getResponse() {
        return this.response();
    }

    public void beforeStatusChanged(ExecutionNodeStatus fromStatus, ExecutionNodeStatus toStatus) {
    }

    @Override
    public String getId() {
        if (this.id() == null) {
            BaseExecutionTask baseExecutionTask = this;
            synchronized (baseExecutionTask) {
                if (this.id() == null) {
                    OrchestratorIDCreator qual$1 = OrchestratorIDCreator$.MODULE$.getExecutionIDCreator();
                    String x$1 = "execution";
                    String x$2 = qual$1.nextID$default$2();
                    this.id_$eq(qual$1.nextID(x$1, x$2));
                }
            }
        }
        return this.id();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ExecutionTask) {
            String string = ((ExecutionTask)obj).getId();
            String string2 = this.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public void markCompleted(CompletedTaskResponse taskCompletedTaskResponse) {
        this.response_$eq(taskCompletedTaskResponse);
        CompletedTaskResponse completedTaskResponse = taskCompletedTaskResponse;
        if (completedTaskResponse instanceof DefaultFailedTaskResponse) {
            this.transientStatus(ExecutionNodeStatus.Failed);
        } else if (completedTaskResponse instanceof SucceedTaskResponse) {
            this.transientStatus(ExecutionNodeStatus.Succeed);
        } else {
            throw new MatchError((Object)completedTaskResponse);
        }
        this.logger().info(new StringBuilder(40).append("Finished to ExecutionTask(").append(this.getId()).append(") with status ").append(this.getStatus()).toString());
    }

    public BaseExecutionTask(int maxParallelism, ExecTask rootExecTask) {
        this.maxParallelism = maxParallelism;
        this.rootExecTask = rootExecTask;
        Node.$init$(this);
        Logging.$init$((Logging)this);
        this.waitLock = new byte[0];
        this.listeners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.status = ExecutionNodeStatus.Inited;
    }
}

