/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class GzipEncodingEnforcingFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if ("GET".equals(httpRequest.getMethod())) {
            String acceptEncoding = httpRequest.getHeader("Accept-Encoding");
            if (acceptEncoding == null) {
                chain.doFilter((ServletRequest)GzipEncodingEnforcingFilter.addGzipAcceptEncoding(httpRequest), response);
                return;
            }
            if (!acceptEncoding.contains("gzip")) {
                ((HttpServletResponse)response).setStatus(406);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private static HttpServletRequest addGzipAcceptEncoding(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){

            public Enumeration<String> getHeaders(String name) {
                if ("Accept-Encoding".equals(name)) {
                    return new EnumWrapper<String>("gzip");
                }
                return super.getHeaders(name);
            }

            public Enumeration<String> getHeaderNames() {
                return new EnumWrapper<String>(super.getHeaderNames(), "Accept-Encoding");
            }

            public String getHeader(String name) {
                if ("Accept-Encoding".equals(name)) {
                    return "gzip";
                }
                return super.getHeader(name);
            }
        };
    }

    private static class EnumWrapper<E>
    implements Enumeration<E> {
        private final Enumeration<E> delegate;
        private final AtomicReference<E> extraElementRef;

        private EnumWrapper(E extraElement) {
            this(null, extraElement);
        }

        private EnumWrapper(Enumeration<E> delegate, E extraElement) {
            this.delegate = delegate;
            this.extraElementRef = new AtomicReference<E>(extraElement);
        }

        @Override
        public boolean hasMoreElements() {
            return this.extraElementRef.get() != null || this.delegate != null && this.delegate.hasMoreElements();
        }

        @Override
        public E nextElement() {
            E extra = this.extraElementRef.getAndSet(null);
            if (extra != null) {
                return extra;
            }
            if (this.delegate == null) {
                throw new NoSuchElementException();
            }
            return this.delegate.nextElement();
        }
    }
}

