/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.exception.FatalException;
import org.apache.linkis.common.exception.LinkisCommonErrorException;
import org.apache.linkis.common.exception.WarnException;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.ShutdownHookManager$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

public final class Utils$
implements Logging {
    public static Utils$ MODULE$;
    private final String DEFAULE_SCHEDULER_THREAD_NAME_PREFIX;
    private final ScheduledThreadPoolExecutor defaultScheduler;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Utils$();
    }

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$(this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$(this, message);
    }

    private Logger logger$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String DEFAULE_SCHEDULER_THREAD_NAME_PREFIX() {
        return this.DEFAULE_SCHEDULER_THREAD_NAME_PREFIX;
    }

    public <T> T tryQuietly(Function0<T> tryOp) {
        return this.tryQuietly(tryOp, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            Utils$.$anonfun$tryQuietly$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public <T> T tryCatch(Function0<T> tryOp, Function1<Throwable, T> catchOp) {
        Object object;
        block7: {
            try {
                object = tryOp.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                    throw (Throwable)controlThrowable;
                }
                if (throwable2 instanceof FatalException) {
                    FatalException fatalException = (FatalException)throwable2;
                    this.logger().error("Fatal error, system exit...", (Throwable)fatalException);
                    System.exit(fatalException.getErrCode());
                    object = null;
                    break block7;
                }
                if (throwable2 instanceof VirtualMachineError) {
                    VirtualMachineError virtualMachineError = (VirtualMachineError)throwable2;
                    this.logger().error("Fatal error, system exit...", (Throwable)virtualMachineError);
                    System.exit(-1);
                    throw virtualMachineError;
                }
                if (throwable2.getCause() != null && (throwable2.getCause() instanceof FatalException || throwable2.getCause() instanceof VirtualMachineError)) {
                    this.logger().error("Caused by fatal error, system exit...", throwable2);
                    System.exit(-1);
                    throw throwable2;
                }
                if (throwable2 instanceof Error) {
                    Error error = (Error)throwable2;
                    this.logger().error("Throw error", (Throwable)error);
                    throw error;
                }
                object = catchOp.apply((Object)throwable2);
            }
        }
        return (T)object;
    }

    public <T> T tryThrow(Function0<T> tryOp, Function1<Throwable, Throwable> exception) {
        return this.tryCatch(tryOp, (Function1 & Serializable & scala.Serializable)t -> {
            throw (Throwable)exception.apply(t);
        });
    }

    public <T> T tryFinally(Function0<T> tryOp, Function0<BoxedUnit> finallyOp) {
        Object object;
        try {
            object = tryOp.apply();
        }
        finally {
            finallyOp.apply$mcV$sp();
        }
        return (T)object;
    }

    public <T> T tryQuietly(Function0<T> tryOp, Function1<Throwable, BoxedUnit> catchOp) {
        return this.tryCatch(tryOp, (Function1 & Serializable & scala.Serializable)t -> {
            catchOp.apply(t);
            return null;
        });
    }

    public <T> T tryAndWarn(Function0<T> tryOp, Logger log) {
        return this.tryCatch(tryOp, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ErrorException) {
                ErrorException errorException = (ErrorException)throwable;
                String errorMsg = new StringBuilder(41).append("error code\uff08\u9519\u8bef\u7801\uff09: ").append(errorException.getErrCode()).append(", Error message\uff08\u9519\u8bef\u4fe1\u606f\uff09: ").append(errorException.getDesc()).append(".").toString();
                log.error(errorMsg, (Throwable)errorException);
                return null;
            }
            if (throwable instanceof WarnException) {
                WarnException warnException = (WarnException)throwable;
                String warnMsg = new StringBuilder(45).append("Warning code\uff08\u8b66\u544a\u7801\uff09: ").append(warnException.getErrCode()).append(", Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: ").append(warnException.getDesc()).append(".").toString();
                log.warn(warnMsg, (Throwable)warnException);
                return null;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                log.warn("", throwable2);
                return null;
            }
            throw new MatchError((Object)throwable);
        });
    }

    public <T> T tryAndWarnMsg(Function0<T> tryOp, String message, Logger log) {
        return this.tryCatch(tryOp, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ErrorException) {
                ErrorException errorException = (ErrorException)throwable;
                log.warn(new StringBuilder(41).append("error code\uff08\u9519\u8bef\u7801\uff09: ").append(errorException.getErrCode()).append(", Error message\uff08\u9519\u8bef\u4fe1\u606f\uff09: ").append(errorException.getDesc()).append(".").toString());
                log.warn(message, (Throwable)errorException);
                return null;
            }
            if (throwable instanceof WarnException) {
                WarnException warnException = (WarnException)throwable;
                log.warn(new StringBuilder(45).append("Warning code\uff08\u8b66\u544a\u7801\uff09: ").append(warnException.getErrCode()).append(", Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: ").append(warnException.getDesc()).append(".").toString());
                log.warn(message, (Throwable)warnException);
                return null;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                log.warn(message, throwable2);
                return null;
            }
            throw new MatchError((Object)throwable);
        });
    }

    public <T> T tryAndError(Function0<T> tryOp, Logger log) {
        return this.tryCatch(tryOp, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ErrorException) {
                ErrorException errorException = (ErrorException)throwable;
                String errorMsg = new StringBuilder(41).append("error code\uff08\u9519\u8bef\u7801\uff09: ").append(errorException.getErrCode()).append(", Error message\uff08\u9519\u8bef\u4fe1\u606f\uff09: ").append(errorException.getDesc()).append(".").toString();
                log.error(errorMsg, (Throwable)errorException);
                return null;
            }
            if (throwable instanceof WarnException) {
                WarnException warnException = (WarnException)throwable;
                String warnMsg = new StringBuilder(45).append("Warning code\uff08\u8b66\u544a\u7801\uff09: ").append(warnException.getErrCode()).append(", Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: ").append(warnException.getDesc()).append(".").toString();
                log.warn(warnMsg, (Throwable)warnException);
                return null;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                log.error("", throwable2);
                return null;
            }
            throw new MatchError((Object)throwable);
        });
    }

    public <T> T tryAndErrorMsg(Function0<T> tryOp, String message, Logger log) {
        return this.tryCatch(tryOp, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ErrorException) {
                ErrorException errorException = (ErrorException)throwable;
                log.error(new StringBuilder(41).append("error code\uff08\u9519\u8bef\u7801\uff09: ").append(errorException.getErrCode()).append(", Error message\uff08\u9519\u8bef\u4fe1\u606f\uff09: ").append(errorException.getDesc()).append(".").toString());
                log.error(message, (Throwable)errorException);
                return null;
            }
            if (throwable instanceof WarnException) {
                WarnException warnException = (WarnException)throwable;
                log.warn(new StringBuilder(45).append("Warning code\uff08\u8b66\u544a\u7801\uff09: ").append(warnException.getErrCode()).append(", Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: ").append(warnException.getDesc()).append(".").toString());
                log.warn(message, (Throwable)warnException);
                return null;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                log.error(message, throwable2);
                return null;
            }
            throw new MatchError((Object)throwable);
        });
    }

    public void sleepQuietly(long mills) {
        this.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(mills));
    }

    public ThreadFactory threadFactory(String threadName, boolean isDaemon) {
        return new ThreadFactory(isDaemon, threadName){
            private final AtomicInteger num;
            private final boolean isDaemon$1;
            private final String threadName$1;

            private AtomicInteger num() {
                return this.num;
            }

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(this.isDaemon$1);
                t.setName(new StringBuilder(0).append(this.threadName$1).append(this.num().incrementAndGet()).toString());
                return t;
            }
            {
                this.isDaemon$1 = isDaemon$1;
                this.threadName$1 = threadName$1;
                this.num = new AtomicInteger(0);
            }
        };
    }

    public boolean threadFactory$default$2() {
        return true;
    }

    public ThreadPoolExecutor newCachedThreadPool(int threadNum, String threadName, boolean isDaemon) {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(threadNum, threadNum, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10 * threadNum), this.threadFactory(threadName, isDaemon));
        threadPool.allowCoreThreadTimeOut(true);
        return threadPool;
    }

    public boolean newCachedThreadPool$default$3() {
        return true;
    }

    public ExecutionContextExecutorService newCachedExecutionContext(int threadNum, String threadName, boolean isDaemon) {
        return ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.newCachedThreadPool(threadNum, threadName, isDaemon));
    }

    public boolean newCachedExecutionContext$default$3() {
        return true;
    }

    public ExecutorService newFixedThreadPool(int threadNum, String threadName, boolean isDaemon) {
        return Executors.newFixedThreadPool(threadNum, this.threadFactory(threadName, isDaemon));
    }

    public boolean newFixedThreadPool$default$3() {
        return true;
    }

    public ExecutionContextExecutorService newFixedExecutionContext(int threadNum, String threadName, boolean isDaemon) {
        return ExecutionContext$.MODULE$.fromExecutorService(this.newFixedThreadPool(threadNum, threadName, isDaemon));
    }

    public boolean newFixedExecutionContext$default$3() {
        return true;
    }

    public ScheduledThreadPoolExecutor defaultScheduler() {
        return this.defaultScheduler;
    }

    public String getLocalHostname() {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public String getComputerName() {
        return (String)this.tryCatch((Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost().getCanonicalHostName(), (Function1 & Serializable & scala.Serializable)x$2 -> SystemUtils.getHostName());
    }

    public final void waitUntil(Function0<Object> checkForEvent, Duration atMost, int radix, long maxPeriod) throws TimeoutException, InterruptedException {
        long l;
        try {
            l = System.currentTimeMillis() + atMost.toMillis();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            l = 0L;
        }
        long endTime = l;
        this.aux$1(1, checkForEvent, endTime, radix, maxPeriod);
    }

    public final void waitUntil(Function0<Object> checkForEvent, Duration atMost) {
        this.waitUntil(checkForEvent, atMost, 100, 2000L);
    }

    public String exec(String[] commandLine) {
        return this.exec(commandLine, -1L);
    }

    public String exec(List<String> commandLine) {
        return this.exec(commandLine, -1L);
    }

    public String exec(String[] commandLine, long maxWaitTime) {
        return this.exec((List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commandLine)).toList(), maxWaitTime);
    }

    public String exec(List<String> commandLine, long maxWaitTime) {
        int n;
        ProcessBuilder pb = new ProcessBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(commandLine).asJava());
        pb.redirectErrorStream(true);
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        Process process = pb.start();
        BufferedReader log = new BufferedReader(new InputStreamReader(process.getInputStream()));
        if (maxWaitTime > 0L) {
            boolean completed = process.waitFor(maxWaitTime, TimeUnit.MILLISECONDS);
            if (!completed) {
                IOUtils.closeQuietly((Reader)log);
                process.destroy();
                throw new TimeoutException(new StringBuilder(19).append("exec timeout with ").append(ByteTimeUtils.msDurationToString(maxWaitTime)).append("!").toString());
            }
            n = process.exitValue();
        } else {
            n = BoxesRunTime.unboxToInt(this.tryThrow((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> process.waitFor(), (Function1<Throwable, Throwable>)(Function1 & Serializable & scala.Serializable)t -> {
                process.destroy();
                IOUtils.closeQuietly((Reader)log);
                return t;
            }));
        }
        int exitCode = n;
        Object[] lines = log.lines().toArray();
        IOUtils.closeQuietly((Reader)log);
        if (exitCode != 0) {
            throw new LinkisCommonErrorException(0, new StringBuilder(30).append("exec failed with exit code: ").append(exitCode).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(lines)).mkString(". ")).toString());
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(lines)).mkString("\n");
    }

    public void addShutdownHook(Function0<BoxedUnit> hook) {
        ShutdownHookManager$.MODULE$.addShutdownHook(hook);
    }

    public <T> T getClassInstance(String className) {
        return this.tryThrow((Function0 & Serializable & scala.Serializable)() -> Thread.currentThread().getContextClassLoader().loadClass(className).newInstance(), (Function1<Throwable, Throwable>)(Function1 & Serializable & scala.Serializable)t -> {
            MODULE$.logger().error(new StringBuilder(21).append("Failed to instance: ").append(className).append(" ").toString(), t);
            throw t;
        });
    }

    public String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        long l = ms;
        if (l < (long)second) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)}));
        }
        if (l < (long)minute) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f \u79d2")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))}));
        }
        if (l < (long)hour) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f \u5206\u949f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))}));
        }
        return new StringOps(Predef$.MODULE$.augmentString("%.2f \u5c0f\u65f6")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}));
    }

    public String getJvmUser() {
        return System.getProperty("user.name");
    }

    public String getProcessId() {
        int index;
        String jvmName;
        block0: {
            jvmName = ManagementFactory.getRuntimeMXBean().getName();
            index = jvmName.indexOf(64);
            if (index >= 1) break block0;
        }
        return (String)this.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            String getpid = jvmName.substring(0, index);
            MODULE$.logger().info(new StringBuilder(20).append("get java process Id:").append(getpid).toString());
            return getpid;
        }, (Function1 & Serializable & scala.Serializable)t -> {
            MODULE$.logger().info("Failed to get process Id with error", new Object[]{t.getMessage()});
            return null;
        });
    }

    public static final /* synthetic */ void $anonfun$tryQuietly$1(Throwable x$1) {
    }

    private final void aux$1(int count, Function0 checkForEvent$1, long endTime$1, int radix$1, long maxPeriod$1) {
        while (!checkForEvent$1.apply$mcZ$sp()) {
            long now = System.currentTimeMillis();
            if (endTime$1 == 0L || now < endTime$1) {
                long sleepTime = Math.max(Math.min((long)(radix$1 * count), maxPeriod$1), 100L);
                Thread.sleep(sleepTime);
                ++count;
                continue;
            }
            throw new TimeoutException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Utils$() {
        void var1_1;
        MODULE$ = this;
        Logging.$init$(this);
        this.DEFAULE_SCHEDULER_THREAD_NAME_PREFIX = "Linkis-Default-Scheduler-Thread-";
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(20, this.threadFactory(this.DEFAULE_SCHEDULER_THREAD_NAME_PREFIX(), true));
        scheduler.setMaximumPoolSize(20);
        scheduler.setKeepAliveTime(5L, TimeUnit.MINUTES);
        this.defaultScheduler = var1_1;
    }
}

