/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.util;

import java.io.File;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.linkis.metadata.util.DWSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtils {
    static Logger logger = LoggerFactory.getLogger(HiveUtils.class);

    public static Configuration getDefaultConf(String userName) {
        Configuration conf = new Configuration();
        String hiveConfPath = (String)DWSConfig.HIVE_CONF_DIR.getValue();
        if (StringUtils.isNotEmpty((CharSequence)hiveConfPath)) {
            logger.info("Load hive configuration from " + hiveConfPath);
            conf.addResource(new Path(hiveConfPath + File.separator + "hive-site.xml"));
        } else {
            conf.addResource("hive-site.xml");
        }
        return conf;
    }

    public static String decode(String str) {
        Base64.Decoder decoder = Base64.getMimeDecoder();
        String res = str;
        try {
            res = new String(decoder.decode(str));
        }
        catch (Throwable e) {
            logger.error(str + " decode failed", e);
        }
        return res;
    }
}

