/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.apache.linkis.metadata.hive.config.DataSource;
import org.apache.linkis.metadata.hive.dao.HiveMetaDao;
import org.apache.linkis.metadata.hive.dto.MetadataQueryParam;
import org.apache.linkis.metadata.service.DataSourceService;
import org.apache.linkis.metadata.service.HiveMetaWithPermissionService;
import org.apache.linkis.metadata.util.DWSConfig;
import org.apache.linkis.metadata.utils.MdqConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HiveMetaWithPermissionServiceImpl
implements HiveMetaWithPermissionService {
    private static final Logger log = LoggerFactory.getLogger(HiveMetaWithPermissionServiceImpl.class);
    @Autowired
    private HiveMetaDao hiveMetaDao;
    @Autowired
    private DataSourceService dataSourceService;
    private final String adminUser = (String)DWSConfig.HIVE_DB_ADMIN_USER.getValue();

    @Override
    public List<String> getDbsOptionalUserName(String userName) {
        if (this.adminUser.equals(userName)) {
            log.info("admin {} to get all dbs ", (Object)userName);
            return this.hiveMetaDao.getAllDbs();
        }
        Boolean flag = (Boolean)DWSConfig.HIVE_PERMISSION_WITH_lOGIN_USER_ENABLED.getValue();
        if (flag.booleanValue()) {
            List<String> roles = this.hiveMetaDao.getRolesByUser(userName);
            return this.hiveMetaDao.getDbsByUserAndRoles(userName, roles);
        }
        log.info("user {} to get all dbs no permission control", (Object)userName);
        return this.hiveMetaDao.getAllDbs();
    }

    @Override
    public List<Map<String, Object>> getTablesByDbNameAndOptionalUserName(MetadataQueryParam queryParam) {
        Boolean flag = (Boolean)DWSConfig.HIVE_PERMISSION_WITH_lOGIN_USER_ENABLED.getValue();
        if (null == queryParam) {
            return null;
        }
        String userName = queryParam.getUserName();
        if (this.adminUser.equals(userName)) {
            log.info("admin {} to get all tables ", (Object)userName);
            return this.hiveMetaDao.getTablesByDbName(queryParam);
        }
        if (flag.booleanValue()) {
            List<String> roles = this.hiveMetaDao.getRolesByUser(queryParam.getUserName());
            queryParam.withRoles(roles);
            return this.hiveMetaDao.getTablesByDbNameAndUserAndRoles(queryParam);
        }
        log.info("user {} to getTablesByDbName no permission control", (Object)queryParam.getUserName());
        return this.hiveMetaDao.getTablesByDbName(queryParam);
    }

    @Override
    @DataSource(name="firstDataSource")
    public JsonNode getColumnsByDbTableNameAndOptionalUserName(MetadataQueryParam queryParam) {
        Boolean flag = (Boolean)DWSConfig.HIVE_PERMISSION_WITH_lOGIN_USER_ENABLED.getValue();
        if (null == queryParam) {
            return null;
        }
        String userName = queryParam.getUserName();
        String dbName = queryParam.getDbName();
        String tableName = queryParam.getTableName();
        if (this.adminUser.equals(userName)) {
            log.info("admin {} to get all tables ", (Object)userName);
            return this.dataSourceService.queryTableMeta(queryParam);
        }
        if (flag.booleanValue()) {
            List<String> roles = this.hiveMetaDao.getRolesByUser(userName);
            queryParam.withRoles(roles);
            Map<String, Object> tableMap = this.hiveMetaDao.getStorageDescriptionIDByDbTableNameAndUser(queryParam);
            if (null != tableMap && !tableMap.isEmpty() && tableMap.containsKey(MdqConstants.SDID_KEY())) {
                String sdid = tableMap.get(MdqConstants.SDID_KEY()).toString();
                queryParam.setSdId(sdid);
                return this.dataSourceService.queryTableMetaBySDID(queryParam);
            }
            log.error("User {} has no read permission for meta of db : {}, table : {}", new Object[]{userName, dbName, tableName});
            return null;
        }
        log.info("user {} to getTablesByDbName no permission control", (Object)userName);
        return this.dataSourceService.queryTableMeta(queryParam);
    }
}

