/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.upstream;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.acessible.executor.conf.AccessibleExecutorConfiguration$;
import org.apache.linkis.engineconn.acessible.executor.service.ExecutorHeartbeatServiceHolder$;
import org.apache.linkis.engineconn.common.exception.EngineConnException;
import org.apache.linkis.engineconn.computation.executor.upstream.SingleThreadUpstreamConnectionMonitor$;
import org.apache.linkis.engineconn.computation.executor.upstream.UpstreamConnectionMonitor;
import org.apache.linkis.engineconn.computation.executor.upstream.access.ConnectionInfoAccess;
import org.apache.linkis.engineconn.computation.executor.upstream.access.ConnectionInfoAccessRequest;
import org.apache.linkis.engineconn.computation.executor.upstream.entity.UpstreamConnection;
import org.apache.linkis.engineconn.computation.executor.upstream.handler.MonitorHandler;
import org.apache.linkis.engineconn.computation.executor.upstream.handler.MonitorHandlerRequest;
import org.apache.linkis.engineconn.computation.executor.upstream.wrapper.ConnectionInfoWrapper;
import org.apache.linkis.engineconn.computation.executor.utlis.ComputationErrorCode$;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.executor.entity.ConcurrentExecutor;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c!B\u000b\u0017\u0003\u0003)\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0006#\u0002!\tA\u0015\u0005\b/\u0002\u0011\r\u0011\"\u0005Y\u0011\u0019I\u0007\u0001)A\u00053\"9!\u000e\u0001b\u0001\n\u0013Y\u0007BB8\u0001A\u0003%A\u000eC\u0004q\u0001\u0001\u0007I\u0011B9\t\u000fU\u0004\u0001\u0019!C\u0005m\"1A\u0010\u0001Q!\nIDQ! \u0001\u0005ByDaa \u0001\u0005B\u0005\u0005\u0001bBA\u0002\u0001\u0019\u0005\u0011Q\u0001\u0005\b\u00033\u0001a\u0011AA\u000e\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u000b\u0001\t\u0003\t9\u0003C\u0004\u0002,\u0001!I!a\n\t\u000f\u00055\u0002\u0001\"\u0005\u00020!9\u0011q\b\u0001\u0005\u0002\u0005\u001d\"!J*j]\u001edW\r\u00165sK\u0006$W\u000b]:ue\u0016\fWnQ8o]\u0016\u001cG/[8o\u001b>t\u0017\u000e^8s\u0015\t9\u0002$\u0001\u0005vaN$(/Z1n\u0015\tI\"$\u0001\u0005fq\u0016\u001cW\u000f^8s\u0015\tYB$A\u0006d_6\u0004X\u000f^1uS>t'BA\u000f\u001f\u0003))gnZ5oK\u000e|gN\u001c\u0006\u0003?\u0001\na\u0001\\5oW&\u001c(BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001M1\u0002\u0004CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002.]5\ta#\u0003\u00020-\tIR\u000b]:ue\u0016\fWnQ8o]\u0016\u001cG/[8o\u001b>t\u0017\u000e^8s!\t\td'D\u00013\u0015\t\u0019D'A\u0003vi&d7O\u0003\u00026=\u000511m\\7n_:L!a\u000e\u001a\u0003\u000f1{wmZ5oO\u0006!a.Y7f!\tQ\u0014I\u0004\u0002<\u007fA\u0011A\bK\u0007\u0002{)\u0011a\bJ\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001C\u0013A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001\u0011\u0015\u0002\u0015%tgm\\!dG\u0016\u001c8\u000f\u0005\u0002G\u00136\tqI\u0003\u0002I-\u00051\u0011mY2fgNL!AS$\u0003)\r{gN\\3di&|g.\u00138g_\u0006\u001b7-Z:t\u0003\u001dA\u0017M\u001c3mKJ\u0004\"!T(\u000e\u00039S!a\u0013\f\n\u0005As%AD'p]&$xN\u001d%b]\u0012dWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM#VK\u0016\t\u0003[\u0001AQ\u0001\u000f\u0003A\u0002eBQ\u0001\u0012\u0003A\u0002\u0015CQa\u0013\u0003A\u00021\u000b!b\u001e:baB,'/T1q+\u0005I\u0006\u0003\u0002.bs\rl\u0011a\u0017\u0006\u00039v\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003En\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\t!w-D\u0001f\u0015\t1g#A\u0004xe\u0006\u0004\b/\u001a:\n\u0005!,'!F\"p]:,7\r^5p]&sgm\\,sCB\u0004XM]\u0001\foJ\f\u0007\u000f]3s\u001b\u0006\u0004\b%A\u0007n_:LGo\u001c:EC\u0016lwN\\\u000b\u0002YB\u0011!,\\\u0005\u0003]n\u00131dU2iK\u0012,H.\u001a3UQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\u0018AD7p]&$xN\u001d#bK6|g\u000eI\u0001\bgR\f'\u000f^3e+\u0005\u0011\bCA\u0014t\u0013\t!\bFA\u0004C_>dW-\u00198\u0002\u0017M$\u0018M\u001d;fI~#S-\u001d\u000b\u0003oj\u0004\"a\n=\n\u0005eD#\u0001B+oSRDqa\u001f\u0006\u0002\u0002\u0003\u0007!/A\u0002yIE\n\u0001b\u001d;beR,G\rI\u0001\u001aO\u0016$X\u000b]:ue\u0016\fWNT8eK&sgm\\!dG\u0016\u001c8\u000fF\u0001F\u0003)9W\r\u001e%b]\u0012dWM\u001d\u000b\u0002\u0019\u0006Ir-\u001a8fe\u0006$X-\u00138g_\u0006\u001b7-Z:t%\u0016\fX/Z:u)\u0011\t9!!\u0004\u0011\u0007\u0019\u000bI!C\u0002\u0002\f\u001d\u00131dQ8o]\u0016\u001cG/[8o\u0013:4w.Q2dKN\u001c(+Z9vKN$\bbBA\b\u001d\u0001\u0007\u0011\u0011C\u0001\foJ\f\u0007\u000f]3s\u0019&\u001cH\u000fE\u0003\u0002\u0014\u0005U1-D\u0001^\u0013\r\t9\"\u0018\u0002\u0005\u0019&\u001cH/\u0001\fhK:,'/\u0019;f\u0011\u0006tG\r\\3s%\u0016\fX/Z:u)\u0011\ti\"a\t\u0011\u00075\u000by\"C\u0002\u0002\"9\u0013Q#T8oSR|'\u000fS1oI2,'OU3rk\u0016\u001cH\u000fC\u0004\u0002\u0010=\u0001\r!!\u0005\u0002\u000bM$\u0018M\u001d;\u0015\u0003]\f\u0001c]2b]>sW-\u0013;fe\u0006$\u0018n\u001c8\u0002#\rdW-\u0019:P]\u0016LE/\u001a:bi&|g.A\u0006qC:L7-\u00134Ok2dG#B<\u00022\u0005m\u0002bBA\u001a'\u0001\u0007\u0011QG\u0001\u0004_\nT\u0007cA\u0014\u00028%\u0019\u0011\u0011\b\u0015\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002>M\u0001\r!O\u0001\u0004[N<\u0017\u0001C:ikR$wn\u001e8")
public abstract class SingleThreadUpstreamConnectionMonitor
implements UpstreamConnectionMonitor,
Logging {
    private final ConnectionInfoAccess infoAccess;
    private final MonitorHandler handler;
    private final ConcurrentHashMap<String, ConnectionInfoWrapper> wrapperMap;
    private final ScheduledThreadPoolExecutor monitorDaemon;
    private boolean started;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SingleThreadUpstreamConnectionMonitor singleThreadUpstreamConnectionMonitor = this;
        synchronized (singleThreadUpstreamConnectionMonitor) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ConcurrentHashMap<String, ConnectionInfoWrapper> wrapperMap() {
        return this.wrapperMap;
    }

    private ScheduledThreadPoolExecutor monitorDaemon() {
        return this.monitorDaemon;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    @Override
    public ConnectionInfoAccess getUpstreamNodeInfoAccess() {
        return this.infoAccess;
    }

    @Override
    public MonitorHandler getHandler() {
        return this.handler;
    }

    public abstract ConnectionInfoAccessRequest generateInfoAccessRequest(java.util.List<ConnectionInfoWrapper> var1);

    public abstract MonitorHandlerRequest generateHandlerRequest(java.util.List<ConnectionInfoWrapper> var1);

    public synchronized void start() {
        if (this.started()) {
            throw new EngineConnException(ComputationErrorCode$.MODULE$.START_UPSTREAM_MONITOR_TWICE(), "cannot start upstream-monitor twice!");
        }
        this.panicIfNull(this.infoAccess, "infoAccess should not be null");
        this.panicIfNull(this.handler, "handler should not be null");
        this.logger().info("started upstream monitor");
        this.monitorDaemon().scheduleAtFixedRate(new Runnable(this){
            private final /* synthetic */ SingleThreadUpstreamConnectionMonitor $outer;

            public void run() {
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.scanOneIteration(), (Function1 & Serializable & scala.Serializable)t -> {
                    $anon$1.$anonfun$run$2(this, t);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$2($anon$1 $this, Throwable t) {
                $this.$outer.logger().error("ClientHeartbeatMonitor failed to scan for one iteration", t);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.engineconn.computation.executor.upstream.SingleThreadUpstreamConnectionMonitor$$anon$1 ), $anonfun$run$2$adapted(org.apache.linkis.engineconn.computation.executor.upstream.SingleThreadUpstreamConnectionMonitor$$anon$1 java.lang.Throwable )}, serializedLambda);
            }
        }, 0L, 5L, TimeUnit.SECONDS);
        this.monitorDaemon().scheduleAtFixedRate(new Runnable(this){
            private final /* synthetic */ SingleThreadUpstreamConnectionMonitor $outer;

            public void run() {
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.org$apache$linkis$engineconn$computation$executor$upstream$SingleThreadUpstreamConnectionMonitor$$clearOneIteration(), (Function1 & Serializable & scala.Serializable)t -> {
                    $anon$2.$anonfun$run$4(this, t);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$4($anon$2 $this, Throwable t) {
                $this.$outer.logger().error("clearWrapperMap has failed for one iteration", t);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$3(org.apache.linkis.engineconn.computation.executor.upstream.SingleThreadUpstreamConnectionMonitor$$anon$2 ), $anonfun$run$4$adapted(org.apache.linkis.engineconn.computation.executor.upstream.SingleThreadUpstreamConnectionMonitor$$anon$2 java.lang.Throwable )}, serializedLambda);
            }
        }, 0L, 1L, TimeUnit.HOURS);
        Utils$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxedUnit.UNIT);
            this.shutdown();
            Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxedUnit.UNIT);
        });
        this.started_$eq(true);
    }

    public void scanOneIteration() {
        this.panicIfNull(this.infoAccess, "connectionInfoAccess should not be null");
        this.panicIfNull(this.handler, "handler should not be null");
        ArrayList<ConnectionInfoWrapper> toBeRequested = new ArrayList<ConnectionInfoWrapper>();
        toBeRequested.addAll(this.wrapperMap().values());
        if (toBeRequested.size() == 0) {
            this.logger().debug("nothing to monitor");
            return;
        }
        this.logger().info(new StringBuilder(28).append("requesting connection info: ").append(Arrays.toString(Collections.list(this.wrapperMap().keys()).toArray())).toString());
        if (BoxesRunTime.unboxToBoolean((Object)AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_SUPPORT_PARALLELISM().getValue())) {
            Executor executor = ExecutorManager$.MODULE$.getInstance().getReportExecutor();
            Executor executor2 = executor;
            if (executor2 instanceof ConcurrentExecutor) {
                ConcurrentExecutor concurrentExecutor = (ConcurrentExecutor)executor2;
                if (toBeRequested.size() > concurrentExecutor.getConcurrentLimit() + 20) {
                    this.logger().warn(new StringBuilder(57).append("Executor running task has exceed the limit ").append(toBeRequested.size()).append(", executor id ").append(concurrentExecutor.getId()).toString());
                    ExecutorHeartbeatServiceHolder$.MODULE$.getDefaultHeartbeatService().setSelfUnhealthy(new StringBuilder(35).append("running task has exceed the limit: ").append(concurrentExecutor.getConcurrentLimit()).toString());
                }
            }
        }
        ConnectionInfoAccessRequest infoAccessRequest = this.generateInfoAccessRequest(toBeRequested);
        List<UpstreamConnection> connectionInfoList = this.infoAccess.getUpstreamInfo(infoAccessRequest);
        this.logger().info(new StringBuilder(27).append("connection-info result: ").append(((UpstreamConnection)connectionInfoList.apply(0)).getUpstreamServiceInstanceName()).append(" : ").append(((UpstreamConnection)connectionInfoList.apply(0)).isAlive()).toString());
        if (connectionInfoList == null || connectionInfoList.size() == 0) {
            this.logger().info("Found none upstream-info");
            return;
        }
        ArrayList<ConnectionInfoWrapper> toBeHandled = new ArrayList<ConnectionInfoWrapper>();
        Map connectionInfoMap = ((TraversableOnce)connectionInfoList.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)x.getKey(), x), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        for (Map.Entry<String, ConnectionInfoWrapper> entry : this.wrapperMap().entrySet()) {
            Object object;
            String key = entry.getKey();
            ConnectionInfoWrapper value = entry.getValue();
            if (connectionInfoMap.contains((Object)key)) {
                value.updateConnectionInfo((UpstreamConnection)connectionInfoMap.get((Object)key).get());
            }
            if (!value.getUpstreamConnection().isAlive()) {
                this.logger().info(new StringBuilder(35).append("Found upstream connection problem: ").append(entry.getValue().toString()).toString());
                object = BoxesRunTime.boxToBoolean((boolean)toBeHandled.add(value));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        Iterator iterator = toBeHandled.iterator();
        while (iterator.hasNext()) {
            this.wrapperMap().remove(((ConnectionInfoWrapper)iterator.next()).getKey());
        }
        if (toBeHandled.size() > 0) {
            MonitorHandlerRequest handlerRequest = this.generateHandlerRequest(toBeHandled);
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.handler.handle(handlerRequest), (Function1 & Serializable & scala.Serializable)t -> {
                SingleThreadUpstreamConnectionMonitor.$anonfun$scanOneIteration$3(this, t);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void org$apache$linkis$engineconn$computation$executor$upstream$SingleThreadUpstreamConnectionMonitor$$clearOneIteration() {
        Iterator<Map.Entry<String, ConnectionInfoWrapper>> entries = this.wrapperMap().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, ConnectionInfoWrapper> entry = entries.next();
            if (!entry.getValue().shouldClear()) continue;
            entries.remove();
        }
    }

    public void panicIfNull(Object obj, String msg) {
        if (obj == null) {
            throw new EngineConnException(ComputationErrorCode$.MODULE$.VARIABLE_NULL_ERROR_CODE(), msg);
        }
    }

    public void shutdown() {
        SingleThreadUpstreamConnectionMonitor singleThreadUpstreamConnectionMonitor = this;
        synchronized (singleThreadUpstreamConnectionMonitor) {
            Object object;
            if (this.started()) {
                this.logger().info("stopping upstream monitor");
                object = this.monitorDaemon().shutdownNow();
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$scanOneIteration$3(SingleThreadUpstreamConnectionMonitor $this, Throwable t) {
        $this.logger().error("failed to handle upstream connection-loss", t);
    }

    public SingleThreadUpstreamConnectionMonitor(String name, ConnectionInfoAccess infoAccess, MonitorHandler handler) {
        this.infoAccess = infoAccess;
        this.handler = handler;
        Logging.$init$((Logging)this);
        this.wrapperMap = new ConcurrentHashMap();
        this.monitorDaemon = new ScheduledThreadPoolExecutor(3, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern(new StringBuilder(3).append(name).append("-%d").toString()).daemon(true).build());
        this.started = false;
    }
}

