/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.acessible.executor.info.NodeHeartbeatMsgManager;
import org.apache.linkis.engineconn.computation.executor.metrics.ComputationEngineConnMetrics$;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.apache.linkis.engineconn.executor.entity.SensibleExecutor;
import org.apache.linkis.engineconn.executor.entity.YarnExecutor;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u000153Aa\u0001\u0003\u0001'!)1\u0006\u0001C\u0001Y!)q\u0006\u0001C!a\tqB)\u001a4bk2$hj\u001c3f\u0011\u0016\f'\u000f\u001e2fCRl5oZ'b]\u0006<WM\u001d\u0006\u0003\u000b\u0019\tqa]3sm&\u001cWM\u0003\u0002\b\u0011\u0005AQ\r_3dkR|'O\u0003\u0002\n\u0015\u0005Y1m\\7qkR\fG/[8o\u0015\tYA\"\u0001\u0006f]\u001eLg.Z2p]:T!!\u0004\b\u0002\r1Lgn[5t\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0006\u000e$!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111$I\u0007\u00029)\u0011QDH\u0001\u0005S:4wN\u0003\u0002\b?)\u0011\u0001EC\u0001\nC\u000e,7o]5cY\u0016L!A\t\u000f\u0003/9{G-\u001a%fCJ$(-Z1u\u001bN<W*\u00198bO\u0016\u0014\bC\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0015)H/\u001b7t\u0015\tAC\"\u0001\u0004d_6lwN\\\u0005\u0003U\u0015\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002[A\u0011a\u0006A\u0007\u0002\t\u0005yq-\u001a;IK\u0006\u0014HOQ3bi6\u001bx\r\u0006\u00022yA\u0011!'\u000f\b\u0003g]\u0002\"\u0001\u000e\f\u000e\u0003UR!A\u000e\n\u0002\rq\u0012xn\u001c;?\u0013\tAd#\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d\u0017\u0011\u00159!\u00011\u0001>!\tq$)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004f]RLG/\u001f\u0006\u0003\u000f)I!aQ \u0003\u0011\u0015CXmY;u_JD#\u0001A#\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015AC:uKJ,w\u000e^=qK*\u0011!\nE\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u0011Aj\u0012\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class DefaultNodeHeartbeatMsgManager
implements NodeHeartbeatMsgManager,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultNodeHeartbeatMsgManager defaultNodeHeartbeatMsgManager = this;
        synchronized (defaultNodeHeartbeatMsgManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String getHeartBeatMsg(Executor executor) {
        HashMap<String, Object> msgMap;
        block2: {
            msgMap = new HashMap<String, Object>();
            msgMap.put(ECConstants$.MODULE$.EC_TICKET_ID_KEY(), EngineConnObject$.MODULE$.getEngineCreationContext().getTicketId());
            msgMap.put(ECConstants$.MODULE$.EC_UNLOCK_TO_SHUTDOWN_TIME_MILLS_KEY(), BoxesRunTime.boxToLong((long)ComputationEngineConnMetrics$.MODULE$.getUnlockToShutdownDurationMills()));
            Executor executor2 = executor;
            if (executor2 instanceof SensibleExecutor) {
                SensibleExecutor sensibleExecutor = (SensibleExecutor)executor2;
                NodeStatus status = sensibleExecutor.getStatus();
                msgMap.put(ECConstants$.MODULE$.EC_TOTAL_UNLOCK_TIME_MILLS_KEY(), BoxesRunTime.boxToLong((long)ComputationEngineConnMetrics$.MODULE$.getTotalUnLockTimeMills(status)));
                msgMap.put(ECConstants$.MODULE$.EC_TOTAL_IDLE_TIME_MILLS_KEY(), BoxesRunTime.boxToLong((long)ComputationEngineConnMetrics$.MODULE$.getTotalIdleTimeMills(status)));
                msgMap.put(ECConstants$.MODULE$.EC_TOTAL_BUSY_TIME_MILLS_KEY(), BoxesRunTime.boxToLong((long)ComputationEngineConnMetrics$.MODULE$.getTotalBusyTimeMills(status)));
                msgMap.put(ECConstants$.MODULE$.EC_TOTAL_LOCK_TIME_MILLS_KEY(), BoxesRunTime.boxToLong((long)ComputationEngineConnMetrics$.MODULE$.getTotalLockTimeMills(status)));
                msgMap.put(ECConstants$.MODULE$.EC_LAST_UNLOCK_TIMESTAMP(), BoxesRunTime.boxToLong((long)ComputationEngineConnMetrics$.MODULE$.getLastUnlockTimestamp(status)));
            }
            Map engineParams = EngineConnObject$.MODULE$.getEngineCreationContext().getOptions();
            Object object = engineParams.containsKey(ECConstants$.MODULE$.YARN_QUEUE_NAME_CONFIG_KEY()) ? msgMap.put(ECConstants$.MODULE$.YARN_QUEUE_NAME_KEY(), engineParams.get(ECConstants$.MODULE$.YARN_QUEUE_NAME_CONFIG_KEY())) : BoxedUnit.UNIT;
            Executor executor3 = executor;
            if (!(executor3 instanceof YarnExecutor)) break block2;
            YarnExecutor yarnExecutor = (YarnExecutor)executor3;
            Object object2 = StringUtils.isNotBlank((CharSequence)yarnExecutor.getQueue()) ? msgMap.put(ECConstants$.MODULE$.YARN_QUEUE_NAME_KEY(), yarnExecutor.getQueue()) : BoxedUnit.UNIT;
            Object object3 = StringUtils.isNotBlank((CharSequence)yarnExecutor.getApplicationId()) ? msgMap.put(ECConstants$.MODULE$.YARN_APPID_NAME_KEY(), yarnExecutor.getApplicationId()) : BoxedUnit.UNIT;
            Object object4 = StringUtils.isNotBlank((CharSequence)yarnExecutor.getApplicationURL()) ? msgMap.put(ECConstants$.MODULE$.YARN_APP_URL_KEY(), yarnExecutor.getApplicationURL()) : BoxedUnit.UNIT;
            if (StringUtils.isNotBlank((CharSequence)yarnExecutor.getYarnMode())) {
                msgMap.put(ECConstants$.MODULE$.YARN_MODE_KEY(), yarnExecutor.getYarnMode());
            }
        }
        return (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> BDPJettyServerHelper$.MODULE$.gson().toJson((Object)msgMap), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                String msgs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)msgMap).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        if (v == null) {
                            return new StringBuilder(6).append(k).append("->null").toString();
                        }
                        return new StringBuilder(2).append(k).append("->").append(v.toString()).toString();
                    }
                    throw new MatchError((Object)tuple2);
                }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
                String errMsg = exception.getMessage();
                this.logger().error(new StringBuilder(60).append("Convert msgMap to json failed because : ").append(errMsg).append(", msgMap values : {").append(msgs).append("}").toString());
                return new StringBuilder(55).append("{\"errorMsg\":\"Convert msgMap to json failed because : ").append(errMsg).append("\"}").toString();
            }
            throw new MatchError((Object)throwable);
        });
    }

    public DefaultNodeHeartbeatMsgManager() {
        Logging.$init$((Logging)this);
    }
}

