/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.jobhistory.restful.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.jobhistory.conversions.TaskConversions;
import org.apache.linkis.jobhistory.entity.JobHistory;
import org.apache.linkis.jobhistory.entity.MonitorVO;
import org.apache.linkis.jobhistory.service.JobHistoryQueryService;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"query api"})
@RestController
@RequestMapping(path={"/jobhistory/setting"})
public class JobhistorySettingApi {
    @Autowired
    private JobHistoryQueryService jobHistoryQueryService;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @ApiOperation(value="addObserveInfo", notes="add Observe Info", response=Message.class)
    @RequestMapping(path={"/addObserveInfo"}, method={RequestMethod.POST})
    public Message addObserveInfo(HttpServletRequest req, @RequestBody MonitorVO monitor) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"addObserveInfo");
        if (null == monitor.getTaskId()) {
            return Message.error((String)"TaskId can't be empty ");
        }
        if (StringUtils.isBlank((CharSequence)monitor.getReceiver())) {
            return Message.error((String)"Receiver can't be empty");
        }
        if (null == monitor.getExtra()) {
            return Message.error((String)"Extra can't be empty ");
        }
        Map<String, String> extra = monitor.getExtra();
        if (StringUtils.isBlank((CharSequence)extra.getOrDefault("title", ""))) {
            return Message.error((String)"title can't be empty ");
        }
        if (StringUtils.isBlank((CharSequence)extra.getOrDefault("detail", ""))) {
            return Message.error((String)"detail can't be empty ");
        }
        if (StringUtils.isBlank((CharSequence)monitor.getMonitorLevel())) {
            return Message.error((String)"MonitorLevel can't be empty ");
        }
        if (StringUtils.isBlank((CharSequence)monitor.getSubSystemId())) {
            return Message.error((String)"SubSystemId can't be empty ");
        }
        JobHistory jobHistory = this.jobHistoryQueryService.getJobHistoryByIdAndName(monitor.getTaskId(), null);
        if (!username.equals(jobHistory.getSubmitUser())) {
            return Message.error((String)"Only submitUser can change");
        }
        if (TaskConversions.isJobFinished(jobHistory.getStatus())) {
            return Message.error((String)"The task has been completed, and the alarm cannot be set");
        }
        String observeInfoJson = BDPJettyServerHelper.gson().toJson((Object)monitor);
        jobHistory.setObserveInfo(observeInfoJson);
        this.jobHistoryQueryService.changeObserveInfoById(jobHistory);
        return Message.ok();
    }

    @ApiOperation(value="deleteObserveInfo", notes="delete Observe Info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=false, dataType="long", value="taskId")})
    @RequestMapping(path={"/deleteObserveInfo"}, method={RequestMethod.GET})
    public Message deleteObserveInfo(HttpServletRequest req, Long taskId) {
        JobHistory jobHistory;
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"deleteObserveInfo");
        if (!username.equals((jobHistory = this.jobHistoryQueryService.getJobHistoryByIdAndName(taskId, null)).getSubmitUser())) {
            return Message.error((String)"Only submitUser can change");
        }
        if (TaskConversions.isJobFinished(jobHistory.getStatus())) {
            return Message.error((String)"The task has been completed, and the alarm cannot be set");
        }
        jobHistory.setObserveInfo("");
        this.jobHistoryQueryService.changeObserveInfoById(jobHistory);
        return Message.ok();
    }
}

