/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.hadoop.common.utils;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.hadoop.common.conf.HadoopConf;
import org.apache.linkis.hadoop.common.utils.HDFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosUtils.class);
    private static boolean kerberosRefreshStarted = false;
    private static final Object kerberosRefreshLock = new Object();

    private KerberosUtils() {
    }

    private static Configuration createKerberosSecurityConfiguration() {
        Configuration conf = HDFSUtils.getConfiguration((String)HadoopConf.HADOOP_ROOT_USER().getValue());
        conf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.toString());
        return conf;
    }

    public static void createKerberosSecureConfiguration(String keytab, String principal) {
        Configuration conf = KerberosUtils.createKerberosSecurityConfiguration();
        UserGroupInformation.setConfiguration((Configuration)conf);
        try {
            if (!UserGroupInformation.isSecurityEnabled() || UserGroupInformation.getCurrentUser().getAuthenticationMethod() != UserGroupInformation.AuthenticationMethod.KERBEROS || !UserGroupInformation.isLoginKeytabBased()) {
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                LOG.info("Login successfully with keytab: {} and principal: {}", (Object)keytab, (Object)principal);
            } else {
                LOG.info("The user has already logged in using keytab and principal, no action required");
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get either keytab location or principal name in the jdbc executor", (Throwable)e);
        }
    }

    public static boolean runRefreshKerberosLogin() {
        Configuration conf = KerberosUtils.createKerberosSecurityConfiguration();
        UserGroupInformation.setConfiguration((Configuration)conf);
        try {
            if (UserGroupInformation.isLoginKeytabBased()) {
                LOG.debug("Trying re-login from keytab");
                UserGroupInformation.getLoginUser().reloginFromKeytab();
                return true;
            }
            if (UserGroupInformation.isLoginTicketBased()) {
                LOG.debug("Trying re-login from ticket cache");
                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to run kinit for linkis jdbc executor", (Throwable)e);
        }
        LOG.debug("Neither Keytab nor ticket based login. runRefreshKerberosLoginWork() returning false");
        return false;
    }

    public static Long getKerberosRefreshInterval() {
        long refreshInterval;
        String refreshIntervalString = "43200";
        if (System.getenv("LINKIS_KERBEROS_REFRESH_INTERVAL") != null) {
            refreshIntervalString = System.getenv("LINKIS_KERBEROS_REFRESH_INTERVAL");
        }
        try {
            refreshInterval = Long.parseLong(refreshIntervalString);
        }
        catch (NumberFormatException e) {
            LOG.error("Cannot get time in S for the given string, " + refreshIntervalString + " defaulting to 43200 ", (Throwable)e);
            refreshInterval = 43200L;
        }
        return refreshInterval;
    }

    public static Integer kinitFailTimesThreshold() {
        Integer kinitFailThreshold = 5;
        if (System.getenv("LINKIS_KERBEROS_KINIT_FAIL_THRESHOLD") != null) {
            try {
                kinitFailThreshold = new Integer(System.getenv("LINKIS_KERBEROS_KINIT_FAIL_THRESHOLD"));
            }
            catch (Exception e) {
                LOG.error("Cannot get integer value from the given string, " + System.getenv("LINKIS_KERBEROS_KINIT_FAIL_THRESHOLD") + " defaulting to " + kinitFailThreshold, (Throwable)e);
            }
        }
        return kinitFailThreshold;
    }

    public static void checkStatus() {
        try {
            LOG.info("isSecurityEnabled:" + UserGroupInformation.isSecurityEnabled());
            LOG.info("userAuthenticationMethod:" + UserGroupInformation.getLoginUser().getAuthenticationMethod());
            UserGroupInformation loginUsr = UserGroupInformation.getLoginUser();
            UserGroupInformation curUsr = UserGroupInformation.getCurrentUser();
            LOG.info("LoginUser: " + loginUsr);
            LOG.info("CurrentUser: " + curUsr);
            if (curUsr == null) {
                LOG.info("CurrentUser is null");
            } else {
                LOG.info("CurrentUser is not null");
            }
            if (loginUsr.getClass() != curUsr.getClass()) {
                LOG.info("getClass() is different");
            } else {
                LOG.info("getClass() is same");
            }
            if (loginUsr.equals((Object)curUsr)) {
                LOG.info("subject is equal");
            } else {
                LOG.info("subject is not equal");
            }
        }
        catch (Exception e) {
            LOG.error("UGI error: ", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startKerberosRefreshThread() {
        if (kerberosRefreshStarted || !HadoopConf.KERBEROS_ENABLE()) {
            LOG.warn("kerberos refresh thread had start or not kerberos {}", (Object)HadoopConf.HDFS_ENABLE_CACHE());
            return;
        }
        Object object = kerberosRefreshLock;
        synchronized (object) {
            if (kerberosRefreshStarted) {
                LOG.warn("kerberos refresh thread had start");
                return;
            }
            kerberosRefreshStarted = true;
            LOG.info("kerberos Refresh tread started");
            Utils.defaultScheduler().scheduleAtFixedRate(() -> {
                try {
                    KerberosUtils.checkStatus();
                    if (UserGroupInformation.isLoginKeytabBased()) {
                        LOG.info("Trying re-login from keytab");
                        UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
                    } else if (UserGroupInformation.isLoginTicketBased()) {
                        LOG.info("Trying re-login from ticket cache");
                        UserGroupInformation.getLoginUser().reloginFromTicketCache();
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to re-login", (Throwable)e);
                }
            }, KerberosUtils.getKerberosRefreshInterval(), KerberosUtils.getKerberosRefreshInterval(), TimeUnit.SECONDS);
        }
    }
}

