/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.core.containerization.strategy;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.ecm.core.conf.ContainerizationConf;
import org.apache.linkis.ecm.core.containerization.strategy.MappingPortStrategy;

public class StaticMappingPortStrategy
implements MappingPortStrategy {
    private static final AtomicInteger currentIndex = new AtomicInteger(0);

    @Override
    public int availablePort() throws IOException {
        return this.getNewPort(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewPort(int retryNum) throws IOException {
        int[] portRange = this.getPortRange();
        if (retryNum == 0) {
            throw new IOException("No available port in the portRange: " + (String)ContainerizationConf.ENGINE_CONN_CONTAINERIZATION_MAPPING_STATTIC_PORT_RANGE().getValue());
        }
        this.moveIndex();
        int minPort = portRange[0];
        int newPort = minPort + currentIndex.get() - 1;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(newPort);
        }
        catch (Exception e) {
            int n;
            try {
                n = this.getNewPort(--retryNum);
            }
            catch (Throwable throwable) {
                IOUtils.close(socket);
                throw throwable;
            }
            IOUtils.close((Closeable)socket);
            return n;
        }
        IOUtils.close((Closeable)socket);
        return newPort;
    }

    private synchronized void moveIndex() {
        int poolSize = this.getPoolSize();
        currentIndex.set(currentIndex.get() % poolSize + 1);
    }

    private int[] getPortRange() {
        String portRange = (String)ContainerizationConf.ENGINE_CONN_CONTAINERIZATION_MAPPING_STATTIC_PORT_RANGE().getValue();
        return Arrays.stream(portRange.split("-")).mapToInt(Integer::parseInt).toArray();
    }

    private int getPoolSize() {
        int[] portRange = this.getPortRange();
        int minPort = portRange[0];
        int maxPort = portRange[1];
        return maxPort - minPort + 1;
    }
}

