/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.codec.language.Soundex;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="soundex", value="_FUNC_(string) - Returns soundex code of the string.", extended="The soundex code consist of the first letter of the name followed by three digits.\nExample:\n > SELECT _FUNC_('Miller');\n M460")
public class GenericUDFSoundex
extends GenericUDF {
    private final transient ObjectInspectorConverters.Converter[] textConverters = new ObjectInspectorConverters.Converter[1];
    private final transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[1];
    private final transient Soundex soundex = new Soundex();
    private final Text output = new Text();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException(this.getFuncName() + " requires 1 argument, got " + arguments.length);
        }
        this.checkIfPrimitive(arguments, 0, "1st");
        this.checkIfStringGroup(arguments, 0, "1st");
        this.getStringConverter(arguments, 0, "1st");
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        String soundexCode;
        Object obj0 = arguments[0].get();
        if (obj0 == null) {
            return null;
        }
        String str0 = this.textConverters[0].convert(obj0).toString();
        try {
            soundexCode = this.soundex.soundex(str0);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        this.output.set(soundexCode);
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    protected void checkIfPrimitive(ObjectInspector[] arguments, int i, String argOrder) throws UDFArgumentTypeException {
        ObjectInspector.Category oiCat = arguments[i].getCategory();
        if (oiCat != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(i, this.getFuncName() + " only takes primitive types as " + argOrder + " argument, got " + (Object)((Object)oiCat));
        }
    }

    protected void checkIfStringGroup(ObjectInspector[] arguments, int i, String argOrder) throws UDFArgumentTypeException {
        this.inputTypes[i] = ((PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory();
        if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.inputTypes[i]) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.inputTypes[i]) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP) {
            throw new UDFArgumentTypeException(i, this.getFuncName() + " only takes STRING_GROUP types as " + argOrder + " argument, got " + (Object)((Object)this.inputTypes[i]));
        }
    }

    protected void getStringConverter(ObjectInspector[] arguments, int i, String argOrder) throws UDFArgumentTypeException {
        this.textConverters[i] = ObjectInspectorConverters.getConverter(arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
    }

    @Override
    protected String getFuncName() {
        return "soundex";
    }
}

